/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphType;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.Morph;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Cow;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class MorphCow
extends Morph {
    private ArrayList<Cow> cows = new ArrayList();
    private boolean activated = false;

    public MorphCow(UUID uuid) {
        super(uuid, MorphType.COW);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.MORPH_SKILL_IS_ACTIVATED.getFormatMessage().replace("{MORPH}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.activated = true;
        SoundEffect.ENTITY_COW_AMBIENT.playSound(this.getPlayer());
        for (int i = 0; i < 8; ++i) {
            Cow cow = (Cow)this.getPlayer().getWorld().spawn(this.getPlayer().getLocation(), Cow.class);
            cow.setVelocity(new Vector((GadgetsMenu.random().nextDouble() - 0.5) / 1.7, 0.3, (GadgetsMenu.random().nextDouble() - 0.5) / 1.7));
            cow.setBaby();
            cow.setAgeLock(true);
            cow.setNoDamageTicks(120);
            cow.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
            this.cows.add(cow);
            Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                @Override
                public void run() {
                    MorphCow.this.clearAll();
                }
            }, 110L);
        }
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Cow cow : this.cows) {
            if (cow != null) {
                ParticleEffect.LAVA.display(cow.getLocation(), 5);
            }
            cow.remove();
        }
        this.cows.clear();
        this.activated = false;
    }
}

