/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphType;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.Morph;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Item;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class MorphPig
extends Morph {
    private boolean activated = false;
    private ArrayList<Item> items = new ArrayList();

    public MorphPig(UUID uuid) {
        super(uuid, MorphType.PIG);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.MORPH_SKILL_IS_ACTIVATED.getFormatMessage().replace("{MORPH}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.activated = true;
        SoundEffect.ENTITY_PIG_AMBIENT.playSound(this.getPlayer());
        Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

            @Override
            public void run() {
                for (int i = 1; i <= 13; ++i) {
                    Item porks = MorphPig.this.getPlayer().getWorld().dropItem(MorphPig.this.getPlayer().getLocation(), ItemUtils.item(UUID.randomUUID().toString(), EnumMaterial.COOKED_PORKCHOP, 0));
                    porks.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    porks.setVelocity(new Vector((GadgetsMenu.random().nextDouble() - 0.5) / 1.7, 0.3, (GadgetsMenu.random().nextDouble() - 0.5) / 1.7));
                    MorphPig.this.items.add(porks);
                }
                SoundEffect.ENTITY_CHICKEN_EGG.playSound(MorphPig.this.getPlayer().getLocation());
                Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        MorphPig.this.clearAll();
                    }
                }, 80L);
            }
        }, 20L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Item item : this.items) {
            item.remove();
        }
        this.items.clear();
        this.activated = false;
    }
}

