/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.pets;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.PetType;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.pets.EntityPet;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.pets.GEntity;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.pets.GEntityType;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.pets.types.GOcelotType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Base64;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Pet
implements Listener {
    public static ArrayList<Entity> entities = new ArrayList();
    private Entity entity;
    private UUID uuid;
    private PetType type;

    public Pet(UUID uuid, final PetType type) {
        this.type = type;
        if (!type.isEnabled()) {
            return;
        }
        if (uuid != null) {
            this.uuid = uuid;
            if (PermissionUtils.noPermission(this.getPlayer(), type.getPermission(), EnumPermission.PETS.getPermission(), true)) {
                GadgetsMenu.getPlayerManager(this.getPlayer()).unequipPet();
                return;
            }
            final PlayerManager pManager = GadgetsMenu.getPlayerManager(this.getPlayer());
            if (pManager.getCurrentPet() != null) {
                pManager.removePet();
            }
            if (this.entity != null && this.entity.isValid()) {
                this.entity.remove();
                this.entity = null;
            }
            GEntityType gEntityType = type.getEntityType();
            Entity pet = this.getPlayer().getWorld().spawnEntity(this.getPlayer().getLocation().clone().add(0.5, 0.25, 0.5), gEntityType.getGEntity().getEntityType());
            pet.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
            pet.setMetadata("GadgetsMenu-Pet", (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
            pet.setMetadata(this.getPlayer().getName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
            pet.setCustomNameVisible(true);
            try {
                pet.setCustomName(ChatUtil.format(pManager.getPetName()).replace("{PLAYER}", pManager.getName()));
            }
            catch (NullPointerException e) {
                pet.setCustomName(ChatUtil.format(pManager.getPetName()));
            }
            pet.setPassenger(null);
            ((Creature)pet).setRemoveWhenFarAway(false);
            ((Creature)pet).setCanPickupItems(false);
            ((LivingEntity)pet).getEquipment().clear();
            this.entity = pet;
            entities.add(pet);
            if (VersionManager.is1_9OrAbove()) {
                try {
                    pet.setGlowing(false);
                    pet.setInvulnerable(true);
                }
                catch (NoSuchMethodError e) {
                    // empty catch block
                }
            }
            if (EntityPet.canBreed(gEntityType.getGEntity().getEntityType())) {
                ((Ageable)pet).setBreed(false);
            }
            if (EntityPet.isTameable(gEntityType.getGEntity().getEntityType()) && (!VersionManager.is1_14OrAbove() || type != PetType.WILD_OCELOT && type != PetType.BABY_WILD_OCELOT)) {
                ((Tameable)pet).setTamed(true);
            }
            EntityPet.setAge(pet, gEntityType.getGEntity().getEntityType(), gEntityType.isBaby());
            this.set(gEntityType.getGEntity(), pet, gEntityType.getGEntity().getEntityType(), gEntityType);
            GadgetsMenu.getNMSManager().removePathfinders(pet);
            BukkitRunnable runnable = new BukkitRunnable(){

                public void run() {
                    try {
                        if (Pet.this.getPlayer() == null || !Pet.this.getPlayer().isOnline()) {
                            if (Pet.this.entity != null && Pet.this.entity.isValid()) {
                                Pet.this.entity.remove();
                                Pet.this.entity = null;
                            }
                            this.cancel();
                            return;
                        }
                        if (Pet.this.entity != null && !WorldUtils.isWorldEnabled(Pet.this.entity.getWorld())) {
                            pManager.removePet();
                            this.cancel();
                            return;
                        }
                        if (Bukkit.getPlayer((UUID)Pet.this.getPlayerUUID()) != null && GadgetsMenu.getPlayerManager(Pet.this.getPlayer()).getCurrentPet() != null && GadgetsMenu.getPlayerManager(Pet.this.getPlayer()).getCurrentPet().getType() == type) {
                            if (Pet.this.entity != null && Pet.this.entity.isValid()) {
                                GadgetsMenu.getNMSManager().followPlayer(Pet.this.getPlayer(), Pet.this.entity, type.getEntityType().getMoveSpeed());
                            }
                        } else {
                            if (Pet.this.entity != null && Pet.this.entity.isValid()) {
                                Pet.this.entity.remove();
                                Pet.this.entity = null;
                            }
                            this.cancel();
                        }
                    }
                    catch (NullPointerException e) {
                        e.printStackTrace();
                        Pet.this.clear();
                        this.cancel();
                    }
                }
            };
            runnable.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 5L, 6L);
            pManager.setCurrentPet(this);
        }
    }

    protected UUID getPlayerUUID() {
        return this.uuid;
    }

    public PetType getType() {
        return this.type;
    }

    public Entity getEntity() {
        return this.entity;
    }

    protected Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.getPlayerUUID());
    }

    public void clear() {
        GadgetsMenu.getPlayerManager(this.getPlayer()).setCurrentPet(null);
        try {
            HandlerList.unregisterAll((Listener)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.entity != null && this.entity.isValid()) {
            this.entity.remove();
            this.entity = null;
        }
        this.uuid = null;
    }

    public static void clearAll() {
        for (Entity entity : entities) {
            if (entity == null || entity.isValid()) continue;
            entity.remove();
        }
        entities.clear();
    }

    private void set(GEntity type, Entity pet, EntityType entityType, GEntityType gEntityType) {
        ItemStack boots;
        ItemStack leggings;
        ItemStack chestplate;
        ItemStack helmet;
        EntityEquipment equipment2;
        if (EntityPet.isCreeper(entityType) && gEntityType.getIsPowered()) {
            EntityPet.setCreeperPowered(pet, gEntityType.getIsPowered());
        }
        if (EntityPet.isHorse(entityType)) {
            if (!VersionManager.is1_11OrAbove()) {
                EntityPet.setHorseVariant(pet, gEntityType.getVariant() == null ? Horse.Variant.HORSE : gEntityType.getVariant());
            }
            EntityPet.setHorseColor(pet, gEntityType.getHorseColor() == null ? Horse.Color.BROWN : gEntityType.getHorseColor());
        }
        if (EntityPet.isOcelot(type)) {
            EntityPet.setOcelotType(pet, gEntityType, gEntityType.getOcelotType() == null ? GOcelotType.BLACK_CAT : gEntityType.getOcelotType());
        }
        if (EntityPet.isRabbit(entityType)) {
            EntityPet.setRabbitType(pet, gEntityType.getRabbitType() == null ? Rabbit.Type.BLACK : gEntityType.getRabbitType());
        }
        if (EntityPet.isSheep(entityType)) {
            EntityPet.setSheepColor(pet, gEntityType.getDyeColor() == null ? DyeColor.WHITE : gEntityType.getDyeColor());
        }
        if (EntityPet.isSkeleton(entityType) && !VersionManager.is1_11OrAbove()) {
            EntityPet.setSkeletonType(pet, gEntityType.getSkeletonType() == null ? Skeleton.SkeletonType.NORMAL : gEntityType.getSkeletonType());
        }
        if (EntityPet.isVillager(entityType)) {
            EntityPet.setVillagerProfession(pet, gEntityType.getProfession() == null ? (VersionManager.is1_14OrAbove() ? Villager.Profession.valueOf((String)"NONE") : Villager.Profession.valueOf((String)"NORMAL")) : gEntityType.getProfession());
            if (VersionManager.is1_14OrAbove()) {
                ((Villager)pet).setVillagerType(Villager.Type.PLAINS);
                ((Villager)pet).setProfession(Villager.Profession.FARMER);
            }
        }
        if (EntityPet.isZombie(entityType) && gEntityType.getProfession() != null) {
            EntityPet.setZombieProfession(pet, gEntityType.getProfession());
        }
        if (VersionManager.is1_11OrAbove() && EntityPet.isLlama(entityType)) {
            EntityPet.setLlamaColor(pet, gEntityType.getLlamaColor());
        }
        if (gEntityType == GEntityType.RED_LITTLE_HELPER) {
            try {
                if (VersionManager.is1_9OrAbove()) {
                    pet.setSilent(true);
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            equipment2 = ((LivingEntity)pet).getEquipment();
            helmet = Pet.skull("d88adb221c6ea4f4e8adba76ef84c2811a60844b4313fc923d1359bce51714ca");
            equipment2.setHelmet(helmet);
            chestplate = Pet.colorLeatherArmor(new ItemStack(Material.LEATHER_CHESTPLATE), Color.RED);
            equipment2.setChestplate(chestplate);
            leggings = Pet.colorLeatherArmor(new ItemStack(Material.LEATHER_LEGGINGS), Color.RED);
            equipment2.setLeggings(leggings);
            boots = Pet.colorLeatherArmor(new ItemStack(Material.LEATHER_BOOTS), Color.RED);
            equipment2.setBoots(boots);
        }
        if (gEntityType == GEntityType.GREEN_LITTLE_HELPER) {
            try {
                if (VersionManager.is1_9OrAbove()) {
                    pet.setSilent(true);
                }
            }
            catch (NoSuchMethodError equipment2) {
                // empty catch block
            }
            equipment2 = ((LivingEntity)pet).getEquipment();
            helmet = Pet.skull("d88adb221c6ea4f4e8adba76ef84c2811a60844b4313fc923d1359bce51714ca");
            equipment2.setHelmet(helmet);
            chestplate = Pet.colorLeatherArmor(new ItemStack(Material.LEATHER_CHESTPLATE), Color.LIME);
            equipment2.setChestplate(chestplate);
            leggings = Pet.colorLeatherArmor(new ItemStack(Material.LEATHER_LEGGINGS), Color.LIME);
            equipment2.setLeggings(leggings);
            boots = Pet.colorLeatherArmor(new ItemStack(Material.LEATHER_BOOTS), Color.LIME);
            equipment2.setBoots(boots);
        }
    }

    private static ItemStack colorLeatherArmor(ItemStack itemStack, Color color) {
        LeatherArmorMeta itemMeta = (LeatherArmorMeta)itemStack.getItemMeta();
        itemMeta.setColor(color);
        itemStack.setItemMeta((ItemMeta)itemMeta);
        return itemStack;
    }

    private static ItemStack skull(String url) {
        url = "http://textures.minecraft.net/texture/" + url;
        ItemStack head = new ItemStack(EnumMaterial.PLAYER_HEAD.getType(), 1, (short)EnumMaterial.PLAYER_HEAD.getData());
        SkullMeta skullMeta = (SkullMeta)head.getItemMeta();
        if (url.isEmpty()) {
            return head;
        }
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        byte[] encodedData = Base64.getEncoder().encode(String.format("{textures:{SKIN:{url:\"%s\"}}}", url).getBytes());
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", new String(encodedData)));
        try {
            Field profileField = skullMeta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(skullMeta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e1) {
            e1.printStackTrace();
        }
        head.setItemMeta((ItemMeta)skullMeta);
        return head;
    }
}

