/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.pets;

import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.PetCategoryType;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.pets.GEntityType;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Rarity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.bukkit.Color;

public class PetType {
    private static final List<PetType> ENABLED = new ArrayList<PetType>();
    private static final List<PetType> VALUES = new ArrayList<PetType>();
    private static final HashMap<EnumPetType, ArrayList<PetType>> GROUPS = new HashMap();
    public static final PetType COW = new PetType("Cow", "Cow", "&aCow", new GMaterial(EnumMaterial.LEATHER), "gadgetsmenu.pets.cow", 10, Rarity.COMMON, null, GEntityType.COW);
    public static final PetType BABY_COW = new PetType("Cow", "Baby Cow", "&9Cow (Baby)", new GMaterial(EnumMaterial.WHEAT), "gadgetsmenu.pets.babycow", 30, Rarity.RARE, null, GEntityType.BABY_COW);
    public static final PetType MUSHROOM_COW = new PetType("Cow", "Mushroom Cow", "&5Mushroom Cow", new GMaterial(EnumMaterial.RED_MUSHROOM), "gadgetsmenu.pets.mushroomcow", 50, Rarity.EPIC, null, GEntityType.MUSHROOM_COW);
    public static final PetType BABY_MUSHROOM_COW = new PetType("Cow", "Baby Mushroom Cow", "&6Mushroom Cow (Baby)", new GMaterial(EnumMaterial.MUSHROOM_STEW), "gadgetsmenu.pets.babymushroomcow", 90, Rarity.LEGENDARY, null, GEntityType.BABY_MUSHROOM_COW);
    public static final PetType CHICKEN = new PetType("Chicken", "Chicken", "&aChicken", new GMaterial(EnumMaterial.FEATHER), "gadgetsmenu.pets.chicken", 10, Rarity.COMMON, null, GEntityType.CHICKEN);
    public static final PetType BABY_CHICKEN = new PetType("Chicken", "Baby Chicken", "&9Chicken (Baby)", new GMaterial(EnumMaterial.WHEAT_SEEDS), "gadgetsmenu.pets.babychicken", 30, Rarity.RARE, null, GEntityType.BABY_CHICKEN);
    public static final PetType WOLF = new PetType("Wolf", "Wolf", "&aWolf", new GMaterial(EnumMaterial.BONE), "gadgetsmenu.pets.wolf", 10, Rarity.COMMON, null, GEntityType.WOLF);
    public static final PetType BABY_WOLF = new PetType("Wolf", "Baby Wolf", "&9Wolf (Baby)", new GMaterial(EnumMaterial.BONE_MEAL), "gadgetsmenu.pets.babywolf", 30, Rarity.RARE, null, GEntityType.BABY_WOLF);
    public static final PetType PIG = new PetType("Pig", "Pig", "&aPig", new GMaterial(EnumMaterial.COOKED_PORKCHOP), "gadgetsmenu.pets.pig", 10, Rarity.COMMON, null, GEntityType.PIG);
    public static final PetType BABY_PIG = new PetType("Pig", "Baby Pig", "&9Pig (Baby)", new GMaterial(EnumMaterial.CARROT), "gadgetsmenu.pets.babypig", 30, Rarity.RARE, null, GEntityType.BABY_PIG);
    public static final PetType PIG_ZOMBIE = new PetType("Pig", "Pig Zombie", "&5Pig Zombie", new GMaterial(EnumMaterial.GOLD_INGOT), "gadgetsmenu.pets.pigzombie", 50, Rarity.EPIC, null, GEntityType.PIG_ZOMBIE);
    public static final PetType BABY_PIG_ZOMBIE = new PetType("Pig", "Baby Pig Zombie", "&6Pig Zombie (Baby)", new GMaterial(EnumMaterial.GOLD_NUGGET), "gadgetsmenu.pets.babypigzombie", 85, Rarity.LEGENDARY, null, GEntityType.BABY_PIG_ZOMBIE);
    public static final PetType SILVERFISH = new PetType("Silverfish", "Silverfish", "&aSilverfish", new GMaterial(EnumMaterial.SILVERFISH_SPAWN_EGG), "gadgetsmenu.pets.silverfish", 12, Rarity.COMMON, null, GEntityType.SILVERFISH);
    public static final PetType ENDERMITE = new PetType("Endermite", "Endermite", "&6Endermite", new GMaterial(EnumMaterial.ENDERMITE_SPAWN_EGG), "gadgetsmenu.pets.endermite", 55, Rarity.LEGENDARY, null, GEntityType.ENDERMITE);
    public static final PetType ZOMBIE = new PetType("Zombie", "Zombie", "&aZombie", new GMaterial(EnumMaterial.ROTTEN_FLESH), "gadgetsmenu.pets.zombie", 12, Rarity.COMMON, null, GEntityType.ZOMBIE);
    public static final PetType BABY_ZOMBIE = new PetType("Zombie", "Baby Zombie", "&9Zombie (Baby)", new GMaterial(EnumMaterial.POTATO), "gadgetsmenu.pets.babyzombie", 50, Rarity.RARE, null, GEntityType.BABY_ZOMBIE);
    public static final PetType HUSK = new PetType("Zombie", "Husk", "&9Zombie Husk", new GMaterial("head:d674c63c8db5f4ca628d69a3b1f8a36e29d8fd775e1a6bdb6cabb4be4db121"), "gadgetsmenu.pets.husk", 45, Rarity.RARE, null, GEntityType.HUSK);
    public static final PetType BABY_HUSK = new PetType("Zombie", "Baby Husk", "&5Zombie Husk (Baby)", new GMaterial("head:d674c63c8db5f4ca628d69a3b1f8a36e29d8fd775e1a6bdb6cabb4be4db121"), "gadgetsmenu.pets.babyhusk", 60, Rarity.EPIC, null, GEntityType.BABY_HUSK);
    public static final PetType RED_LITTLE_HELPER = new PetType("Zombie", "Red Little Helper", "&5Red Little Helper", new GMaterial(EnumMaterial.LEATHER_HELMET, Color.RED), "gadgetsmenu.pets.redlittlehelper", 50, Rarity.EPIC, null, GEntityType.RED_LITTLE_HELPER);
    public static final PetType GREEN_LITTLE_HELPER = new PetType("Zombie", "Green Little Helper", "&5Green Little Helper", new GMaterial(EnumMaterial.LEATHER_HELMET, Color.LIME), "gadgetsmenu.pets.greenlittlehelper", 30, Rarity.EPIC, null, GEntityType.GREEN_LITTLE_HELPER);
    public static final PetType BLACK_CAT = new PetType("Cat", "Black Cat", "&aCat: Black", new GMaterial(EnumMaterial.BLACK_WOOL), "gadgetsmenu.pets.blackcat", 12, Rarity.COMMON, null, GEntityType.BLACK_CAT);
    public static final PetType BABY_BLACK_CAT = new PetType("Cat", "Baby Black Cat", "&9Cat: Black (Baby)", new GMaterial(EnumMaterial.BLACK_CARPET), "gadgetsmenu.pets.babyblackcat", 30, Rarity.RARE, null, GEntityType.BABY_BLACK_CAT);
    public static final PetType RED_CAT = new PetType("Cat", "Red Cat", "&aCat: Red", new GMaterial(EnumMaterial.RED_WOOL), "gadgetsmenu.pets.redcat", 12, Rarity.COMMON, null, GEntityType.RED_CAT);
    public static final PetType BABY_RED_CAT = new PetType("Cat", "Baby Red Cat", "&9Cat: Red (Baby)", new GMaterial(EnumMaterial.RED_CARPET), "gadgetsmenu.pets.babyredcat", 30, Rarity.RARE, null, GEntityType.BABY_RED_CAT);
    public static final PetType SIAMESE_CAT = new PetType("Cat", "Siamese Cat", "&aCat: Siamese", new GMaterial(EnumMaterial.GRAY_WOOL), "gadgetsmenu.pets.siamesecat", 12, Rarity.COMMON, null, GEntityType.SIAMESE_CAT);
    public static final PetType BABY_SIAMESE_CAT = new PetType("Cat", "Baby Siamese Cat", "&9Cat: Siamese (Baby)", new GMaterial(EnumMaterial.GRAY_CARPET), "gadgetsmenu.pets.babysiamesecat", 30, Rarity.RARE, null, GEntityType.BABY_SIAMESE_CAT);
    public static final PetType WILD_OCELOT = new PetType("Cat", "Wild Ocelot", "&9Wild Ocelot", new GMaterial(EnumMaterial.ORANGE_WOOL), "gadgetsmenu.pets.wildocelot", 15, Rarity.RARE, null, GEntityType.WILD_OCELOT);
    public static final PetType BABY_WILD_OCELOT = new PetType("Cat", "Baby Wild Ocelot", "&5Wild Ocelot (Baby)", new GMaterial(EnumMaterial.ORANGE_CARPET), "gadgetsmenu.pets.babywildocelot", 35, Rarity.EPIC, null, GEntityType.BABY_WILD_OCELOT);
    public static final PetType BLACK_RABBIT = new PetType("Rabbit", "Black Rabbit", "&9Rabbit: Black", new GMaterial("head:72c58116a147d1a9a26269224a8be184fe8e5f3f3df9b61751369ad87382ec9"), "gadgetsmenu.pets.blackrabbit", 22, Rarity.RARE, null, GEntityType.BLACK_RABBIT);
    public static final PetType BABY_BLACK_RABBIT = new PetType("Rabbit", "Baby Black Rabbit", "&5Rabbit: Black (Baby)", new GMaterial(EnumMaterial.CARROT), "gadgetsmenu.pets.babyblackrabbit", 28, Rarity.EPIC, null, GEntityType.BABY_BLACK_RABBIT);
    public static final PetType BLACK_AND_WHITE_RABBIT = new PetType("Rabbit", "Black & White Rabbit", "&5Rabbit: Black & White", new GMaterial("head:cb8cff4b15b8ca37e25750f345718f289cb22c5b3ad22627a71223faccc"), "gadgetsmenu.pets.blackandwhiterabbit", 45, Rarity.EPIC, null, GEntityType.BLACK_AND_WHITE_RABBIT);
    public static final PetType BABY_BLACK_AND_WHITE_RABBIT = new PetType("Rabbit", "Baby Black & White Rabbit", "&6Rabbit: Black & White (Baby)", new GMaterial(EnumMaterial.CARROT), "gadgetsmenu.pets.babyblackandwhiterabbit", 51, Rarity.LEGENDARY, null, GEntityType.BABY_BLACK_AND_WHITE_RABBIT);
    public static final PetType BROWN_RABBIT = new PetType("Rabbit", "Brown Rabbit", "&9Rabbit: Brown", new GMaterial("head:7d1169b2694a6aba826360992365bcda5a10c89a3aa2b48c438531dd8685c3a7"), "gadgetsmenu.pets.brownrabbit", 22, Rarity.RARE, null, GEntityType.BROWN_RABBIT);
    public static final PetType BABY_BROWN_RABBIT = new PetType("Rabbit", "Baby Brown Rabbit", "&5Rabbit: Brown (Baby)", new GMaterial(EnumMaterial.CARROT), "gadgetsmenu.pets.babybrownrabbit", 28, Rarity.EPIC, null, GEntityType.BABY_BROWN_RABBIT);
    public static final PetType GOLD_RABBIT = new PetType("Rabbit", "Gold Rabbit", "&5Rabbit: Gold", new GMaterial("head:c977a3266bf3b9eaf17e5a02ea5fbb46801159863dd288b93e6c12c9cb"), "gadgetsmenu.pets.goldrabbit", 45, Rarity.EPIC, null, GEntityType.GOLD_RABBIT);
    public static final PetType BABY_GOLD_RABBIT = new PetType("Rabbit", "Baby Gold Rabbit", "&6Rabbit: Gold (Baby)", new GMaterial(EnumMaterial.CARROT), "gadgetsmenu.pets.babygoldrabbit", 51, Rarity.LEGENDARY, null, GEntityType.BABY_GOLD_RABBIT);
    public static final PetType SALT_AND_PEPPER_RABBIT = new PetType("Rabbit", "Salt & Pepper Rabbit", "&5Rabbit: Salt & Pepper", new GMaterial("head:dc29aebe803e5d4dc3b010c9dd56444f863b2d86a6a2afd4a6a721748ba4fa"), "gadgetsmenu.pets.saltandpepperrabbit", 45, Rarity.EPIC, null, GEntityType.SALT_AND_PEPPER_RABBIT);
    public static final PetType BABY_SALT_AND_PEPPER_RABBIT = new PetType("Rabbit", "Baby Salt & Pepper Rabbit", "&6Rabbit: Salt & Pepper (Baby)", new GMaterial(EnumMaterial.CARROT), "gadgetsmenu.pets.babysaltandpepperrabbit", 51, Rarity.LEGENDARY, null, GEntityType.BABY_SALT_AND_PEPPER_RABBIT);
    public static final PetType WHITE_RABBIT = new PetType("Rabbit", "White Rabbit", "&9Rabbit: White", new GMaterial("head:374d8298797e712bb1f75ad6ffa7734ac4237ea69be1db92f0e41115a2c170cf"), "gadgetsmenu.pets.whiterabbit", 22, Rarity.RARE, null, GEntityType.WHITE_RABBIT);
    public static final PetType BABY_WHITE_RABBIT = new PetType("Rabbit", "Baby White Rabbit", "&5Rabbit: White (Baby)", new GMaterial(EnumMaterial.CARROT), "gadgetsmenu.pets.babywhiterabbit", 28, Rarity.EPIC, null, GEntityType.BABY_WHITE_RABBIT);
    public static final PetType BLACK_SHEEP = new PetType("Sheep", "Black Sheep", "&5Sheep: Black", new GMaterial(EnumMaterial.BLACK_TERRACOTTA), "gadgetsmenu.pets.blacksheep", 40, Rarity.EPIC, null, GEntityType.BLACK_SHEEP);
    public static final PetType BABY_BLACK_SHEEP = new PetType("Sheep", "Baby Black Sheep", "&6Sheep: Black (Baby)", new GMaterial(EnumMaterial.BLACK_WOOL), "gadgetsmenu.pets.babyblacksheep", 75, Rarity.LEGENDARY, null, GEntityType.BABY_BLACK_SHEEP);
    public static final PetType BLUE_SHEEP = new PetType("Sheep", "Blue Sheep", "&9Sheep: Blue", new GMaterial(EnumMaterial.BLUE_TERRACOTTA), "gadgetsmenu.pets.bluesheep", 20, Rarity.RARE, null, GEntityType.BLUE_SHEEP);
    public static final PetType BABY_BLUE_SHEEP = new PetType("Sheep", "Baby Blue Sheep", "&5Sheep: Blue (Baby)", new GMaterial(EnumMaterial.BLUE_WOOL), "gadgetsmenu.pets.babybluesheep", 55, Rarity.EPIC, null, GEntityType.BABY_BLUE_SHEEP);
    public static final PetType BROWN_SHEEP = new PetType("Sheep", "Brown Sheep", "&aSheep: Brown", new GMaterial(EnumMaterial.BROWN_TERRACOTTA), "gadgetsmenu.pets.brownsheep", 12, Rarity.COMMON, null, GEntityType.BROWN_SHEEP);
    public static final PetType BABY_BROWN_SHEEP = new PetType("Sheep", "Baby Brown Sheep", "&9Sheep: Brown (Baby)", new GMaterial(EnumMaterial.BROWN_WOOL), "gadgetsmenu.pets.babybrownsheep", 30, Rarity.RARE, null, GEntityType.BABY_BROWN_SHEEP);
    public static final PetType CYAN_SHEEP = new PetType("Sheep", "Cyan Sheep", "&9Sheep: Cyan", new GMaterial(EnumMaterial.CYAN_TERRACOTTA), "gadgetsmenu.pets.cyansheep", 20, Rarity.RARE, null, GEntityType.CYAN_SHEEP);
    public static final PetType BABY_CYAN_SHEEP = new PetType("Sheep", "Baby Cyan Sheep", "&5Sheep: Cyan (Baby)", new GMaterial(EnumMaterial.CYAN_WOOL), "gadgetsmenu.pets.babycyansheep", 55, Rarity.EPIC, null, GEntityType.BABY_CYAN_SHEEP);
    public static final PetType GRAY_SHEEP = new PetType("Sheep", "Gray Sheep", "&aSheep: Gray", new GMaterial(EnumMaterial.GRAY_TERRACOTTA), "gadgetsmenu.pets.graysheep", 12, Rarity.COMMON, null, GEntityType.GRAY_SHEEP);
    public static final PetType BABY_GRAY_SHEEP = new PetType("Sheep", "Baby Gray Sheep", "&9Sheep: Gray (Baby)", new GMaterial(EnumMaterial.GRAY_WOOL), "gadgetsmenu.pets.babygraysheep", 30, Rarity.RARE, null, GEntityType.BABY_GRAY_SHEEP);
    public static final PetType GREEN_SHEEP = new PetType("Sheep", "Green Sheep", "&9Sheep: Green", new GMaterial(EnumMaterial.GREEN_TERRACOTTA), "gadgetsmenu.pets.greensheep", 20, Rarity.RARE, null, GEntityType.GREEN_SHEEP);
    public static final PetType BABY_GREEN_SHEEP = new PetType("Sheep", "Baby Green Sheep", "&5Sheep: Green (Baby)", new GMaterial(EnumMaterial.GREEN_WOOL), "gadgetsmenu.pets.babygreensheep", 55, Rarity.EPIC, null, GEntityType.BABY_GREEN_SHEEP);
    public static final PetType LIGHT_BLUE_SHEEP = new PetType("Sheep", "Light Blue Sheep", "&9Sheep: Light Blue", new GMaterial(EnumMaterial.LIGHT_BLUE_TERRACOTTA), "gadgetsmenu.pets.lightbluesheep", 20, Rarity.RARE, null, GEntityType.LIGHT_BLUE_SHEEP);
    public static final PetType BABY_LIGHT_BLUE_SHEEP = new PetType("Sheep", "Baby Light Blue Sheep", "&5Sheep: Light Blue (Baby)", new GMaterial(EnumMaterial.LIGHT_BLUE_WOOL), "gadgetsmenu.pets.babylightbluesheep", 55, Rarity.EPIC, null, GEntityType.BABY_LIGHT_BLUE_SHEEP);
    public static final PetType LIME_SHEEP = new PetType("Sheep", "Lime Sheep", "&9Sheep: Lime", new GMaterial(EnumMaterial.LIME_TERRACOTTA), "gadgetsmenu.pets.limesheep", 20, Rarity.RARE, null, GEntityType.LIME_SHEEP);
    public static final PetType BABY_LIME_SHEEP = new PetType("Sheep", "Baby Lime Sheep", "&5Sheep: Lime (Baby)", new GMaterial(EnumMaterial.LIME_WOOL), "gadgetsmenu.pets.babylimesheep", 55, Rarity.EPIC, null, GEntityType.BABY_LIME_SHEEP);
    public static final PetType MAGENTA_SHEEP = new PetType("Sheep", "Magenta Sheep", "&9Sheep: Magenta", new GMaterial(EnumMaterial.MAGENTA_TERRACOTTA), "gadgetsmenu.pets.magentasheep", 20, Rarity.RARE, null, GEntityType.MAGENTA_SHEEP);
    public static final PetType BABY_MAGENTA_SHEEP = new PetType("Sheep", "Baby Magenta Sheep", "&5Sheep: Magenta (Baby)", new GMaterial(EnumMaterial.MAGENTA_WOOL), "gadgetsmenu.pets.babymagentasheep", 55, Rarity.EPIC, null, GEntityType.BABY_MAGENTA_SHEEP);
    public static final PetType ORANGE_SHEEP = new PetType("Sheep", "Orange Sheep", "&9Sheep: Orange", new GMaterial(EnumMaterial.ORANGE_TERRACOTTA), "gadgetsmenu.pets.orangesheep", 20, Rarity.RARE, null, GEntityType.ORANGE_SHEEP);
    public static final PetType BABY_ORANGE_SHEEP = new PetType("Sheep", "Baby Orange Sheep", "&5Sheep: Orange (Baby)", new GMaterial(EnumMaterial.ORANGE_WOOL), "gadgetsmenu.pets.babyorangesheep", 55, Rarity.EPIC, null, GEntityType.BABY_ORANGE_SHEEP);
    public static final PetType PINK_SHEEP = new PetType("Sheep", "Pink Sheep", "&5Sheep: Pink", new GMaterial(EnumMaterial.PINK_TERRACOTTA), "gadgetsmenu.pets.pinksheep", 55, Rarity.EPIC, null, GEntityType.PINK_SHEEP);
    public static final PetType BABY_PINK_SHEEP = new PetType("Sheep", "Baby Pink Sheep", "&6Sheep: Pink (Baby)", new GMaterial(EnumMaterial.PINK_WOOL), "gadgetsmenu.pets.babypinksheep", 75, Rarity.LEGENDARY, null, GEntityType.BABY_PINK_SHEEP);
    public static final PetType PURPLE_SHEEP = new PetType("Sheep", "Purple Sheep", "&9Sheep: Purple", new GMaterial(EnumMaterial.PURPLE_TERRACOTTA), "gadgetsmenu.pets.purplesheep", 55, Rarity.RARE, null, GEntityType.PURPLE_SHEEP);
    public static final PetType BABY_PURPLE_SHEEP = new PetType("Sheep", "Baby Purple Sheep", "&5Sheep: Purple (Baby)", new GMaterial(EnumMaterial.PURPLE_WOOL), "gadgetsmenu.pets.babypurplesheep", 75, Rarity.EPIC, null, GEntityType.BABY_PURPLE_SHEEP);
    public static final PetType RED_SHEEP = new PetType("Sheep", "Red Sheep", "&9Sheep: Red", new GMaterial(EnumMaterial.RED_TERRACOTTA), "gadgetsmenu.pets.redsheep", 20, Rarity.RARE, null, GEntityType.RED_SHEEP);
    public static final PetType BABY_RED_SHEEP = new PetType("Sheep", "Baby Red Sheep", "&5Sheep: Red (Baby)", new GMaterial(EnumMaterial.RED_WOOL), "gadgetsmenu.pets.babyredsheep", 55, Rarity.EPIC, null, GEntityType.BABY_RED_SHEEP);
    public static final PetType SILVER_SHEEP = new PetType("Sheep", "Silver Sheep", "&aSheep: Silver", new GMaterial(EnumMaterial.LIGHT_GRAY_TERRACOTTA), "gadgetsmenu.pets.silversheep", 12, Rarity.COMMON, null, GEntityType.SILVER_SHEEP);
    public static final PetType BABY_SILVER_SHEEP = new PetType("Sheep", "Baby Silver Sheep", "&9Sheep: Silver (Baby)", new GMaterial(EnumMaterial.LIGHT_GRAY_WOOL), "gadgetsmenu.pets.babysilversheep", 30, Rarity.RARE, null, GEntityType.BABY_SILVER_SHEEP);
    public static final PetType WHITE_SHEEP = new PetType("Sheep", "White Sheep", "&aSheep: White", new GMaterial(EnumMaterial.WHITE_TERRACOTTA), "gadgetsmenu.pets.whitesheep", 12, Rarity.COMMON, null, GEntityType.WHITE_SHEEP);
    public static final PetType BABY_WHITE_SHEEP = new PetType("Sheep", "Baby White Sheep", "&9Sheep: White (Baby)", new GMaterial(EnumMaterial.WHITE_WOOL), "gadgetsmenu.pets.babywhitesheep", 30, Rarity.RARE, null, GEntityType.BABY_WHITE_SHEEP);
    public static final PetType YELLOW_SHEEP = new PetType("Sheep", "Yellow Sheep", "&9Sheep: Yellow", new GMaterial(EnumMaterial.YELLOW_TERRACOTTA), "gadgetsmenu.pets.yellowsheep", 20, Rarity.RARE, null, GEntityType.YELLOW_SHEEP);
    public static final PetType BABY_YELLOW_SHEEP = new PetType("Sheep", "Baby Yellow Sheep", "&5Sheep: Yellow (Baby)", new GMaterial(EnumMaterial.YELLOW_WOOL), "gadgetsmenu.pets.babyyellowsheep", 55, Rarity.EPIC, null, GEntityType.BABY_YELLOW_SHEEP);
    public static final PetType BLACK_HORSE = new PetType("Horse", "Black Horse", "&5Horse: Black", new GMaterial(EnumMaterial.COAL), "gadgetsmenu.pets.blackhorse", 42, Rarity.EPIC, null, GEntityType.BLACK_HORSE);
    public static final PetType BABY_BLACK_HORSE = new PetType("Horse", "Baby Black Horse", "&6Horse: Black (Baby)", new GMaterial(EnumMaterial.CHARCOAL), "gadgetsmenu.pets.babyblackhorse", 60, Rarity.LEGENDARY, null, GEntityType.BABY_BLACK_HORSE);
    public static final PetType BROWN_HORSE = new PetType("Horse", "Brown Horse", "&aHorse: Brown", new GMaterial(EnumMaterial.BRICK), "gadgetsmenu.pets.brownhorse", 15, Rarity.COMMON, null, GEntityType.BROWN_HORSE);
    public static final PetType BABY_BROWN_HORSE = new PetType("Horse", "Baby Brown Horse", "&9Horse: Brown (Baby)", new GMaterial(EnumMaterial.COCOA_BEANS), "gadgetsmenu.pets.babybrownhorse", 30, Rarity.RARE, null, GEntityType.BABY_BROWN_HORSE);
    public static final PetType CHESTNUT_HORSE = new PetType("Horse", "Chestnut Horse", "&9Horse: Chestnut", new GMaterial(EnumMaterial.MELON_SEEDS), "gadgetsmenu.pets.chestnuthorse", 25, Rarity.RARE, null, GEntityType.CHESTNUT_HORSE);
    public static final PetType BABY_CHESTNUT_HORSE = new PetType("Horse", "Baby Chestnut Horse", "&5Horse: Chestnut (Baby)", new GMaterial(EnumMaterial.PUMPKIN_SEEDS), "gadgetsmenu.pets.babychestnuthorse", 55, Rarity.EPIC, null, GEntityType.BABY_CHESTNUT_HORSE);
    public static final PetType CREAMY_HORSE = new PetType("Horse", "Creamy Horse", "&9Horse: Creamy", new GMaterial(EnumMaterial.MILK_BUCKET), "gadgetsmenu.pets.creamyhorse", 25, Rarity.RARE, null, GEntityType.CREAMY_HORSE);
    public static final PetType BABY_CREAMY_HORSE = new PetType("Horse", "Baby Creamy Horse", "&5Horse: Creamy (Baby)", new GMaterial(EnumMaterial.SUGAR), "gadgetsmenu.pets.babycreamyhorse", 55, Rarity.EPIC, null, GEntityType.BABY_CREAMY_HORSE);
    public static final PetType DARK_BROWN_HORSE = new PetType("Horse", "Dark Brown Horse", "&9Horse: Dark Brown", new GMaterial(EnumMaterial.DARK_OAK_LOG), "gadgetsmenu.pets.darkbrownhorse", 25, Rarity.RARE, null, GEntityType.DARK_BROWN_HORSE);
    public static final PetType BABY_DARK_BROWN_HORSE = new PetType("Horse", "Baby Dark Brown Horse", "&5Horse: Dark Brown (Baby)", new GMaterial(EnumMaterial.DARK_OAK_PLANKS), "gadgetsmenu.pets.babydarkbrownhorse", 55, Rarity.EPIC, null, GEntityType.BABY_DARK_BROWN_HORSE);
    public static final PetType GRAY_HORSE = new PetType("Horse", "Gray Horse", "&9Horse: Gray", new GMaterial(EnumMaterial.APPLE), "gadgetsmenu.pets.grayhorse", 25, Rarity.RARE, null, GEntityType.GRAY_HORSE);
    public static final PetType BABY_GRAY_HORSE = new PetType("Horse", "Baby Gray Horse", "&5Horse: Gray (Baby)", new GMaterial(EnumMaterial.GRAY_DYE), "gadgetsmenu.pets.babygrayhorse", 55, Rarity.EPIC, null, GEntityType.BABY_GRAY_HORSE);
    public static final PetType WHITE_HORSE = new PetType("Horse", "White Horse", "&5Horse: White", new GMaterial(EnumMaterial.QUARTZ_BLOCK), "gadgetsmenu.pets.whitehorse", 42, Rarity.EPIC, null, GEntityType.WHITE_HORSE);
    public static final PetType BABY_WHITE_HORSE = new PetType("Horse", "Baby White Horse", "&6Horse: White (Baby)", new GMaterial(EnumMaterial.DIORITE), "gadgetsmenu.pets.babywhitehorse", 60, Rarity.LEGENDARY, null, GEntityType.BABY_WHITE_HORSE);
    public static final PetType DONKEY = new PetType("Horse", "Donkey", "&9Donkey", new GMaterial(EnumMaterial.LEATHER), "gadgetsmenu.pets.donkey", 27, Rarity.RARE, null, GEntityType.DONKEY);
    public static final PetType BABY_DONKEY = new PetType("Horse", "Baby Donkey", "&5Donkey (Baby)", new GMaterial(EnumMaterial.CARROT), "gadgetsmenu.pets.babydonkey", 40, Rarity.EPIC, null, GEntityType.BABY_DONKEY);
    public static final PetType MULE = new PetType("Horse", "Mule", "&9Mule", new GMaterial(EnumMaterial.COOKED_MUTTON), "gadgetsmenu.pets.mule", 22, Rarity.RARE, null, GEntityType.MULE);
    public static final PetType BABY_MULE = new PetType("Horse", "Baby Mule", "&5Mule (Baby)", new GMaterial(EnumMaterial.MUTTON), "gadgetsmenu.pets.babymule", 35, Rarity.EPIC, null, GEntityType.BABY_MULE);
    public static final PetType SKELETON_HORSE = new PetType("Horse", "Skeleton Horse", "&6Skeleton Horse", new GMaterial(EnumMaterial.BONE), "gadgetsmenu.pets.skeletonhorse", 65, Rarity.LEGENDARY, null, GEntityType.SKELETON_HORSE);
    public static final PetType BABY_SKELETON_HORSE = new PetType("Horse", "Baby Skeleton Horse", "&6Skeleton Horse (Baby)", new GMaterial(EnumMaterial.BONE_MEAL), "gadgetsmenu.pets.babyskeletonhorse", 85, Rarity.LEGENDARY, null, GEntityType.BABY_SKELETON_HORSE);
    public static final PetType UNDEAD_HORSE = new PetType("Horse", "Undead Horse", "&5Undead Horse", new GMaterial(EnumMaterial.DARK_OAK_SAPLING), "gadgetsmenu.pets.undeadhorse", 63, Rarity.EPIC, null, GEntityType.UNDEAD_HORSE);
    public static final PetType BABY_UNDEAD_HORSE = new PetType("Horse", "Baby Undead Horse", "&6Undead Horse (Baby)", new GMaterial(EnumMaterial.DEAD_BUSH), "gadgetsmenu.pets.babyundeadhorse", 85, Rarity.LEGENDARY, null, GEntityType.BABY_UNDEAD_HORSE);
    public static final PetType BLACKSMITH_VILLAGER = new PetType("Villager", "Blacksmith Villager", "&9Villager: Blacksmith", new GMaterial(EnumMaterial.IRON_ORE), "gadgetsmenu.pets.blacksmithvillager", 22, Rarity.RARE, null, GEntityType.BLACKSMITH_VILLAGER);
    public static final PetType BABY_BLACKSMITH_VILLAGER = new PetType("Villager", "Baby Blacksmith Villager", "&5Villager: Blacksmith (Baby)", new GMaterial(EnumMaterial.IRON_INGOT), "gadgetsmenu.pets.babyblacksmithvillager", 55, Rarity.EPIC, null, GEntityType.BABY_BLACKSMITH_VILLAGER);
    public static final PetType BUTCHER_VILLAGER = new PetType("Villager", "Butcher Villager", "&9Villager: Butcher", new GMaterial(EnumMaterial.IRON_AXE), "gadgetsmenu.pets.butchervillager", 22, Rarity.RARE, null, GEntityType.BUTCHER_VILLAGER);
    public static final PetType BABY_BUTCHER_VILLAGER = new PetType("Villager", "Baby Butcher Villager", "&5Villager: Butcher (Baby)", new GMaterial(EnumMaterial.WOODEN_AXE), "gadgetsmenu.pets.babybutchervillager", 55, Rarity.EPIC, null, GEntityType.BABY_BUTCHER_VILLAGER);
    public static final PetType FARMER_VILLAGER = new PetType("Villager", "Farmer Villager", "&9Villager: Farmer", new GMaterial(EnumMaterial.IRON_HOE), "gadgetsmenu.pets.farmervillager", 22, Rarity.RARE, null, GEntityType.FARMER_VILLAGER);
    public static final PetType BABY_FARMER_VILLAGER = new PetType("Villager", "Baby Farmer Villager", "&5Villager: Farmer (Baby)", new GMaterial(EnumMaterial.WOODEN_HOE), "gadgetsmenu.pets.babyfarmervillager", 55, Rarity.EPIC, null, GEntityType.BABY_FARMER_VILLAGER);
    public static final PetType LIBRARIAN_VILLAGER = new PetType("Villager", "Librarian Villager", "&9Villager: Librarian", new GMaterial(EnumMaterial.BOOKSHELF), "gadgetsmenu.pets.librarianvillager", 22, Rarity.RARE, null, GEntityType.LIBRARIAN_VILLAGER);
    public static final PetType BABY_LIBRARIAN_VILLAGER = new PetType("Villager", "Baby Librarian Villager", "&5Villager: Librarian (Baby)", new GMaterial(EnumMaterial.BOOK), "gadgetsmenu.pets.babylibrarianvillager", 55, Rarity.EPIC, null, GEntityType.BABY_LIBRARIAN_VILLAGER);
    public static final PetType PRIEST_VILLAGER = new PetType("Villager", "Priest Villager", "&9Villager: Priest", new GMaterial(EnumMaterial.WRITABLE_BOOK), "gadgetsmenu.pets.priestvillager", 22, Rarity.RARE, null, GEntityType.PRIEST_VILLAGER);
    public static final PetType BABY_PRIEST_VILLAGER = new PetType("Villager", "Baby Priest Villager", "&5Villager: Priest (Baby)", new GMaterial(EnumMaterial.MAP), "gadgetsmenu.pets.babypriestvillager", 55, Rarity.EPIC, null, GEntityType.BABY_PRIEST_VILLAGER);
    public static final PetType ZOMBIE_VILLAGER = new PetType("Villager", "Zombie Villager", "&5Villager: Zombie", new GMaterial(EnumMaterial.GOLDEN_APPLE), "gadgetsmenu.pets.zombievillager", 52, Rarity.EPIC, null, GEntityType.ZOMBIE_VILLAGER);
    public static final PetType BABY_ZOMBIE_VILLAGER = new PetType("Villager", "Baby Zombie Villager", "&6Villager: Zombie (Baby)", new GMaterial(EnumMaterial.GOLDEN_HELMET), "gadgetsmenu.pets.babyzombievillager", 75, Rarity.LEGENDARY, null, GEntityType.BABY_ZOMBIE_VILLAGER);
    public static final PetType WITCH = new PetType("Villager", "Witch", "&5Witch", new GMaterial(EnumMaterial.POTION, 8196), "gadgetsmenu.pets.witch", 45, Rarity.EPIC, null, GEntityType.WITCH);
    public static final PetType EVOKER = new PetType("Villager", "Evoker", "&6Evoker", new GMaterial("head:4f6fb89d1c631bd7e79fe185ba1a6705425f5c31a5ff626521e395d4a6f7e2"), "gadgetsmenu.pets.evoker", 80, Rarity.LEGENDARY, null, GEntityType.EVOKER);
    public static final PetType VINDICATOR = new PetType("Villager", "Vindicator", "&6Vindicator", new GMaterial("head:4f6fb89d1c631bd7e79fe185ba1a6705425f5c31a5ff626521e395d4a6f7e2"), "gadgetsmenu.pets.vindicator", 80, Rarity.LEGENDARY, null, GEntityType.VINDICATOR);
    public static final PetType ILLUSIONER = new PetType("Villager", "Illusioner", "&6Illusioner", new GMaterial("head:1c678c9f4c6dd4d991930f82e6e7d8b89b2891f35cba48a4b18539bbe7ec927"), "gadgetsmenu.pets.illusioner", 85, Rarity.LEGENDARY, null, GEntityType.ILLUSIONER);
    public static final PetType SPIDER = new PetType("Spider", "Spider", "&5Spider", new GMaterial(EnumMaterial.SPIDER_EYE), "gadgetsmenu.pets.spider", 42, Rarity.EPIC, null, GEntityType.SPIDER);
    public static final PetType CAVE_SPIDER = new PetType("Spider", "Cave Spider", "&9Cave Spider", new GMaterial(EnumMaterial.STRING), "gadgetsmenu.pets.cavespider", 27, Rarity.RARE, null, GEntityType.CAVE_SPIDER);
    public static final PetType SKELETON = new PetType("Skeleton", "Skeleton", "&5Skeleton", new GMaterial(EnumMaterial.BOW), "gadgetsmenu.pets.skeleton", 50, Rarity.EPIC, null, GEntityType.SKELETON);
    public static final PetType WITHER_SKELETON = new PetType("Skeleton", "Wither Skeleton", "&6Wither Skeleton", new GMaterial(EnumMaterial.STONE_SWORD), "gadgetsmenu.pets.witherskeleton", 70, Rarity.LEGENDARY, null, GEntityType.WITHER_SKELETON);
    public static final PetType STRAY_SKELETON = new PetType("Skeleton", "Stray Skeleton", "&6Stray Skeleton", new GMaterial("head:78ddf76e555dd5c4aa8a0a5fc584520cd63d489c253de969f7f22f85a9a2d56"), "gadgetsmenu.pets.strayskeleton", 85, Rarity.LEGENDARY, null, GEntityType.STRAY_SKELETON);
    public static final PetType BLAZE = new PetType("Blaze", "Blaze", "&6Blaze", new GMaterial(EnumMaterial.BLAZE_ROD), "gadgetsmenu.pets.blaze", 55, Rarity.LEGENDARY, null, GEntityType.BLAZE);
    public static final PetType CREEPER = new PetType("Creeper", "Creeper", "&5Creeper", new GMaterial(EnumMaterial.GUNPOWDER), "gadgetsmenu.pets.creeper", 52, Rarity.EPIC, null, GEntityType.CREEPER);
    public static final PetType POWERED_CREEPER = new PetType("Creeper", "Powered Creeper", "&6Powered Creeper", new GMaterial(EnumMaterial.TNT), "gadgetsmenu.pets.poweredcreeper", 75, Rarity.LEGENDARY, null, GEntityType.POWERED_CREEPER);
    public static final PetType GOLEM = new PetType("Golem", "Golem", "&6Golem", new GMaterial(EnumMaterial.IRON_BLOCK), "gadgetsmenu.pets.golem", 200, Rarity.LEGENDARY, null, GEntityType.GOLEM);
    public static final PetType SNOWMAN = new PetType("Snowman", "Snowman", "&5Snowman", new GMaterial(EnumMaterial.SNOWBALL), "gadgetsmenu.pets.snowman", 52, Rarity.EPIC, null, GEntityType.SNOWMAN);
    public static final PetType POLAR_BEAR = new PetType("Polar Bear", "Polar Bear", "&5Polar Bear", new GMaterial("head:bab178f5cdd750f0e356860aa5539153eb2abec1e146ca57c65d25a5df8fdfe"), "gadgetsmenu.pets.polarbear", 55, Rarity.EPIC, null, GEntityType.POLAR_BEAR);
    public static final PetType BABY_POLAR_BEAR = new PetType("Polar Bear", "Baby Polar Bear", "&6Polar Bear (Baby)", new GMaterial("head:bab178f5cdd750f0e356860aa5539153eb2abec1e146ca57c65d25a5df8fdfe"), "gadgetsmenu.pets.babypolarbear", 75, Rarity.LEGENDARY, null, GEntityType.BABY_POLAR_BEAR);
    public static final PetType BROWN_LLAMA = new PetType("Llama", "Brown Llama", "&5Llama: Brown", new GMaterial("head:c2b1ecff77ffe3b503c30a548eb23a1a08fa26fd67cdff389855d74921368"), "gadgetsmenu.pets.brownllama", 60, Rarity.EPIC, null, GEntityType.BROWN_LLAMA);
    public static final PetType BABY_BROWN_LLAMA = new PetType("Llama", "Baby Brown Llama", "&6Llama: Brown (Baby)", new GMaterial("head:c2b1ecff77ffe3b503c30a548eb23a1a08fa26fd67cdff389855d74921368"), "gadgetsmenu.pets.babybrownllama", 80, Rarity.LEGENDARY, null, GEntityType.BABY_BROWN_LLAMA);
    public static final PetType CREAMY_LLAMA = new PetType("Llama", "Creamy Llama", "&5Llama: Creamy", new GMaterial("head:80899acfebf947a0effc4022deb080543f7e389116bd4964c2c227ffa34a3375"), "gadgetsmenu.pets.creamyllama", 55, Rarity.EPIC, null, GEntityType.CREAMY_LLAMA);
    public static final PetType BABY_CREAMY_LLAMA = new PetType("Llama", "Baby Creamy Llama", "&6Llama: Creamy (Baby)", new GMaterial("head:80899acfebf947a0effc4022deb080543f7e389116bd4964c2c227ffa34a3375"), "gadgetsmenu.pets.babycreamyllama", 75, Rarity.LEGENDARY, null, GEntityType.BABY_CREAMY_LLAMA);
    public static final PetType GRAY_LLAMA = new PetType("Llama", "Gray Llama", "&5Llama: Gray", new GMaterial("head:cf24e56fd9ffd7133da6d1f3e2f455952b1da462686f753c597ee82299a"), "gadgetsmenu.pets.grayllama", 55, Rarity.EPIC, null, GEntityType.GRAY_LLAMA);
    public static final PetType BABY_GRAY_LLAMA = new PetType("Llama", "Baby Gray Llama", "&6Llama: Gray (Baby)", new GMaterial("head:cf24e56fd9ffd7133da6d1f3e2f455952b1da462686f753c597ee82299a"), "gadgetsmenu.pets.babygrayllama", 75, Rarity.LEGENDARY, null, GEntityType.BABY_GRAY_LLAMA);
    public static final PetType WHITE_LLAMA = new PetType("Llama", "White Llama", "&5Llama: White", new GMaterial("head:83d9b5915912ffc2b85761d6adcb428a812f9b83ff634e331162ce46c99e9"), "gadgetsmenu.pets.whitellama", 55, Rarity.EPIC, null, GEntityType.WHITE_LLAMA);
    public static final PetType BABY_WHITE_LLAMA = new PetType("Llama", "Baby White Llama", "&6Llama: White (Baby)", new GMaterial("head:83d9b5915912ffc2b85761d6adcb428a812f9b83ff634e331162ce46c99e9"), "gadgetsmenu.pets.babywhitellama", 75, Rarity.LEGENDARY, null, GEntityType.BABY_WHITE_LLAMA);
    private String group;
    private String name;
    private String displayName;
    private GMaterial material;
    private String permission;
    private int mysteryDust;
    private Rarity rarity;
    private List<String> lore;
    private GEntityType entityType;
    private boolean isEnable;
    private boolean canBeFound;
    private boolean purchasable;

    private PetType(String group, String name, String displayName, GMaterial material, String permission, int mysteryDust, Rarity rarity, List<String> lore, GEntityType entityType) {
        this.group = group;
        this.name = name;
        this.entityType = entityType;
        if (FileManager.getPetsFile().get("Pets." + this.group + ".Types." + this.name + ".Name") == null) {
            this.displayName = displayName;
            FileManager.getPetsFile().set("Pets." + this.group + ".Types." + this.name + ".Name", this.displayName);
        } else {
            this.displayName = FileManager.getPetsFile().getString("Pets." + this.group + ".Types." + this.name + ".Name");
        }
        if (FileManager.getPetsFile().get("Pets." + this.group + ".Types." + this.name + ".Material") == null) {
            this.material = material;
            FileManager.getPetsFile().set("Pets." + this.group + ".Types." + this.name + ".Material", material.getCombinedMaterial());
        } else {
            GMaterial gMaterial;
            this.material = gMaterial = new GMaterial(FileManager.getPetsFile().getString("Pets." + this.group + ".Types." + this.name + ".Material"));
        }
        this.permission = permission;
        if (FileManager.getPetsFile().get("Pets." + this.group + ".Types." + this.name + ".Mystery Dust") == null) {
            this.mysteryDust = mysteryDust;
            FileManager.getPetsFile().set("Pets." + this.group + ".Types." + this.name + ".Mystery Dust", this.mysteryDust);
        } else {
            this.mysteryDust = FileManager.getPetsFile().getInt("Pets." + this.group + ".Types." + this.name + ".Mystery Dust");
        }
        if (FileManager.getPetsFile().get("Pets." + this.group + ".Types." + this.name + ".Rarity") == null) {
            this.rarity = rarity;
            FileManager.getPetsFile().set("Pets." + this.group + ".Types." + this.name + ".Rarity", this.rarity.getName());
        } else {
            this.rarity = Rarity.getName(FileManager.getPetsFile().getString("Pets." + this.group + ".Types." + this.name + ".Rarity"));
        }
        if (FileManager.getPetsFile().get("Pets." + this.group + ".Types." + this.name + ".Enabled") == null) {
            this.isEnable = true;
            FileManager.getPetsFile().set("Pets." + this.group + ".Types." + this.name + ".Enabled", true);
        } else {
            this.isEnable = FileManager.getPetsFile().getBoolean("Pets." + this.group + ".Types." + this.name + ".Enabled");
        }
        if (FileManager.getPetsFile().get("Pets." + this.group + ".Types." + this.name + ".CanBeFound") == null) {
            this.canBeFound = true;
            FileManager.getPetsFile().set("Pets." + this.group + ".Types." + this.name + ".CanBeFound", true);
        } else {
            this.canBeFound = FileManager.getPetsFile().getBoolean("Pets." + this.group + ".Types." + this.name + ".CanBeFound");
        }
        if (FileManager.getPetsFile().get("Pets." + this.group + ".Types." + this.name + ".Purchasable") == null) {
            this.purchasable = true;
            FileManager.getPetsFile().set("Pets." + this.group + ".Types." + this.name + ".Purchasable", true);
        } else {
            this.purchasable = FileManager.getPetsFile().getBoolean("Pets." + this.group + ".Types." + this.name + ".Purchasable");
        }
        if (FileManager.getPetsFile().get("Pets." + this.group + ".Types." + this.name + ".Move-Speed") == null) {
            this.getEntityType().setMoveSpeed(this.getEntityType().getMoveSpeed());
            FileManager.getPetsFile().set("Pets." + this.group + ".Types." + this.name + ".Move-Speed", this.getEntityType().getMoveSpeed());
        } else {
            this.getEntityType().setMoveSpeed(FileManager.getPetsFile().getDouble("Pets." + this.group + ".Types." + this.name + ".Move-Speed"));
        }
        if (FileManager.getPetsFile().get("Pets." + this.group + ".Types." + this.name + ".Lore") == null) {
            this.lore = Arrays.asList("&7Type: &9" + this.getDisplayNameStripColor(), "", "&7Click to summon this pet.");
            if (lore == null) {
                FileManager.getPetsFile().set("Pets." + this.group + ".Types." + this.name + ".Lore", Arrays.asList("&7Type: &9" + this.getDisplayNameStripColor(), "", "&7Click to summon this pet."));
            } else {
                FileManager.getPetsFile().set("Pets." + this.group + ".Types." + this.name + ".Lore", this.lore);
            }
        } else {
            this.lore = FileManager.getPetsFile().getStringList("Pets." + this.group + ".Types." + this.name + ".Lore");
        }
        if (!VALUES.contains(this)) {
            VALUES.add(this);
        }
        if (this.getEntityType().getGEntity().isVersionSupported() && !GROUPS.containsKey((Object)EnumPetType.valueOfByName(this.group))) {
            GROUPS.put(EnumPetType.valueOfByName(this.group), new ArrayList());
        }
        if (!this.getEntityType().getGEntity().isVersionSupported()) {
            if (VALUES.contains(this)) {
                VALUES.remove(this);
            }
            if (ENABLED.contains(this)) {
                ENABLED.remove(this);
            }
        }
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return ChatUtil.format(this.displayName);
    }

    public String getDisplayNameStripColor() {
        return ChatUtil.stripColor(this.displayName);
    }

    public GMaterial getMaterial() {
        return this.material;
    }

    public String getPermission() {
        return this.permission;
    }

    public int getMysteryDust() {
        return this.mysteryDust;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public GEntityType getEntityType() {
        return this.entityType;
    }

    public boolean isEnabled() {
        return PetCategoryType.valueOf(this.group).isEnabled() && this.isEnable;
    }

    public boolean canBeFound() {
        return this.canBeFound;
    }

    public boolean isPurchasable() {
        return this.purchasable;
    }

    public static List<PetType> enabled() {
        return ENABLED;
    }

    public static List<PetType> values() {
        return VALUES;
    }

    public static Set<EnumPetType> groups() {
        return GROUPS.keySet();
    }

    public static void checkEnabled() {
        for (PetType type : PetType.values()) {
            if (type.isEnabled() && !ENABLED.contains(type)) {
                ENABLED.add(type);
            }
            EnumPetType enumPetType = EnumPetType.valueOfByName(type.getGroup());
            if (!type.isEnabled() || !GROUPS.containsKey((Object)enumPetType) || GROUPS.get((Object)enumPetType).contains(type) || !type.getEntityType().getGEntity().isVersionSupported()) continue;
            GROUPS.get((Object)enumPetType).add(type);
        }
    }

    public static List<PetType> getGroup(String name) {
        if (GROUPS.containsKey((Object)EnumPetType.valueOfByName(name))) {
            return GROUPS.get((Object)EnumPetType.valueOfByName(name));
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public static PetType valueOf(String name) throws NullPointerException {
        for (PetType petEntityType : PetType.values()) {
            if (!petEntityType.getName().equalsIgnoreCase(name)) continue;
            return petEntityType;
        }
        return null;
    }

    public static enum EnumPetType {
        COW("Cow"),
        CHICKEN("Chicken"),
        WOLF("Wolf"),
        PIG("Pig"),
        SILVERFISH("Silverfish"),
        ENDERMITE("Endermite"),
        ZOMBIE("Zombie"),
        CAT("Cat"),
        RABBIT("Rabbit"),
        SHEEP("Sheep"),
        HORSE("Horse"),
        VILLAGER("Villager"),
        SPIDER("Spider"),
        SKELETON("Skeleton"),
        BLAZE("Blaze"),
        CREEPER("Creeper"),
        GOLEM("Golem"),
        SNOWMAN("Snowman"),
        POLAR_BEAR("Polar Bear"),
        LLAMA("Llama");

        private String name;

        private EnumPetType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static EnumPetType valueOfByName(String name) throws NullPointerException {
            for (EnumPetType petEntityType : EnumPetType.values()) {
                if (!petEntityType.getName().equalsIgnoreCase(name)) continue;
                return petEntityType;
            }
            return null;
        }
    }
}

