/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.suits;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.CategoryManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitEquipmentType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitType;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.EnumArmorType;
import com.yapzhenyie.GadgetsMenu.utils.EnumEquipType;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SuitManager {
    public static void equipSuit(Player player, SuitType type) {
        if (player == null || GadgetsMenu.getPlayerManager(player) == null) {
            return;
        }
        SuitManager.equipHelmet(player, SuitEquipmentType.getGroup(type.getName()).get(0));
        SuitManager.equipChestplate(player, SuitEquipmentType.getGroup(type.getName()).get(1));
        SuitManager.equipLeggings(player, SuitEquipmentType.getGroup(type.getName()).get(2));
        SuitManager.equipBoots(player, SuitEquipmentType.getGroup(type.getName()).get(3));
    }

    public static void equipHelmet(Player player, SuitEquipmentType type) {
        if (!type.getType().isEnabled() || !Category.SUITS.isEnabled()) {
            return;
        }
        if (player == null) {
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return;
        }
        if (player.getInventory().getHelmet() != null) {
            CategoryManager.removeHelmetCosmetic(player);
            if (player.getInventory().getHelmet() != null) {
                if (CategoryManager.checkEquipRequirement(player, MessageType.REMOVE_ARMOR_TO_EQUIP_SUIT.getFormatMessage())) {
                    return;
                }
                if (GadgetsMenu.getGadgetsMenuData().getEquipCosmeticItemToSlotAction() == EnumEquipType.DROP) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getHelmet().clone());
                        player.getInventory().setHelmet(null);
                        player.updateInventory();
                    });
                }
            }
        }
        if (pManager.getSelectedMorph() != null) {
            pManager.unequipMorph();
        }
        pManager.getSelectedSuitEquipment().put(EnumArmorType.HELMET, type);
        player.getInventory().setHelmet(type.getItemStack());
        SuitType.valueOf(type.getGroup()).equip(player);
    }

    public static void equipChestplate(Player player, SuitEquipmentType type) {
        if (!type.getType().isEnabled() || !Category.SUITS.isEnabled()) {
            return;
        }
        if (player == null) {
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return;
        }
        if (player.getInventory().getChestplate() != null) {
            CategoryManager.removeChestplateCosmetic(player);
            if (player.getInventory().getChestplate() != null) {
                if (CategoryManager.checkEquipRequirement(player, MessageType.REMOVE_ARMOR_TO_EQUIP_SUIT.getFormatMessage())) {
                    return;
                }
                if (GadgetsMenu.getGadgetsMenuData().getEquipCosmeticItemToSlotAction() == EnumEquipType.DROP) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getChestplate().clone());
                        player.getInventory().setChestplate(null);
                        player.updateInventory();
                    });
                }
            }
        }
        if (pManager.getSelectedMorph() != null) {
            pManager.unequipMorph();
        }
        pManager.getSelectedSuitEquipment().put(EnumArmorType.CHESTPLATE, type);
        player.getInventory().setChestplate(type.getItemStack());
        SuitType.valueOf(type.getGroup()).equip(player);
    }

    public static void equipLeggings(Player player, SuitEquipmentType type) {
        if (!type.getType().isEnabled() || !Category.SUITS.isEnabled()) {
            return;
        }
        if (player == null) {
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return;
        }
        if (player.getInventory().getLeggings() != null) {
            CategoryManager.removeLeggingsCosmetic(player);
            if (player.getInventory().getLeggings() != null) {
                if (CategoryManager.checkEquipRequirement(player, MessageType.REMOVE_ARMOR_TO_EQUIP_SUIT.getFormatMessage())) {
                    return;
                }
                if (GadgetsMenu.getGadgetsMenuData().getEquipCosmeticItemToSlotAction() == EnumEquipType.DROP) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getLeggings().clone());
                        player.getInventory().setLeggings(null);
                        player.updateInventory();
                    });
                }
            }
        }
        if (pManager.getSelectedMorph() != null) {
            pManager.unequipMorph();
        }
        pManager.getSelectedSuitEquipment().put(EnumArmorType.LEGGINGS, type);
        player.getInventory().setLeggings(type.getItemStack());
        SuitType.valueOf(type.getGroup()).equip(player);
    }

    public static void equipBoots(Player player, SuitEquipmentType type) {
        if (!type.getType().isEnabled() || !Category.SUITS.isEnabled()) {
            return;
        }
        if (player == null) {
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return;
        }
        if (player.getInventory().getBoots() != null) {
            CategoryManager.removeBootsCosmetic(player);
            if (player.getInventory().getBoots() != null) {
                if (CategoryManager.checkEquipRequirement(player, MessageType.REMOVE_ARMOR_TO_EQUIP_SUIT.getFormatMessage())) {
                    return;
                }
                if (GadgetsMenu.getGadgetsMenuData().getEquipCosmeticItemToSlotAction() == EnumEquipType.DROP) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getBoots().clone());
                        player.getInventory().setBoots(null);
                        player.updateInventory();
                    });
                }
            }
        }
        if (pManager.getSelectedMorph() != null) {
            pManager.unequipMorph();
        }
        pManager.getSelectedSuitEquipment().put(EnumArmorType.BOOTS, type);
        player.getInventory().setBoots(type.getItemStack());
        SuitType.valueOf(type.getGroup()).equip(player);
    }

    public static void unequipSuit(Player player) {
        SuitManager.unequipHelmet(player);
        SuitManager.unequipChestplate(player);
        SuitManager.unequipLeggings(player);
        SuitManager.unequipBoots(player);
    }

    public static void unequipHelmet(Player player) {
        if (player == null) {
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return;
        }
        if (player.getInventory().getHelmet() != null || pManager.getSelectedSuitEquipment().get((Object)EnumArmorType.HELMET) != null) {
            if (player.getInventory().getHelmet() != null && player.getInventory().getHelmet().getItemMeta() != null && GadgetsMenu.getNMSManager().isNBTTagEqual(player.getInventory().getHelmet(), "Category", "Suit")) {
                player.getInventory().setHelmet(null);
                player.updateInventory();
            }
            if (pManager.getCurrentSuit() != null) {
                pManager.getCurrentSuit().onClear();
                pManager.removeSuit();
            }
            if (!pManager.getSelectedSuitEquipment().isEmpty()) {
                pManager.getSelectedSuitEquipment().remove((Object)EnumArmorType.HELMET);
            }
        }
    }

    public static void unequipChestplate(Player player) {
        if (player == null) {
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return;
        }
        if (player.getInventory().getChestplate() != null || pManager.getSelectedSuitEquipment().get((Object)EnumArmorType.CHESTPLATE) != null) {
            if (player.getInventory().getChestplate() != null && player.getInventory().getChestplate().getItemMeta() != null && GadgetsMenu.getNMSManager().isNBTTagEqual(player.getInventory().getChestplate(), "Category", "Suit")) {
                player.getInventory().setChestplate(null);
                player.updateInventory();
            }
            if (pManager.getCurrentSuit() != null) {
                pManager.getCurrentSuit().onClear();
                pManager.removeSuit();
            }
            if (!pManager.getSelectedSuitEquipment().isEmpty()) {
                pManager.getSelectedSuitEquipment().remove((Object)EnumArmorType.CHESTPLATE);
            }
        }
    }

    public static void unequipLeggings(Player player) {
        if (player == null) {
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return;
        }
        if (player.getInventory().getLeggings() != null || pManager.getSelectedSuitEquipment().get((Object)EnumArmorType.LEGGINGS) != null) {
            if (player.getInventory().getLeggings() != null && player.getInventory().getLeggings().getItemMeta() != null && GadgetsMenu.getNMSManager().isNBTTagEqual(player.getInventory().getLeggings(), "Category", "Suit")) {
                player.getInventory().setLeggings(null);
                player.updateInventory();
            }
            if (pManager.getCurrentSuit() != null) {
                pManager.getCurrentSuit().onClear();
                pManager.removeSuit();
            }
            if (!pManager.getSelectedSuitEquipment().isEmpty()) {
                pManager.getSelectedSuitEquipment().remove((Object)EnumArmorType.LEGGINGS);
            }
        }
    }

    public static void unequipBoots(Player player) {
        if (player == null) {
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return;
        }
        if (player.getInventory().getBoots() != null || pManager.getSelectedSuitEquipment().get((Object)EnumArmorType.BOOTS) != null) {
            if (player.getInventory().getBoots() != null && player.getInventory().getBoots().getItemMeta() != null && GadgetsMenu.getNMSManager().isNBTTagEqual(player.getInventory().getBoots(), "Category", "Suit")) {
                player.getInventory().setBoots(null);
                player.updateInventory();
            }
            if (pManager.getCurrentSuit() != null) {
                pManager.getCurrentSuit().onClear();
                pManager.removeSuit();
            }
            if (!pManager.getSelectedSuitEquipment().isEmpty()) {
                pManager.getSelectedSuitEquipment().remove((Object)EnumArmorType.BOOTS);
            }
        }
    }

    public static boolean checkRequirement(Player player, SuitEquipmentType type) {
        if (!type.getType().isEnabled() || !Category.SUITS.isEnabled()) {
            return false;
        }
        if (player == null) {
            return false;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return false;
        }
        if (type.getArmorType() == EnumArmorType.HELMET && player.getInventory().getHelmet() != null) {
            CategoryManager.removeHelmetCosmetic(player);
            if (player.getInventory().getHelmet() != null) {
                if (CategoryManager.checkEquipRequirement(player, MessageType.REMOVE_ARMOR_TO_EQUIP_SUIT.getFormatMessage())) {
                    return false;
                }
                if (GadgetsMenu.getGadgetsMenuData().getEquipCosmeticItemToSlotAction() == EnumEquipType.DROP) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getHelmet().clone());
                        player.getInventory().setHelmet(null);
                        player.updateInventory();
                    });
                }
            }
        }
        if (type.getArmorType() == EnumArmorType.CHESTPLATE && player.getInventory().getChestplate() != null) {
            CategoryManager.removeChestplateCosmetic(player);
            if (player.getInventory().getChestplate() != null) {
                if (CategoryManager.checkEquipRequirement(player, MessageType.REMOVE_ARMOR_TO_EQUIP_SUIT.getFormatMessage())) {
                    return false;
                }
                if (GadgetsMenu.getGadgetsMenuData().getEquipCosmeticItemToSlotAction() == EnumEquipType.DROP) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getChestplate().clone());
                        player.getInventory().setChestplate(null);
                        player.updateInventory();
                    });
                }
            }
        }
        if (type.getArmorType() == EnumArmorType.LEGGINGS && player.getInventory().getLeggings() != null) {
            CategoryManager.removeLeggingsCosmetic(player);
            if (player.getInventory().getLeggings() != null) {
                if (CategoryManager.checkEquipRequirement(player, MessageType.REMOVE_ARMOR_TO_EQUIP_SUIT.getFormatMessage())) {
                    return false;
                }
                if (GadgetsMenu.getGadgetsMenuData().getEquipCosmeticItemToSlotAction() == EnumEquipType.DROP) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getLeggings().clone());
                        player.getInventory().setLeggings(null);
                        player.updateInventory();
                    });
                }
            }
        }
        if (type.getArmorType() == EnumArmorType.BOOTS && player.getInventory().getBoots() != null) {
            CategoryManager.removeBootsCosmetic(player);
            if (player.getInventory().getBoots() != null) {
                if (CategoryManager.checkEquipRequirement(player, MessageType.REMOVE_ARMOR_TO_EQUIP_SUIT.getFormatMessage())) {
                    return false;
                }
                if (GadgetsMenu.getGadgetsMenuData().getEquipCosmeticItemToSlotAction() == EnumEquipType.DROP) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getBoots().clone());
                        player.getInventory().setBoots(null);
                        player.updateInventory();
                    });
                }
            }
        }
        if (pManager.getSelectedMorph() != null) {
            pManager.unequipMorph();
        }
        return true;
    }
}

