/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.suits.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.types.Suit;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class SuitNinja
extends Suit {
    private boolean clicked = false;
    private ArrayList<Item> items = new ArrayList();

    public SuitNinja(UUID uuid) {
        super(uuid, SuitType.NINJA);
    }

    @Override
    public void onUpdate() {
        if (this.clicked && !this.isBeingCooldown()) {
            new BukkitRunnable(){

                public void run() {
                    Item item = SuitNinja.this.getPlayer().getWorld().dropItem(SuitNinja.this.getPlayer().getEyeLocation(), ItemUtils.item(UUID.randomUUID().toString(), EnumMaterial.NETHER_STAR, 0));
                    item.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    item.setPickupDelay(Integer.MAX_VALUE);
                    item.setVelocity(new Vector(item.getVelocity().getX(), 0.7, item.getVelocity().getZ()));
                    item.setVelocity(SuitNinja.this.getPlayer().getLocation().getDirection().multiply(1.8));
                    SoundEffect.ENTITY_ARROW_SHOOT.playSound(SuitNinja.this.getPlayer());
                    SuitNinja.this.items.add(item);
                }
            }.runTask((Plugin)GadgetsMenu.getInstance());
            this.clicked = false;
            this.addCooldownTimer();
        }
        try {
            for (Item item : this.items) {
                if (item == null || !item.isOnGround()) continue;
                item.remove();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void onClear() {
        this.clicked = false;
        for (Item item : this.items) {
            item.remove();
        }
        this.items.clear();
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler
    public void onPlayerClick(PlayerInteractEvent e) {
        if (!(e.getAction() != Action.LEFT_CLICK_AIR && e.getAction() != Action.LEFT_CLICK_BLOCK || e.getPlayer() != this.getPlayer() || this.clicked)) {
            if (e.getPlayer().getItemInHand().getType() != Material.AIR) {
                return;
            }
            if (this.isBeingCooldown()) {
                e.setCancelled(true);
                return;
            }
            this.clicked = true;
            e.setCancelled(true);
        }
    }
}

