/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.suits.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.types.Suit;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MathUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class SuitSpooderman
extends Suit {
    private boolean activated = false;
    private boolean clicked = false;
    int step = 0;
    private ArrayList<Item> items = new ArrayList();
    private Location location;

    public SuitSpooderman(UUID uuid) {
        super(uuid, SuitType.SPOODERMAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdate() {
        if (this.clicked && !this.isBeingCooldown()) {
            this.activated = true;
            ++this.step;
            if (this.location == null) {
                return;
            }
            if (this.step <= 6) {
                if (this.step == 1) {
                    SoundEffect.ENTITY_SPIDER_AMBIENT.playSound(this.location);
                }
                Item item = this.getPlayer().getWorld().dropItem(this.location, ItemUtils.item(UUID.randomUUID().toString(), EnumMaterial.COBWEB, 0));
                item.setVelocity(new Vector(item.getVelocity().getX(), 0.7, item.getVelocity().getZ()));
                item.setVelocity(this.location.getDirection().multiply(1.5));
                item.setPickupDelay(Integer.MAX_VALUE);
                item.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                SoundEffect.ENTITY_ARROW_SHOOT.playSound(this.getPlayer());
                this.items.add(item);
            } else {
                this.clicked = false;
                this.addCooldownTimer();
                Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), () -> {
                    if (this.clicked) {
                        return;
                    }
                    this.clearAll();
                }, 160L);
            }
        }
        if (this.activated && this.step > 6) {
            ArrayList<Item> arrayList = this.items;
            synchronized (arrayList) {
                for (Item item : this.items) {
                    if (!this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentSuit() == null || GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentSuit().getType() != this.getType()) break;
                    if (item != null) {
                        Block loc1 = item.getLocation().clone().add(1.0, 0.0, 0.0).getBlock();
                        Block loc2 = item.getLocation().clone().add(0.0, 0.0, 1.0).getBlock();
                        Block loc3 = item.getLocation().clone().add(-1.0, 0.0, 0.0).getBlock();
                        Block loc4 = item.getLocation().clone().add(0.0, 0.0, -1.0).getBlock();
                        Block loc5 = item.getLocation().clone().add(0.0, 1.0, 0.0).getBlock();
                        Block loc6 = item.getLocation().clone().add(0.0, -1.0, 0.0).getBlock();
                        if (loc1.getType().isSolid() || loc2.getType().isSolid() || loc3.getType().isSolid() || loc4.getType().isSolid() || loc5.getType().isSolid() || loc6.getType().isSolid()) {
                            if (BlockUtil.isOutsideOfBorder(loc1.getLocation()) || BlockUtil.isOutsideOfBorder(loc2.getLocation()) || BlockUtil.isOutsideOfBorder(loc3.getLocation()) || BlockUtil.isOutsideOfBorder(loc4.getLocation()) || BlockUtil.isOutsideOfBorder(loc5.getLocation()) || BlockUtil.isOutsideOfBorder(loc6.getLocation())) {
                                this.getPlayer().sendMessage(MessageType.NOT_ALLOWED_TELEPORT_TO_THAT_LOCATION.getFormatMessage());
                                this.clearAll();
                                break;
                            }
                            this.pullToLocation(this.getPlayer(), item.getLocation());
                            this.clearAll();
                            break;
                        }
                        if (item.getTicksLived() <= 160) continue;
                        this.pullToLocation(this.getPlayer(), item.getLocation());
                        this.clearAll();
                        break;
                    }
                    this.clearAll();
                    break;
                }
            }
        }
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAll() {
        ArrayList<Item> arrayList = this.items;
        synchronized (arrayList) {
            for (Item item : this.items) {
                if (item == null) continue;
                item.remove();
            }
            this.items.clear();
        }
        this.step = 0;
        this.clicked = false;
        this.activated = false;
        this.location = null;
    }

    private void pullToLocation(Player player, Location loc) {
        double d;
        Validate.notNull((Object)player);
        Validate.notNull((Object)loc);
        if (player.getWorld() != loc.getWorld()) {
            return;
        }
        Location entityLoc = player.getLocation();
        entityLoc.setY(entityLoc.getY() + 0.5);
        player.teleport(entityLoc);
        double g = -0.09;
        double t = d = loc.distance(entityLoc);
        double v_x = (1.2 + 0.07 * t) * (loc.getX() - entityLoc.getX()) / t;
        double v_y = (1.2 + 0.03 * t) * (loc.getY() - entityLoc.getY()) / t - 0.5 * g * t;
        double v_z = (1.2 + 0.07 * t) * (loc.getZ() - entityLoc.getZ()) / t;
        Vector v = player.getVelocity();
        v.setX(v_x);
        v.setY(v_y);
        v.setZ(v_z);
        MathUtil.applyVelocity((Entity)this.getPlayer(), v);
    }

    @EventHandler
    public void onPlayerClick(PlayerInteractEvent e) {
        if (!(e.getAction() != Action.LEFT_CLICK_AIR && e.getAction() != Action.LEFT_CLICK_BLOCK || e.getPlayer() != this.getPlayer() || this.clicked)) {
            if (e.getPlayer().getItemInHand().getType() != Material.AIR) {
                return;
            }
            if (this.isBeingCooldown()) {
                e.setCancelled(true);
                return;
            }
            if (this.activated) {
                this.getPlayer().sendMessage(MessageType.SUIT_ABILITY_IS_ACTIVATED.getFormatMessage().replace("{SUIT}", this.getType().getDisplayNameStripColor()));
                e.setCancelled(true);
                return;
            }
            this.location = this.getPlayer().getEyeLocation();
            this.clicked = true;
            e.setCancelled(true);
        }
    }
}

