/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.custom;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.banners.BannerType;
import com.yapzhenyie.GadgetsMenu.utils.GDyeColor;
import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.banners.GPattern;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.banners.GPatternType;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.banners.GPatterns;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Rarity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.block.banner.Pattern;
import org.bukkit.inventory.ItemStack;

public class CustomBannerType {
    private String name;
    private String displayName;
    private String permission;
    private int mysteryDust;
    private Rarity rarity;
    private List<String> lore;
    private GMaterial material;
    private GDyeColor baseColor;
    private boolean isEnable;
    private boolean canBeFound;
    private boolean purchasable;
    private ItemStack itemStack;

    public static void initCustomBanners() {
        FileManager customBannersFile = FileManager.getCustomBannersFile();
        if (customBannersFile.get("Custom-Banners") != null) {
            for (String s : customBannersFile.getConfigurationSection("Custom-Banners").getKeys(false)) {
                new CustomBannerType(s, "&5" + s.toLowerCase() + " Banner", "gadgetsmenu.banners." + s.toLowerCase().replace(" ", ""), 12, Rarity.EPIC, null, GDyeColor.WHITE, null);
            }
        } else {
            customBannersFile.addDefault("Custom-Banners.Wolf.Name", "&5Wolf Banner");
            customBannersFile.addDefault("Custom-Banners.Wolf.Mystery Dust", 15);
            customBannersFile.addDefault("Custom-Banners.Wolf.Rarity", Rarity.EPIC.getName());
            customBannersFile.addDefault("Custom-Banners.Wolf.Enabled", false);
            customBannersFile.addDefault("Custom-Banners.Wolf.CanBeFound", true);
            customBannersFile.addDefault("Custom-Banners.Wolf.Purchasable", true);
            customBannersFile.addDefault("Custom-Banners.Wolf.Base-Color", "WHITE");
            customBannersFile.addDefault("Custom-Banners.Wolf.Patterns", Arrays.asList("BLACK:RHOMBUS_MIDDLE", "BLACK:RHOMBUS_MIDDLE", "LIGHT_BLUE:CURLY_BORDER", "LIGHT_BLUE:CIRCLE_MIDDLE", "LIGHT_BLUE:CREEPER", "LIGHT_BLUE:TRIANGLE_TOP"));
            customBannersFile.addDefault("Custom-Banners.Wolf.Lore", "");
        }
    }

    public CustomBannerType(String name, String displayName, String permission, int mysteryDust, Rarity rarity, List<String> lore, GDyeColor baseColor, List<Pattern> patterns) {
        this.name = name;
        if (FileManager.getCustomBannersFile().get("Custom-Banners." + this.name + ".Name") == null) {
            this.displayName = displayName;
            FileManager.getCustomBannersFile().set("Custom-Banners." + this.name + ".Name", this.displayName);
        } else {
            this.displayName = FileManager.getCustomBannersFile().getString("Custom-Banners." + this.name + ".Name");
        }
        this.permission = permission;
        if (FileManager.getCustomBannersFile().get("Custom-Banners." + this.name + ".Mystery Dust") == null) {
            this.mysteryDust = mysteryDust;
            FileManager.getCustomBannersFile().set("Custom-Banners." + this.name + ".Mystery Dust", this.mysteryDust);
        } else {
            this.mysteryDust = FileManager.getCustomBannersFile().getInt("Custom-Banners." + this.name + ".Mystery Dust");
        }
        if (FileManager.getCustomBannersFile().get("Custom-Banners." + this.name + ".Rarity") == null) {
            this.rarity = rarity;
            FileManager.getCustomBannersFile().set("Custom-Banners." + this.name + ".Rarity", this.rarity.getName());
        } else {
            this.rarity = Rarity.getName(FileManager.getCustomBannersFile().getString("Custom-Banners." + this.name + ".Rarity"));
        }
        if (FileManager.getCustomBannersFile().get("Custom-Banners." + this.name + ".Enabled") == null) {
            FileManager.getCustomBannersFile().set("Custom-Banners." + this.name + ".Enabled", true);
            this.isEnable = true;
        } else {
            this.isEnable = FileManager.getCustomBannersFile().getBoolean("Custom-Banners." + this.name + ".Enabled");
        }
        if (FileManager.getCustomBannersFile().get("Custom-Banners." + this.name + ".CanBeFound") == null) {
            FileManager.getCustomBannersFile().set("Custom-Banners." + this.name + ".CanBeFound", true);
            this.canBeFound = true;
        } else {
            this.canBeFound = FileManager.getCustomBannersFile().getBoolean("Custom-Banners." + this.name + ".CanBeFound");
        }
        if (FileManager.getCustomBannersFile().get("Custom-Banners." + this.name + ".Purchasable") == null) {
            FileManager.getCustomBannersFile().set("Custom-Banners." + this.name + ".Purchasable", true);
            this.purchasable = true;
        } else {
            this.purchasable = FileManager.getCustomBannersFile().getBoolean("Custom-Banners." + this.name + ".Purchasable");
        }
        if (FileManager.getCustomBannersFile().get("Custom-Banners." + this.name + ".Lore") == null) {
            this.lore = lore;
            if (lore == null) {
                FileManager.getCustomBannersFile().set("Custom-Banners." + this.name + ".Lore", "");
            } else {
                FileManager.getCustomBannersFile().set("Custom-Banners." + this.name + ".Lore", this.lore);
            }
        } else {
            this.lore = FileManager.getCustomBannersFile().getStringList("Custom-Banners." + this.name + ".Lore");
        }
        if (FileManager.getCustomBannersFile().get("Custom-Banners." + this.name + ".Base-Color") == null) {
            this.baseColor = GDyeColor.WHITE;
            FileManager.getCustomBannersFile().set("Custom-Banners." + this.name + ".Base-Color", "");
        } else {
            this.baseColor = GDyeColor.valueOf(FileManager.getCustomBannersFile().getString("Custom-Banners." + this.name + ".Base-Color"));
        }
        if (FileManager.getCustomBannersFile().get("Custom-Banners." + this.name + ".Patterns") == null) {
            this.material = new GMaterial(new GPatterns(this.baseColor, null));
            FileManager.getCustomBannersFile().set("Custom-Banners." + this.name + ".Patterns", "");
        } else {
            ArrayList<GPattern> p = new ArrayList<GPattern>();
            for (String pattern : FileManager.getCustomBannersFile().getStringList("Custom-Banners." + this.name + ".Patterns")) {
                p.add(new GPattern(GDyeColor.valueOf(pattern.split("\\:")[0].toUpperCase()), GPatternType.valueOf(pattern.split("\\:")[1].toUpperCase())));
            }
            this.material = new GMaterial(new GPatterns(this.baseColor, p));
        }
        this.itemStack = ItemUtils.item(this.displayName, this.material);
        this.itemStack = GadgetsMenu.getNMSManager().setNBTTag(this.itemStack, "Cosmetics", "true");
        this.itemStack = GadgetsMenu.getNMSManager().setNBTTag(this.itemStack, "Category", "Banner");
        new BannerType(this.name, this.displayName, this.permission, this.mysteryDust, this.rarity, this.lore, this.material, this.isEnable, this.canBeFound, this.purchasable, this.itemStack);
    }

    public String toString() {
        return this.name;
    }
}

