/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.custom;

import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.particles.ParticleType;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Rarity;
import java.util.List;

public class CustomParticleType {
    private String name;
    private String displayName;
    private GMaterial material;
    private String permission;
    private int mysteryDust;
    private Rarity rarity;
    private List<String> lore;
    private ParticleEffect particleEffect;
    private boolean isEnable;
    private boolean canBeFound;
    private boolean purchasable;

    public static void initCustomParticles() {
        FileManager customParticlesFile = FileManager.getCustomParticlesFile();
        if (customParticlesFile.get("Custom-Particles") != null) {
            for (String s : customParticlesFile.getConfigurationSection("Custom-Particles").getKeys(false)) {
                new CustomParticleType(s, "&a" + s.toLowerCase(), new GMaterial(EnumMaterial.BLAZE_POWDER), "gadgetsmenu.particles." + s.toLowerCase().replace(" ", ""), 15, Rarity.COMMON, null, ParticleEffect.FLAME);
            }
        } else {
            customParticlesFile.addDefault("Custom-Particles.End Rod.Name", "&5End Rod Particle");
            customParticlesFile.addDefault("Custom-Particles.End Rod.Material", "END_ROD");
            customParticlesFile.addDefault("Custom-Particles.End Rod.Mystery Dust", 32);
            customParticlesFile.addDefault("Custom-Particles.End Rod.Rarity", Rarity.EPIC.getName());
            customParticlesFile.addDefault("Custom-Particles.End Rod.Effect", ParticleEffect.END_ROD.getName());
            customParticlesFile.addDefault("Custom-Particles.End Rod.Enabled", false);
            customParticlesFile.addDefault("Custom-Particles.End Rod.CanBeFound", true);
            customParticlesFile.addDefault("Custom-Particles.End Rod.Purchasable", true);
            customParticlesFile.addDefault("Custom-Particles.End Rod.Lore", "");
        }
    }

    private CustomParticleType(String name, String displayName, GMaterial material, String permission, int mysteryDust, Rarity rarity, List<String> lore, ParticleEffect particleEffect) {
        this.name = name;
        if (FileManager.getCustomParticlesFile().get("Custom-Particles." + this.name + ".Name") == null) {
            this.displayName = displayName;
            FileManager.getCustomParticlesFile().set("Custom-Particles." + this.name + ".Name", this.displayName);
        } else {
            this.displayName = FileManager.getCustomParticlesFile().getString("Custom-Particles." + this.name + ".Name");
        }
        if (FileManager.getCustomParticlesFile().get("Custom-Particles." + this.name + ".Material") == null) {
            this.material = material;
            FileManager.getCustomParticlesFile().set("Custom-Particles." + this.name + ".Material", this.material.getCombinedMaterial());
        } else {
            GMaterial gMaterial;
            this.material = gMaterial = new GMaterial(FileManager.getCustomParticlesFile().getString("Custom-Particles." + this.name + ".Material"));
        }
        this.permission = permission;
        if (FileManager.getCustomParticlesFile().get("Custom-Particles." + this.name + ".Mystery Dust") == null) {
            this.mysteryDust = mysteryDust;
            FileManager.getCustomParticlesFile().set("Custom-Particles." + this.name + ".Mystery Dust", this.mysteryDust);
        } else {
            this.mysteryDust = FileManager.getCustomParticlesFile().getInt("Custom-Particles." + this.name + ".Mystery Dust");
        }
        if (FileManager.getCustomParticlesFile().get("Custom-Particles." + this.name + ".Rarity") == null) {
            this.rarity = rarity;
            FileManager.getCustomParticlesFile().set("Custom-Particles." + this.name + ".Rarity", this.rarity.getName());
        } else {
            this.rarity = Rarity.getName(FileManager.getCustomParticlesFile().getString("Custom-Particles." + this.name + ".Rarity"));
        }
        if (FileManager.getCustomParticlesFile().get("Custom-Particles." + this.name + ".Enabled") == null) {
            this.isEnable = true;
            FileManager.getCustomParticlesFile().set("Custom-Particles." + this.name + ".Enabled", true);
        } else {
            this.isEnable = FileManager.getCustomParticlesFile().getBoolean("Custom-Particles." + this.name + ".Enabled");
        }
        if (FileManager.getCustomParticlesFile().get("Custom-Particles." + this.name + ".CanBeFound") == null) {
            this.canBeFound = true;
            FileManager.getCustomParticlesFile().set("Custom-Particles." + this.name + ".CanBeFound", true);
        } else {
            this.canBeFound = FileManager.getCustomParticlesFile().getBoolean("Custom-Particles." + this.name + ".CanBeFound");
        }
        if (FileManager.getCustomParticlesFile().get("Custom-Particles." + this.name + ".Purchasable") == null) {
            this.purchasable = true;
            FileManager.getCustomParticlesFile().set("Custom-Particles." + this.name + ".Purchasable", true);
        } else {
            this.purchasable = FileManager.getCustomParticlesFile().getBoolean("Custom-Particles." + this.name + ".Purchasable");
        }
        if (FileManager.getCustomParticlesFile().get("Custom-Particles." + this.name + ".Lore") == null) {
            this.lore = lore;
            if (lore == null) {
                FileManager.getCustomParticlesFile().set("Custom-Particles." + this.name + ".Lore", "");
            } else {
                FileManager.getCustomParticlesFile().set("Custom-Particles." + this.name + ".Lore", this.lore);
            }
        } else {
            this.lore = FileManager.getCustomParticlesFile().getStringList("Custom-Particles." + this.name + ".Lore");
        }
        if (FileManager.getCustomParticlesFile().get("Custom-Particles." + this.name + ".Effect") == null) {
            this.particleEffect = particleEffect;
            FileManager.getCustomParticlesFile().set("Custom-Particles." + this.name + ".Effect", (Object)particleEffect);
        } else {
            try {
                this.particleEffect = ParticleEffect.valueOf(FileManager.getCustomParticlesFile().getString("Custom-Particles." + this.name + ".Effect").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.particleEffect = particleEffect;
            }
        }
        new ParticleType(this.name, this.displayName, this.material, this.permission, this.mysteryDust, this.rarity, this.lore, this.particleEffect, this.isEnable, this.canBeFound, this.purchasable);
    }

    public String toString() {
        return this.name;
    }
}

