/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.holograms;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.holograms.CraftHologram;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class CraftVisibilityManager {
    private final CraftHologram hologram;
    private boolean visibleByDefault;
    private Map<String, Boolean> playersVisibilityMap;

    public CraftVisibilityManager(CraftHologram hologram) {
        this.hologram = hologram;
        this.visibleByDefault = true;
    }

    public void setVisibleByDefault(boolean visibleByDefault) {
        if (this.visibleByDefault != visibleByDefault) {
            boolean oldVisibleByDefault = this.visibleByDefault;
            this.visibleByDefault = visibleByDefault;
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (this.playersVisibilityMap != null && this.playersVisibilityMap.containsKey(player.getName().toLowerCase())) continue;
                if (oldVisibleByDefault) {
                    CraftVisibilityManager.sendDestroyPacketIfNear(player, this.hologram);
                    continue;
                }
                CraftVisibilityManager.sendCreatePacketIfNear(player, this.hologram);
            }
        }
    }

    public void showTo(Player player) {
        boolean wasVisible = this.isVisibleTo(player);
        if (this.playersVisibilityMap == null) {
            this.playersVisibilityMap = new ConcurrentHashMap<String, Boolean>();
        }
        this.playersVisibilityMap.put(player.getName().toLowerCase(), true);
        if (!wasVisible) {
            CraftVisibilityManager.sendCreatePacketIfNear(player, this.hologram);
        }
    }

    public void hideTo(Player player) {
        boolean wasVisible = this.isVisibleTo(player);
        if (this.playersVisibilityMap == null) {
            this.playersVisibilityMap = new ConcurrentHashMap<String, Boolean>();
        }
        this.playersVisibilityMap.put(player.getName().toLowerCase(), false);
        if (wasVisible) {
            CraftVisibilityManager.sendDestroyPacketIfNear(player, this.hologram);
        }
    }

    public boolean isVisibleTo(Player player) {
        Boolean value;
        if (this.playersVisibilityMap != null && (value = this.playersVisibilityMap.get(player.getName().toLowerCase())) != null) {
            return value;
        }
        return this.visibleByDefault;
    }

    private static void sendCreatePacketIfNear(Player player, CraftHologram hologram) {
        if (GadgetsMenu.hasProtocolLibHook() && CraftVisibilityManager.isNear(player, hologram)) {
            GadgetsMenu.getProtocolLib().sendCreateEntitiesPacket(player, hologram);
        }
    }

    private static void sendDestroyPacketIfNear(Player player, CraftHologram hologram) {
        if (GadgetsMenu.hasProtocolLibHook() && CraftVisibilityManager.isNear(player, hologram)) {
            GadgetsMenu.getProtocolLib().sendDestroyEntitiesPacket(player, hologram);
        }
    }

    private static boolean isNear(Player player, CraftHologram hologram) {
        return player.isOnline() && player.getWorld().equals(hologram.getWorld()) && player.getLocation().distanceSquared(hologram.getLocation()) < 4096.0;
    }
}

