/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.listeners;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.Pet;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.types.SuitPlumber;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.ItemStack;

public class EntityListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager().hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getEntity().hasMetadata("Tetherball-Chicken")) {
            event.setDamage(0.0);
            return;
        }
        if (event.getEntity().hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onChunkUnload(ChunkUnloadEvent event) {
        Entity[] entities;
        for (Entity entity : entities = event.getChunk().getEntities()) {
            if (entity.isDead() || !Pet.entities.contains(entity)) continue;
            entity.remove();
            entity = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDamage(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (!GadgetsMenu.getGadgetsMenuData().isMobDisguiseDamageEnabled() && GadgetsMenu.getPlayerManager(player).getSelectedMorph() != null && GadgetsMenu.getGDisguise().isDisguised(player)) {
                event.setCancelled(true);
            }
            if ((event.getCause() == EntityDamageEvent.DamageCause.FIRE || event.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK) && GadgetsMenu.getPlayerManager(player).isFireDamageDisabled()) {
                event.setCancelled(true);
            }
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.FIRE || event.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK) {
            try {
                if (SuitPlumber.disableFireDamage.contains(event.getEntity())) {
                    event.setCancelled(true);
                }
            }
            catch (NoClassDefFoundError e) {
                event.setCancelled(false);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockExplode(BlockExplodeEvent event) {
        if (event.getBlock().hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (event.getEntity().hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
            event.setCancelled(true);
        }
        ArrayList blocks = new ArrayList(event.blockList());
        for (Block block : blocks) {
            if (!block.hasMetadata(GadgetsMenu.getInstance().getPluginName())) continue;
            event.blockList().remove(block);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityTeleport(EntityPortalEvent event) {
        if (event.getEntity().hasMetadata(GadgetsMenu.getInstance().getPluginName()) || event.getEntity().hasMetadata("Tetherball-Chicken")) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockForm(EntityBlockFormEvent event) {
        if (event.getEntity().hasMetadata(GadgetsMenu.getInstance().getPluginName()) && event.getNewState().getType().equals((Object)Material.SNOW)) {
            event.setCancelled(false);
            event.getNewState().setType(Material.AIR);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityInteract(EntityInteractEvent event) {
        if (event.getEntity().hasMetadata(GadgetsMenu.getInstance().getPluginName()) || event.getEntity().hasMetadata("Tetherball-Chicken")) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null) {
            return;
        }
        if (event.getClickedBlock().getLocation().add(0.0, 1.0, 0.0).getBlock().hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
            event.setCancelled(true);
        }
        if (event.getClickedBlock().hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (event.getRightClicked().hasMetadata(GadgetsMenu.getInstance().getPluginName()) || event.getRightClicked().hasMetadata("Tetherball-Chicken")) {
            event.setCancelled(true);
        }
        if ((event.getRightClicked().getType() == EntityType.ITEM_FRAME || VersionManager.is1_17OrAbove() && event.getRightClicked().getType() == EntityType.GLOW_ITEM_FRAME) && (GadgetsMenu.getNMSManager().hasNBTTag(event.getPlayer().getItemInHand(), "Cosmetics") || GadgetsMenu.getNMSManager().hasNBTTag(event.getPlayer().getItemInHand(), "Menu_Selector"))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        if (event.getRightClicked().hasMetadata(GadgetsMenu.getInstance().getPluginName()) || event.getRightClicked().hasMetadata("Tetherball-Chicken")) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityCombust(EntityCombustEvent event) {
        if (event.getEntity().hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
            event.getEntity().setFireTicks(0);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.CUSTOM && (Category.PETS.isEnabled() || Category.GADGETS.isEnabled()) && event.isCancelled()) {
            event.setCancelled(false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockPlaceEvent event) {
        if (event.getBlock().hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
            event.getBlock().getState().update();
            event.setCancelled(true);
            return;
        }
        ItemStack item = event.getItemInHand();
        if (item != null && (GadgetsMenu.getNMSManager().hasNBTTag(item, "Cosmetics") || GadgetsMenu.getNMSManager().hasNBTTag(item, "Menu_Selector"))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.getBlock().hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
            event.getBlock().getState().update();
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPotionThrow(PotionSplashEvent event) {
        if (event.getPotion().hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onLaunchSnowball(ProjectileLaunchEvent event) {
        if (event.getEntity().hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
            event.setCancelled(true);
        }
    }
}

