/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.listeners;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.MainMenu;
import com.yapzhenyie.GadgetsMenu.utils.EnumClickType;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class OpenMenuListener
implements Listener {
    @EventHandler
    public void onPlayerOpenMenu(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getAction() != Action.LEFT_CLICK_AIR && event.getAction() != Action.LEFT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (player.getItemInHand() == null || player.getItemInHand().getItemMeta() == null || player.getItemInHand().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (player.getOpenInventory() == null || player.getOpenInventory().getTitle() != null && !player.getOpenInventory().getTitle().toLowerCase().contains("crafting")) {
            return;
        }
        if (GadgetsMenu.getNMSManager().hasNBTTag(player.getItemInHand(), "Menu_Selector")) {
            if (GadgetsMenu.getGadgetsMenuData().getMenuSelectorClickType() == EnumClickType.LEFT && event.getAction() != Action.LEFT_CLICK_AIR && event.getAction() != Action.LEFT_CLICK_BLOCK) {
                player.updateInventory();
                event.setCancelled(true);
                return;
            }
            if (GadgetsMenu.getGadgetsMenuData().getMenuSelectorClickType() == EnumClickType.RIGHT && event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
                player.updateInventory();
                event.setCancelled(true);
                return;
            }
            if (!WorldUtils.isWorldEnabled(player, true)) {
                GadgetsMenu.getPlayerManager(player).removeMenuSelector();
                event.setCancelled(true);
                player.updateInventory();
                return;
            }
            if (!player.hasPermission(EnumPermission.MENU_SELECTOR.getPermission())) {
                GadgetsMenu.getPlayerManager(player).removeMenuSelector();
                event.setCancelled(true);
                return;
            }
            MainMenu.openMainMenu(player);
            event.setCancelled(true);
            player.updateInventory();
        }
    }

    @EventHandler
    public void onInvClickMenu(InventoryClickEvent event) {
        if (event.getInventory() == null) {
            return;
        }
        if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (GadgetsMenu.getGadgetsMenuData().isAbleToMoveMenuSelector()) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!WorldUtils.isWorldEnabled(player.getWorld())) {
            return;
        }
        if (GadgetsMenu.getNMSManager().hasNBTTag(event.getCurrentItem(), "Menu_Selector")) {
            if (!player.hasPermission(EnumPermission.MENU_SELECTOR.getPermission())) {
                GadgetsMenu.getPlayerManager(player).removeMenuSelector();
                event.setCancelled(true);
                return;
            }
            MainMenu.openMainMenu(player);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerCloseInventory(InventoryCloseEvent event) {
        if (!GadgetsMenu.getGadgetsMenuData().isAbleToMoveMenuSelector()) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (!WorldUtils.isWorldEnabled(player.getWorld())) {
            return;
        }
        if (event.getInventory().getType() == InventoryType.PLAYER || event.getInventory().getType() == InventoryType.CREATIVE) {
            return;
        }
        for (ItemStack item : event.getInventory().getContents()) {
            if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName() || !GadgetsMenu.getNMSManager().hasNBTTag(item, "Cosmetics") && !GadgetsMenu.getNMSManager().hasNBTTag(item, "Menu_Selector")) continue;
            event.getInventory().remove(item);
        }
    }
}

