/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.listeners;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.GadgetFlowerGiver;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.GadgetScarecrow;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.spigotmc.event.entity.EntityDismountEvent;

public class PlayerListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> GadgetsMenu.getGPlayer().initPlayer(player));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        pManager.removeMenuSelector();
        if (GadgetsMenu.getGadgetsMenuData().syncCosmeticsOnJoin()) {
            pManager.syncSelectedCosmetics(true);
        }
        pManager.unequipActiveCosmetics();
        GadgetScarecrow.unequipLitPumpkin(player);
        GadgetFlowerGiver.removeFlower(player);
        GadgetsMenu.getGPlayer().remove(player);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (GadgetsMenu.getGadgetsMenuData().isMysteryBoxesRewardEnabled()) {
            PlayerManager pManager = GadgetsMenu.getPlayerManager(event.getPlayer());
            if (event.getFrom().getX() != event.getTo().getX() || event.getFrom().getY() != event.getTo().getY() || event.getFrom().getZ() != event.getTo().getZ()) {
                if (!pManager.isMoving()) {
                    pManager.setMoving(true);
                }
            } else {
                pManager.setMoving(false);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChangeWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (WorldUtils.isWorldEnabled(event.getFrom())) {
            GadgetsMenu.getPlayerManager(player).cacheEquippedCosmetics();
            GadgetsMenu.getPlayerManager(player).unequipActiveCosmetics();
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
            if (WorldUtils.isWorldEnabled(player.getWorld())) {
                GadgetsMenu.getPlayerManager(player).loadEquippedCosmeticsFromCache();
                if (GadgetsMenu.getGadgetsMenuData().isGiveMenuSelectorOnJoin() && player.hasPermission(EnumPermission.MENU_SELECTOR.getPermission()) && WorldUtils.isWorldEnabled(player.getWorld())) {
                    GadgetsMenu.getPlayerManager(player).giveMenuSelector();
                } else {
                    GadgetsMenu.getPlayerManager(player).removeMenuSelector();
                }
            } else {
                Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                    GadgetsMenu.getPlayerManager(player).unequipActiveCosmetics();
                    GadgetsMenu.getPlayerManager(player).removeMenuSelector();
                });
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (event.getEntity() instanceof Player && !event.getEntity().hasMetadata("NPC") && WorldUtils.isWorldEnabled(event.getEntity().getWorld())) {
            Player player = event.getEntity();
            int slot = GadgetsMenu.getGadgetsMenuData().getMenuSelectorSlot();
            if (GadgetsMenu.getGadgetsMenuData().isGiveMenuSelectorOnJoin() && player.hasPermission(EnumPermission.MENU_SELECTOR.getPermission()) && player.getInventory().getItem(slot) != null && player.getInventory().getItem(slot).hasItemMeta() && player.getInventory().getItem(slot).getItemMeta().hasDisplayName() && player.getInventory().getItem(slot).getItemMeta().getDisplayName().equals(ChatUtil.format(GadgetsMenu.getGadgetsMenuData().getMenuSelector().getItemMeta().getDisplayName()))) {
                event.getDrops().remove(player.getInventory().getItem(slot));
                player.getInventory().setItem(slot, null);
            }
            GadgetsMenu.getPlayerManager(player).cacheEquippedCosmetics();
            GadgetsMenu.getPlayerManager(player).unequipActiveCosmetics();
            List drops = event.getDrops();
            ArrayList<ItemStack> dropsToRemove = new ArrayList<ItemStack>();
            for (ItemStack drop : drops) {
                if (!drop.hasItemMeta() || !drop.getItemMeta().hasDisplayName() || !GadgetsMenu.getNMSManager().hasNBTTag(drop, "Cosmetics")) continue;
                dropsToRemove.add(drop);
            }
            event.getDrops().removeAll(dropsToRemove);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
            PlayerManager pManager;
            if (WorldUtils.isWorldEnabled(player.getWorld()) && (pManager = GadgetsMenu.getPlayerManager(player)) != null) {
                if (GadgetsMenu.getGadgetsMenuData().isGiveMenuSelectorOnJoin() && player.hasPermission(EnumPermission.MENU_SELECTOR.getPermission())) {
                    pManager.giveMenuSelector();
                }
                pManager.loadEquippedCosmeticsFromCache();
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onToggleSneak(PlayerToggleSneakEvent event) {
        if (!WorldUtils.isWorldEnabled(event.getPlayer().getWorld())) {
            return;
        }
        GadgetsMenu.getNMSManager().leaveVehicle(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDismountPlayer(EntityDismountEvent event) {
        if (!(event.getDismounted() instanceof Player)) {
            return;
        }
        if (!WorldUtils.isWorldEnabled(event.getDismounted().getWorld())) {
            return;
        }
        GadgetsMenu.getNMSManager().passengerDismount(event);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onGameModeChange(PlayerGameModeChangeEvent event) {
        if (!WorldUtils.isWorldEnabled(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getNewGameMode() != GameMode.SPECTATOR) {
            return;
        }
        GadgetsMenu.getNMSManager().leaveVehicle(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        if (WorldUtils.isWorldEnabled(event.getPlayer().getWorld()) && GadgetsMenu.getPlayerManager(event.getPlayer()).isCosmeticActivated()) {
            for (String cmd : GadgetsMenu.getGadgetsMenuData().getDisabledCommands()) {
                if (!event.getMessage().replace("/", "").toLowerCase().startsWith(cmd) && !event.getMessage().replace("/", "").toLowerCase().equalsIgnoreCase(cmd)) continue;
                event.getPlayer().sendMessage(MessageType.DISABLED_COMMAND_WHILE_COSMETICS_ACTIVATED.getFormatMessage());
                event.setCancelled(true);
                return;
            }
        }
    }
}

