/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.log;

import java.util.logging.Level;
import org.bukkit.Bukkit;

public class LoggerManager {
    public static void printLog(Object ... messages) {
        LoggerManager.logFormat(LogLevel.INFO, null, messages);
    }

    public static void printLog(LogLevel level, Object ... messages) {
        LoggerManager.logFormat(level, null, messages);
    }

    public static void printLogWithHeader(LogLevel level, String headerAndFooter, Object ... messages) {
        LoggerManager.logFormat(level, headerAndFooter, messages);
    }

    public static void consoleMessage(Object ... messages) {
        if (messages.length == 0) {
            Bukkit.getServer().getLogger().log(Level.INFO, LoggerManager.prefix() + "", new Throwable().getStackTrace());
        }
        for (Object object : messages) {
            Bukkit.getServer().getConsoleSender().sendMessage(LoggerManager.prefix() + object.toString());
        }
    }

    public static void info(Object ... messages) {
        if (messages.length == 0) {
            Bukkit.getServer().getLogger().log(Level.INFO, LoggerManager.prefix() + "", new Throwable().getStackTrace());
        }
        for (Object object : messages) {
            Bukkit.getServer().getLogger().log(Level.INFO, LoggerManager.prefix() + object.toString(), new Throwable().getStackTrace());
        }
    }

    public static void severe(Object ... messages) {
        if (messages.length == 0) {
            Bukkit.getServer().getLogger().log(Level.SEVERE, LoggerManager.prefix() + "", new Throwable().getStackTrace());
        }
        for (Object object : messages) {
            Bukkit.getServer().getLogger().log(Level.SEVERE, LoggerManager.prefix() + object.toString(), new Throwable().getStackTrace());
        }
    }

    public static void warn(Object ... messages) {
        if (messages.length == 0) {
            Bukkit.getServer().getLogger().log(Level.WARNING, LoggerManager.prefix() + "", new Throwable().getStackTrace());
        }
        for (Object object : messages) {
            Bukkit.getServer().getLogger().log(Level.WARNING, LoggerManager.prefix() + object.toString(), new Throwable().getStackTrace());
        }
    }

    private static void logFormat(LogLevel level, String headerAndFooter, Object ... messages) {
        if (headerAndFooter != null) {
            Bukkit.getServer().getLogger().log(Level.parse(level.toString()), LoggerManager.prefix() + headerAndFooter);
        }
        if (messages.length == 0) {
            Bukkit.getServer().getLogger().log(Level.parse(level.toString()), LoggerManager.prefix(), new Throwable().getStackTrace());
        }
        for (Object msg : messages) {
            String newMsg = msg.toString();
            int msgLength = msg.toString().length();
            if (headerAndFooter != null && headerAndFooter.length() > msgLength) {
                int emptySpace = (headerAndFooter.length() - msgLength) / 2;
                String emptySpaceLength = "";
                for (int i = 1; i <= emptySpace; ++i) {
                    emptySpaceLength = emptySpaceLength + " ";
                }
                newMsg = emptySpaceLength + msg.toString();
            }
            Bukkit.getServer().getLogger().log(Level.parse(level.toString()), LoggerManager.prefix() + newMsg, new Throwable().getStackTrace());
        }
        if (headerAndFooter != null) {
            Bukkit.getServer().getLogger().log(Level.parse(level.toString()), LoggerManager.prefix() + headerAndFooter);
        }
    }

    private static String prefix() {
        return "[GadgetsMenu] ";
    }

    public static enum LogLevel {
        INFO,
        WARNING,
        SEVERE;

    }
}

