/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.api.GadgetsMenuAPI;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.animated.AnimatedHatManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.animated.AnimatedHatType;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.GInventory;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.StringUtils;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.discount.DiscountManager;
import com.yapzhenyie.GadgetsMenu.utils.discount.ItemCostDiscount;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class AnimatedHatsMenu
implements Listener {
    public static void openAnimatedHatsMenu(Player player, int page) {
        int size = AnimatedHatType.enabled().size();
        int maxPages = GInventory.getMaxPagesAmount(27, size);
        if (page <= 0) {
            page = 1;
        }
        if (page > 1 && maxPages < page) {
            page = 1;
        }
        Inventory invAnimatedHats = Bukkit.createInventory(null, (int)54, (String)ChatUtil.format(Category.ANIMATED_HATS.getGUIName() + StringUtils.addPlaceholders(EnumItem.PAGES.getDisplayName(), Arrays.asList("{CURRENT_PAGE}", "{MAX_PAGES}"), Arrays.asList(String.valueOf(page), String.valueOf(maxPages)))));
        int i = 0;
        int from = 1;
        if (page > 1) {
            from = 27 * (page - 1) + 1;
        }
        int to = 27;
        if (size < 27) {
            to = size;
        }
        if (page > 1) {
            to = size >= 27 * page ? 27 * page : size;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        for (int h = from; h <= to; ++h) {
            try {
                if (h > size) break;
                AnimatedHatType animatedHats = AnimatedHatType.enabled().get(h - 1);
                if (PermissionUtils.noPermission(player, animatedHats.getPermission(), EnumPermission.ANIMATED_HATS.getPermission(), false)) {
                    DiscountManager discountManager = new DiscountManager(pManager, Category.ANIMATED_HATS.isPurchasable() && animatedHats.isPurchasable(), animatedHats.getMysteryDust());
                    if (EnumItem.NO_PERMISSION.showCustomItem()) {
                        InventoryUtils.inventory(invAnimatedHats, animatedHats.getDisplayName(), EnumItem.NO_PERMISSION.getCustomItem(), animatedHats.getLore(), EnumItem.NO_PERMISSION.isShowInLore() ? EnumItem.NO_PERMISSION.getLore() : null, discountManager.getLore(), GInventory.LAY_OUT_27.getLayOut()[i++]);
                        continue;
                    }
                    InventoryUtils.inventory(invAnimatedHats, animatedHats.getDisplayName(), animatedHats.getMaterial(), animatedHats.getLore(), EnumItem.NO_PERMISSION.isShowInLore() ? EnumItem.NO_PERMISSION.getLore() : null, discountManager.getLore(), GInventory.LAY_OUT_27.getLayOut()[i++]);
                    continue;
                }
                InventoryUtils.inventoryAddGlow(invAnimatedHats, animatedHats.getDisplayName(), animatedHats.getMaterial(), animatedHats.getLore(), EnumItem.HAS_PERMISSION.isShowInLore() ? EnumItem.HAS_PERMISSION.getLore() : null, GInventory.LAY_OUT_27.getLayOut()[i++], pManager.getSelectedAnimatedHat() == null ? null : pManager.getSelectedAnimatedHat().getDisplayName());
                continue;
            }
            catch (Exception Ex) {
                player.sendMessage(MessageType.ERROR.getFormatMessage());
                Ex.printStackTrace();
                return;
            }
        }
        if (EnumItem.RESET_ANIMATED_HAT.show()) {
            InventoryUtils.inventory(invAnimatedHats, EnumItem.RESET_ANIMATED_HAT.getItemStack(), EnumItem.RESET_ANIMATED_HAT.getSlot());
        }
        if (page == 1) {
            if (EnumItem.GO_BACK.show()) {
                InventoryUtils.inventory(invAnimatedHats, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot());
            }
        } else {
            InventoryUtils.inventory(invAnimatedHats, EnumItem.PREVIOUS_PAGE.getItemStack(), "{PAGE}", String.valueOf(page - 1), EnumItem.PREVIOUS_PAGE.getSlot());
        }
        if (page < maxPages) {
            InventoryUtils.inventory(invAnimatedHats, EnumItem.NEXT_PAGE.getItemStack(), "{PAGE}", String.valueOf(page + 1), EnumItem.NEXT_PAGE.getSlot());
        }
        if (EnumItem.MAIN_MENU_ITEM.show()) {
            InventoryUtils.mainMenuButton(pManager, invAnimatedHats, EnumItem.MAIN_MENU_ITEM.getSlot());
        }
        InventoryUtils.fillItems(invAnimatedHats);
        player.openInventory(invAnimatedHats);
        pManager.setCurrentHatsPage(page);
    }

    @EventHandler
    public void onInvClickAnimatedHats(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().startsWith(Category.ANIMATED_HATS.getGUIName())) {
            if (event.getClickedInventory() == null || event.getClickedInventory().getSize() != 54 || event.getClickedInventory().getType() != InventoryType.CHEST) {
                event.setCancelled(true);
                return;
            }
            if (!Category.ANIMATED_HATS.isEnabled() || !WorldUtils.isWorldEnabled(player, true)) {
                player.updateInventory();
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                player.updateInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
            if (ItemUtils.getCurrentItem(event, EnumItem.RESET_ANIMATED_HAT.getItemStack(), EnumItem.RESET_ANIMATED_HAT.getSlot())) {
                pManager.unequipAnimatedHat();
                player.sendMessage(MessageType.RESET_ANIMATED_HAT.getFormatMessage());
                if (EnumItem.RESET_ANIMATED_HAT.isPlaySoundEnabled()) {
                    EnumItem.RESET_ANIMATED_HAT.getSound().playSound(player, 1.0f, 2.0f);
                }
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.PREVIOUS_PAGE.getDisplayName(), EnumItem.PREVIOUS_PAGE.getSlot())) {
                AnimatedHatsMenu.openAnimatedHatsMenu(player, GadgetsMenu.getPlayerManager(player).getCurrentHatsPage() - 1);
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.NEXT_PAGE.getDisplayName(), EnumItem.NEXT_PAGE.getSlot())) {
                AnimatedHatsMenu.openAnimatedHatsMenu(player, GadgetsMenu.getPlayerManager(player).getCurrentHatsPage() + 1);
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.MAIN_MENU_ITEM.getDisplayName(), EnumItem.MAIN_MENU_ITEM.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            for (AnimatedHatType animatedHat : AnimatedHatType.values()) {
                if (!event.getCurrentItem().getItemMeta().getDisplayName().equals(ChatUtil.format(animatedHat.getDisplayName()))) continue;
                if (PermissionUtils.noPermission(player, animatedHat.getPermission(), EnumPermission.ANIMATED_HATS.getPermission(), false)) {
                    if (Category.ANIMATED_HATS.isPurchasable()) {
                        if (!animatedHat.isPurchasable()) {
                            player.sendMessage(MessageType.ITEM_UNPURCHASABLE.getFormatMessage());
                            if (EnumItem.ITEM_UNPURCHASABLE.isPlaySoundEnabled()) {
                                EnumItem.ITEM_UNPURCHASABLE.getSound().playSound(player, 1.0f, 0.5f);
                            }
                            player.closeInventory();
                            event.setCancelled(true);
                            return;
                        }
                        ItemCostDiscount discount = pManager.getItemCostDiscount();
                        int discountedPrice = animatedHat.getMysteryDust();
                        if (discount != null) {
                            discountedPrice = discount.getPriceAfterDiscount(animatedHat.getMysteryDust());
                        }
                        if (pManager.getMysteryDust() >= discountedPrice) {
                            pManager.purchaseData().setData(Category.ANIMATED_HATS, animatedHat.getName(), animatedHat.getDisplayName(), discount, animatedHat.getMysteryDust(), animatedHat.getPermission());
                            pManager.openItemPurchaseMenu();
                        } else {
                            player.sendMessage(MessageType.NOT_ENOUGH_MYSTERY_DUST_TO_PURCHASE.getFormatMessage());
                            if (EnumItem.NOT_ENOUGH_MYSTERY_DUST.isPlaySoundEnabled()) {
                                EnumItem.NOT_ENOUGH_MYSTERY_DUST.getSound().playSound(player, 1.0f, 0.5f);
                            }
                            player.closeInventory();
                        }
                        event.setCancelled(true);
                        return;
                    }
                    if (!PermissionUtils.noPermission(player, animatedHat.getPermission(), EnumPermission.ANIMATED_HATS.getPermission(), true)) continue;
                    if (EnumItem.NO_PERMISSION.isPlaySoundEnabled()) {
                        EnumItem.NO_PERMISSION.getSound().playSound(player, 1.0f, 0.5f);
                    }
                    if (EnumItem.NO_PERMISSION.isCloseGUIMenuAfterSelect()) {
                        player.closeInventory();
                    }
                    event.setCancelled(true);
                    return;
                }
                try {
                    if (pManager.getSelectedAnimatedHat() != null && ChatUtil.format(animatedHat.getDisplayName()).equals(pManager.getSelectedAnimatedHat().getDisplayName())) {
                        pManager.unequipAnimatedHat();
                        player.sendMessage(MessageType.RESET_ANIMATED_HAT.getFormatMessage());
                        if (EnumItem.RESET_ANIMATED_HAT.isPlaySoundEnabled()) {
                            EnumItem.RESET_ANIMATED_HAT.getSound().playSound(player, 1.0f, 2.0f);
                        }
                        player.closeInventory();
                        event.setCancelled(true);
                        return;
                    }
                    if (!AnimatedHatManager.checkRequirement(player, animatedHat)) {
                        player.closeInventory();
                        event.setCancelled(true);
                        return;
                    }
                    pManager.equipAnimatedHat(animatedHat);
                    player.sendMessage(MessageType.SELECT_ANIMATED_HAT.getFormatMessage().replace("{ANIMATED_HAT}", animatedHat.getDisplayNameStripColor()));
                    if (EnumItem.HAS_PERMISSION.isPlaySoundEnabled()) {
                        EnumItem.HAS_PERMISSION.getSound().playSound(player, 1.0f, 2.0f);
                    }
                    if (EnumItem.HAS_PERMISSION.isCloseGUIMenuAfterSelect()) {
                        player.closeInventory();
                    } else {
                        AnimatedHatsMenu.openAnimatedHatsMenu(player, 1);
                    }
                    event.setCancelled(true);
                }
                catch (Exception Ex) {
                    player.sendMessage(MessageType.ERROR.getFormatMessage());
                    Ex.printStackTrace();
                }
            }
            event.setCancelled(true);
            return;
        }
    }
}

