/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.api.GadgetsMenuAPI;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.emotes.EmoteManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.emotes.EmoteType;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.GInventory;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.StringUtils;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.discount.DiscountManager;
import com.yapzhenyie.GadgetsMenu.utils.discount.ItemCostDiscount;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class EmotesMenu
implements Listener {
    public static void openEmotesMenu(Player player, int page) {
        int size = EmoteType.enabled().size();
        int maxPages = GInventory.getMaxPagesAmount(21, size);
        if (page <= 0) {
            page = 1;
        }
        if (page > 1 && maxPages < page) {
            page = 1;
        }
        Inventory invEmotes = Bukkit.createInventory(null, (int)54, (String)ChatUtil.format(Category.EMOTES.getGUIName() + StringUtils.addPlaceholders(EnumItem.PAGES.getDisplayName(), Arrays.asList("{CURRENT_PAGE}", "{MAX_PAGES}"), Arrays.asList(String.valueOf(page), String.valueOf(maxPages)))));
        int i = 0;
        int from = 1;
        if (page > 1) {
            from = 21 * (page - 1) + 1;
        }
        int to = 21;
        if (size < 21) {
            to = size;
        }
        if (page > 1) {
            to = size >= 21 * page ? 21 * page : size;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        for (int h = from; h <= to; ++h) {
            try {
                if (h > size) break;
                EmoteType emotes = EmoteType.enabled().get(h - 1);
                if (PermissionUtils.noPermission(player, emotes.getPermission(), EnumPermission.EMOTES.getPermission(), false)) {
                    DiscountManager discountManager = new DiscountManager(pManager, Category.EMOTES.isPurchasable() && emotes.isPurchasable(), emotes.getMysteryDust());
                    if (EnumItem.NO_PERMISSION.showCustomItem()) {
                        InventoryUtils.inventory(invEmotes, emotes.getDisplayName(), EnumItem.NO_PERMISSION.getCustomItem(), emotes.getLore(), EnumItem.NO_PERMISSION.isShowInLore() ? EnumItem.NO_PERMISSION.getLore() : null, discountManager.getLore(), GInventory.LAY_OUT_21.getLayOut()[i++]);
                        continue;
                    }
                    InventoryUtils.inventory(invEmotes, emotes.getDisplayName(), emotes.getMaterialHead().getMaterial(), emotes.getLore(), EnumItem.NO_PERMISSION.isShowInLore() ? EnumItem.NO_PERMISSION.getLore() : null, discountManager.getLore(), GInventory.LAY_OUT_21.getLayOut()[i++]);
                    continue;
                }
                InventoryUtils.inventoryAddGlow(invEmotes, emotes.getDisplayName(), emotes.getMaterialHead().getMaterial(), emotes.getLore(), EnumItem.HAS_PERMISSION.isShowInLore() ? EnumItem.HAS_PERMISSION.getLore() : null, GInventory.LAY_OUT_21.getLayOut()[i++], pManager.getSelectedEmote() == null ? null : pManager.getSelectedEmote().getDisplayName());
                continue;
            }
            catch (Exception Ex) {
                player.sendMessage(MessageType.ERROR.getFormatMessage());
                Ex.printStackTrace();
                return;
            }
        }
        if (EnumItem.RESET_EMOTE.show()) {
            InventoryUtils.inventory(invEmotes, EnumItem.RESET_EMOTE.getItemStack(), EnumItem.RESET_EMOTE.getSlot());
        }
        if (page == 1) {
            if (EnumItem.GO_BACK.show()) {
                InventoryUtils.inventory(invEmotes, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot());
            }
        } else {
            InventoryUtils.inventory(invEmotes, EnumItem.PREVIOUS_PAGE.getItemStack(), "{PAGE}", String.valueOf(page - 1), EnumItem.PREVIOUS_PAGE.getSlot());
        }
        if (page < maxPages) {
            InventoryUtils.inventory(invEmotes, EnumItem.NEXT_PAGE.getItemStack(), "{PAGE}", String.valueOf(page + 1), EnumItem.NEXT_PAGE.getSlot());
        }
        if (EnumItem.MAIN_MENU_ITEM.show()) {
            InventoryUtils.mainMenuButton(pManager, invEmotes, EnumItem.MAIN_MENU_ITEM.getSlot());
        }
        InventoryUtils.fillItems(invEmotes);
        player.openInventory(invEmotes);
        pManager.setCurrentBannersPage(page);
    }

    @EventHandler
    public void onInvClickEmotes(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().startsWith(Category.EMOTES.getGUIName())) {
            if (event.getClickedInventory() == null || event.getClickedInventory().getSize() != 54 || event.getClickedInventory().getType() != InventoryType.CHEST) {
                event.setCancelled(true);
                return;
            }
            if (!Category.EMOTES.isEnabled() || !WorldUtils.isWorldEnabled(player, true)) {
                player.updateInventory();
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                player.updateInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.RESET_EMOTE.getItemStack(), EnumItem.RESET_EMOTE.getSlot())) {
                GadgetsMenu.getPlayerManager(player).unequipEmote();
                player.sendMessage(MessageType.RESET_EMOTE.getFormatMessage());
                if (EnumItem.RESET_EMOTE.isPlaySoundEnabled()) {
                    EnumItem.RESET_EMOTE.getSound().playSound(player, 1.0f, 2.0f);
                }
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.PREVIOUS_PAGE.getDisplayName(), EnumItem.PREVIOUS_PAGE.getSlot())) {
                EmotesMenu.openEmotesMenu(player, GadgetsMenu.getPlayerManager(player).getCurrentEmotesPage() - 1);
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.NEXT_PAGE.getDisplayName(), EnumItem.NEXT_PAGE.getSlot())) {
                EmotesMenu.openEmotesMenu(player, GadgetsMenu.getPlayerManager(player).getCurrentEmotesPage() + 1);
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.MAIN_MENU_ITEM.getDisplayName(), EnumItem.MAIN_MENU_ITEM.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            for (EmoteType emote : EmoteType.values()) {
                if (!event.getCurrentItem().getItemMeta().getDisplayName().equals(ChatUtil.format(emote.getDisplayName()))) continue;
                if (PermissionUtils.noPermission(player, emote.getPermission(), EnumPermission.EMOTES.getPermission(), false)) {
                    if (Category.EMOTES.isPurchasable()) {
                        if (!emote.isPurchasable()) {
                            player.sendMessage(MessageType.ITEM_UNPURCHASABLE.getFormatMessage());
                            if (EnumItem.ITEM_UNPURCHASABLE.isPlaySoundEnabled()) {
                                EnumItem.ITEM_UNPURCHASABLE.getSound().playSound(player, 1.0f, 0.5f);
                            }
                            player.closeInventory();
                            event.setCancelled(true);
                            return;
                        }
                        ItemCostDiscount discount = GadgetsMenu.getPlayerManager(player).getItemCostDiscount();
                        int discountedPrice = emote.getMysteryDust();
                        if (discount != null) {
                            discountedPrice = discount.getPriceAfterDiscount(emote.getMysteryDust());
                        }
                        if (GadgetsMenu.getPlayerManager(player).getMysteryDust() >= discountedPrice) {
                            GadgetsMenu.getPlayerManager(player).purchaseData().setData(Category.EMOTES, emote.getName(), emote.getDisplayName(), discount, emote.getMysteryDust(), emote.getPermission());
                            GadgetsMenu.getPlayerManager(player).openItemPurchaseMenu();
                        } else {
                            player.sendMessage(MessageType.NOT_ENOUGH_MYSTERY_DUST_TO_PURCHASE.getFormatMessage());
                            if (EnumItem.NOT_ENOUGH_MYSTERY_DUST.isPlaySoundEnabled()) {
                                EnumItem.NOT_ENOUGH_MYSTERY_DUST.getSound().playSound(player, 1.0f, 0.5f);
                            }
                            player.closeInventory();
                        }
                        event.setCancelled(true);
                        return;
                    }
                    if (!PermissionUtils.noPermission(player, emote.getPermission(), EnumPermission.EMOTES.getPermission(), true)) continue;
                    if (EnumItem.NO_PERMISSION.isPlaySoundEnabled()) {
                        EnumItem.NO_PERMISSION.getSound().playSound(player, 1.0f, 0.5f);
                    }
                    if (EnumItem.NO_PERMISSION.isCloseGUIMenuAfterSelect()) {
                        player.closeInventory();
                    }
                    event.setCancelled(true);
                    return;
                }
                try {
                    if (GadgetsMenu.getPlayerManager(player).getSelectedEmote() != null && ChatUtil.format(emote.getDisplayName()).equals(GadgetsMenu.getPlayerManager(player).getSelectedEmote().getDisplayName())) {
                        GadgetsMenu.getPlayerManager(player).unequipEmote();
                        player.sendMessage(MessageType.RESET_EMOTE.getFormatMessage());
                        if (EnumItem.RESET_EMOTE.isPlaySoundEnabled()) {
                            EnumItem.RESET_EMOTE.getSound().playSound(player, 1.0f, 2.0f);
                        }
                        player.closeInventory();
                        event.setCancelled(true);
                        return;
                    }
                    if (!EmoteManager.checkRequirement(player, emote)) {
                        player.closeInventory();
                        event.setCancelled(true);
                        return;
                    }
                    GadgetsMenu.getPlayerManager(player).equipEmote(emote);
                    player.sendMessage(MessageType.SELECT_EMOTE.getFormatMessage().replace("{EMOTE}", emote.getDisplayNameStripColor()));
                    if (EnumItem.HAS_PERMISSION.isPlaySoundEnabled()) {
                        EnumItem.HAS_PERMISSION.getSound().playSound(player, 1.0f, 2.0f);
                    }
                    if (EnumItem.HAS_PERMISSION.isCloseGUIMenuAfterSelect()) {
                        player.closeInventory();
                    } else {
                        EmotesMenu.openEmotesMenu(player, GadgetsMenu.getPlayerManager(player).getCurrentEmotesPage());
                    }
                    event.setCancelled(true);
                    return;
                }
                catch (Exception Ex) {
                    player.sendMessage(MessageType.ERROR.getFormatMessage());
                    Ex.printStackTrace();
                }
            }
            event.setCancelled(true);
            return;
        }
    }
}

