/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.api.GadgetsMenuAPI;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetCategoryType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.GInventory;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.discount.DiscountManager;
import com.yapzhenyie.GadgetsMenu.utils.discount.ItemCostDiscount;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class GadgetTypesMenu
implements Listener {
    public static void openGadgetTypesMenu(Player player, String group, int page) {
        int size = GadgetType.getGroup(group).size();
        int maxPages = GInventory.getMaxPagesAmount(27, size);
        if (page <= 0) {
            page = 1;
        }
        if (page > 1 && maxPages < page) {
            page = 1;
        }
        Inventory invGadgets = Bukkit.createInventory(null, (int)54, (String)ChatUtil.format(GadgetCategoryType.valueOf(group).getDisplayNameStripColor()));
        int i = 0;
        int from = 1;
        if (page > 1) {
            from = 27 * (page - 1) + 1;
        }
        int to = 27;
        if (size < 27) {
            to = size;
        }
        if (page > 1) {
            to = size >= 27 * page ? 27 * page : size;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        for (int h = from; h <= to; ++h) {
            try {
                if (h > size) break;
                GadgetType gadgets = GadgetType.getGroup(group).get(h - 1);
                if (PermissionUtils.noPermission(player, gadgets.getPermission(), EnumPermission.GADGETS.getPermission(), false)) {
                    DiscountManager discountManager = new DiscountManager(pManager, Category.GADGETS.isPurchasable() && gadgets.isPurchasable(), gadgets.getMysteryDust());
                    if (EnumItem.NO_PERMISSION.showCustomItem()) {
                        InventoryUtils.inventory(invGadgets, gadgets.getDisplayName(), EnumItem.NO_PERMISSION.getCustomItem(), gadgets.getLore(), EnumItem.NO_PERMISSION.isShowInLore() ? EnumItem.NO_PERMISSION.getLore() : null, discountManager.getLore(), GInventory.LAY_OUT_27.getLayOut()[i++]);
                        continue;
                    }
                    InventoryUtils.inventory(invGadgets, gadgets.getDisplayName(), gadgets.getMaterial(), gadgets.getMaterial().getData(), gadgets.getLore(), EnumItem.NO_PERMISSION.isShowInLore() ? EnumItem.NO_PERMISSION.getLore() : null, discountManager.getLore(), GInventory.LAY_OUT_27.getLayOut()[i++]);
                    continue;
                }
                InventoryUtils.inventoryAddGlow(invGadgets, gadgets.getDisplayName(), gadgets.getMaterial(), gadgets.getLore(), EnumItem.HAS_PERMISSION.isShowInLore() ? EnumItem.HAS_PERMISSION.getLore() : null, GInventory.LAY_OUT_27.getLayOut()[i++], pManager.getSelectedGadget() == null ? null : pManager.getSelectedGadget().getDisplayName());
                continue;
            }
            catch (Exception e) {
                player.sendMessage(MessageType.ERROR.getFormatMessage());
                e.printStackTrace();
                return;
            }
        }
        if (EnumItem.RESET_GADGET.show()) {
            InventoryUtils.inventory(invGadgets, EnumItem.RESET_GADGET.getItemStack(), EnumItem.RESET_GADGET.getSlot());
        }
        if (EnumItem.GO_BACK.show()) {
            InventoryUtils.inventory(invGadgets, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot());
        }
        if (EnumItem.MAIN_MENU_ITEM.show()) {
            InventoryUtils.mainMenuButton(pManager, invGadgets, EnumItem.MAIN_MENU_ITEM.getSlot());
        }
        InventoryUtils.fillItems(invGadgets);
        player.openInventory(invGadgets);
    }

    @EventHandler
    public void onInvClickGadgets(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        for (GadgetCategoryType gadgetCategory : GadgetCategoryType.values()) {
            if (!event.getView().getTitle().equals(ChatUtil.format(gadgetCategory.getDisplayNameStripColor()))) continue;
            if (event.getClickedInventory() == null || event.getClickedInventory().getSize() != 54 || event.getClickedInventory().getType() != InventoryType.CHEST) {
                event.setCancelled(true);
                return;
            }
            if (!Category.GADGETS.isEnabled() || !WorldUtils.isWorldEnabled(player, true)) {
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                event.setCancelled(true);
                player.updateInventory();
                return;
            }
            PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
            if (ItemUtils.getCurrentItem(event, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot())) {
                pManager.openCategoryGadgetsMenu();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.RESET_GADGET.getItemStack(), EnumItem.RESET_GADGET.getSlot())) {
                pManager.unequipGadget();
                player.sendMessage(MessageType.RESET_GADGET.getFormatMessage());
                if (EnumItem.RESET_GADGET.isPlaySoundEnabled()) {
                    EnumItem.RESET_GADGET.getSound().playSound(player, 1.0f, 2.0f);
                }
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.MAIN_MENU_ITEM.getDisplayName(), EnumItem.MAIN_MENU_ITEM.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            for (GadgetType gadget : GadgetType.getGroup(gadgetCategory.getName())) {
                if (!event.getCurrentItem().getItemMeta().getDisplayName().equals(ChatUtil.format(gadget.getDisplayName()))) continue;
                if (PermissionUtils.noPermission(player, gadget.getPermission(), EnumPermission.GADGETS.getPermission(), false)) {
                    if (Category.GADGETS.isPurchasable()) {
                        if (!gadget.isPurchasable()) {
                            player.sendMessage(MessageType.ITEM_UNPURCHASABLE.getFormatMessage());
                            if (EnumItem.ITEM_UNPURCHASABLE.isPlaySoundEnabled()) {
                                EnumItem.ITEM_UNPURCHASABLE.getSound().playSound(player, 1.0f, 0.5f);
                            }
                            player.closeInventory();
                            event.setCancelled(true);
                            return;
                        }
                        ItemCostDiscount discount = pManager.getItemCostDiscount();
                        int discountedPrice = gadget.getMysteryDust();
                        if (discount != null) {
                            discountedPrice = discount.getPriceAfterDiscount(gadget.getMysteryDust());
                        }
                        if (pManager.getMysteryDust() >= discountedPrice) {
                            pManager.purchaseData().setData(Category.GADGETS, gadget.getName(), gadget.getDisplayName(), discount, gadget.getMysteryDust(), gadget.getPermission());
                            pManager.openItemPurchaseMenu();
                        } else {
                            player.sendMessage(MessageType.NOT_ENOUGH_MYSTERY_DUST_TO_PURCHASE.getFormatMessage());
                            if (EnumItem.NOT_ENOUGH_MYSTERY_DUST.isPlaySoundEnabled()) {
                                EnumItem.NOT_ENOUGH_MYSTERY_DUST.getSound().playSound(player, 1.0f, 0.5f);
                            }
                            player.closeInventory();
                        }
                        event.setCancelled(true);
                        return;
                    }
                    if (PermissionUtils.noPermission(player, gadget.getPermission(), EnumPermission.GADGETS.getPermission(), true)) {
                        if (EnumItem.NO_PERMISSION.isPlaySoundEnabled()) {
                            EnumItem.NO_PERMISSION.getSound().playSound(player, 1.0f, 0.5f);
                        }
                        if (EnumItem.NO_PERMISSION.isCloseGUIMenuAfterSelect()) {
                            player.closeInventory();
                        }
                        event.setCancelled(true);
                        return;
                    }
                }
                if (pManager.getSelectedGadget() != null && ChatUtil.format(gadget.getDisplayName()).equals(pManager.getSelectedGadget().getDisplayName())) {
                    pManager.unequipGadget();
                    player.sendMessage(MessageType.RESET_GADGET.getFormatMessage());
                    if (EnumItem.RESET_GADGET.isPlaySoundEnabled()) {
                        EnumItem.RESET_GADGET.getSound().playSound(player, 1.0f, 2.0f);
                    }
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                if (!GadgetManager.checkRequirement(player, gadget)) {
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                player.sendMessage(MessageType.SELECT_GADGET.getFormatMessage().replace("{GADGET}", gadget.getDisplayNameStripColor()));
                GadgetManager.equipGadget(player, gadget);
                if (EnumItem.HAS_PERMISSION.isPlaySoundEnabled()) {
                    EnumItem.HAS_PERMISSION.getSound().playSound(player, 1.0f, 2.0f);
                }
                if (EnumItem.HAS_PERMISSION.isCloseGUIMenuAfterSelect()) {
                    player.closeInventory();
                } else {
                    GadgetTypesMenu.openGadgetTypesMenu(player, gadgetCategory.getName(), 1);
                }
                event.setCancelled(true);
                return;
            }
            event.setCancelled(true);
            return;
        }
    }
}

