/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.api.GadgetsMenuAPI;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.PetCategoryType;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.PetType;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.GInventory;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PetCategoriesMenu
implements Listener {
    public static void openCategoryPetsMenu(Player player) {
        int size = PetCategoryType.enabled().size();
        Inventory invPets = Bukkit.createInventory(null, (int)54, (String)Category.PETS.getGUIName());
        int i = 0;
        int from = 1;
        int to = 27;
        if (size < 27) {
            to = size;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        for (int h = from; h <= to; ++h) {
            try {
                if (h > size) break;
                PetCategoryType pet = PetCategoryType.enabled().get(h - 1);
                if (PetType.getGroup(pet.getName()).size() == 0) continue;
                if (!PermissionUtils.containsPermission(player, pet.getPermission())) {
                    if (EnumItem.NO_PERMISSION.showCustomItem()) {
                        InventoryUtils.inventoryCategory(player, invPets, pet.getDisplayName(), EnumItem.NO_PERMISSION.getCustomItem(), pet.getLore(), null, GInventory.LAY_OUT_27.getLayOut()[i++], PetCategoriesMenu.hasPermission(player, pet.getName()), PetType.getGroup(pet.getName()).size());
                        continue;
                    }
                    InventoryUtils.inventoryCategory(player, invPets, pet.getDisplayName(), pet.getMaterial(), pet.getLore(), null, GInventory.LAY_OUT_27.getLayOut()[i++], PetCategoriesMenu.hasPermission(player, pet.getName()), PetType.getGroup(pet.getName()).size());
                    continue;
                }
                InventoryUtils.inventoryCategoryAddGlow(player, invPets, pet.getDisplayName(), pet.getMaterial(), pet.getLore(), null, GInventory.LAY_OUT_27.getLayOut()[i++], GadgetsMenu.getPlayerManager(player).getSelectedCategoryPet() == null ? null : GadgetsMenu.getPlayerManager(player).getSelectedCategoryPet().getDisplayName(), PetCategoriesMenu.hasPermission(player, pet.getName()), PetType.getGroup(pet.getName()).size());
                continue;
            }
            catch (Exception e) {
                player.sendMessage(MessageType.ERROR.getFormatMessage());
                e.printStackTrace();
                return;
            }
        }
        if (EnumItem.RESET_PET.show()) {
            InventoryUtils.inventory(invPets, EnumItem.RESET_PET.getItemStack(), EnumItem.RESET_PET.getSlot());
        }
        if (EnumItem.GO_BACK.show()) {
            InventoryUtils.inventory(invPets, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot());
        }
        if (EnumItem.RENAME_PET.show()) {
            InventoryUtils.inventory(invPets, EnumItem.RENAME_PET.getItemStack(), EnumItem.RENAME_PET.getSlot());
        }
        if (EnumItem.MAIN_MENU_ITEM.show()) {
            InventoryUtils.mainMenuButton(pManager, invPets, EnumItem.MAIN_MENU_ITEM.getSlot());
        }
        InventoryUtils.fillItems(invPets);
        player.openInventory(invPets);
    }

    @EventHandler
    public void onInvClickCategoryPets(InventoryClickEvent event) {
        final Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().equals(Category.PETS.getGUIName())) {
            if (event.getClickedInventory() == null || event.getClickedInventory().getSize() != 54 || event.getClickedInventory().getType() != InventoryType.CHEST) {
                event.setCancelled(true);
                return;
            }
            if (!Category.PETS.isEnabled() || !WorldUtils.isWorldEnabled(player, true)) {
                event.setCancelled(true);
                player.closeInventory();
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                event.setCancelled(true);
                player.updateInventory();
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            final PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
            if (ItemUtils.getCurrentItem(event, EnumItem.RESET_PET.getItemStack(), EnumItem.RESET_PET.getSlot())) {
                pManager.unequipPet();
                player.sendMessage(MessageType.RESET_PET.getFormatMessage());
                if (EnumItem.RESET_PET.isPlaySoundEnabled()) {
                    EnumItem.RESET_PET.getSound().playSound(player, 1.0f, 2.0f);
                }
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.MAIN_MENU_ITEM.getDisplayName(), EnumItem.MAIN_MENU_ITEM.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.RENAME_PET.getItemStack(), EnumItem.RENAME_PET.getSlot())) {
                if (!player.hasPermission(EnumPermission.RENAME_PET.getPermission())) {
                    player.sendMessage(ChatUtil.format(MessageType.NO_PERMISSION.getFormatMessage().replace("{PERMISSION}", EnumPermission.RENAME_PET.getPermission())));
                    if (EnumItem.NO_PERMISSION.isPlaySoundEnabled()) {
                        EnumItem.NO_PERMISSION.getSound().playSound(player, 1.0f, 0.5f);
                    }
                    if (EnumItem.NO_PERMISSION.isCloseGUIMenuAfterSelect()) {
                        player.closeInventory();
                    }
                    event.setCancelled(true);
                    return;
                }
                player.sendMessage(MessageType.RENAME_PET_IN_CHAT.getFormatMessage());
                if (!pManager.isRenamingPet()) {
                    pManager.setRenamingPet(true);
                    new BukkitRunnable(){

                        public void run() {
                            if (pManager.isRenamingPet()) {
                                pManager.setRenamingPet(false);
                                player.sendMessage(MessageType.TIMED_OUT.getFormatMessage());
                            }
                        }
                    }.runTaskLater((Plugin)GadgetsMenu.getInstance(), 400L);
                }
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            for (PetCategoryType pet : PetCategoryType.values()) {
                if (!event.getCurrentItem().getItemMeta().getDisplayName().equals(ChatUtil.format(pet.getDisplayName()))) continue;
                try {
                    pManager.openPetTypesMenu(pet, 1);
                    event.setCancelled(true);
                    return;
                }
                catch (Exception Ex) {
                    Ex.printStackTrace();
                    player.sendMessage(MessageType.ERROR.getFormatMessage());
                }
            }
            event.setCancelled(true);
            return;
        }
    }

    private static int hasPermission(Player player, String group) {
        if (!PetCategoryType.valueOf(group).isEnabled()) {
            return 0;
        }
        if (player.hasPermission(EnumPermission.PETS.getPermission())) {
            return PetType.getGroup(group).size();
        }
        int size = 0;
        for (PetType type : PetType.getGroup(group)) {
            if (!type.isEnabled() || !player.hasPermission(type.getPermission())) continue;
            ++size;
        }
        return size;
    }
}

