/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.api.GadgetsMenuAPI;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.PetCategoryType;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.PetManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.PetType;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.GInventory;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.StringUtils;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.discount.DiscountManager;
import com.yapzhenyie.GadgetsMenu.utils.discount.ItemCostDiscount;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class PetTypesMenu
implements Listener {
    public static void openPetsEntityMenu(Player player, String group, int page) {
        int size = PetType.getGroup(group).size();
        int maxPages = GInventory.getMaxPagesAmount(21, size);
        if (page <= 0) {
            page = 1;
        }
        if (page > 1 && maxPages < page) {
            page = 1;
        }
        Inventory invPetEntity = Bukkit.createInventory(null, (int)54, (String)ChatUtil.format(PetCategoryType.valueOf(group).getDisplayNameStripColor() + StringUtils.addPlaceholders(EnumItem.PAGES.getDisplayName(), Arrays.asList("{CURRENT_PAGE}", "{MAX_PAGES}"), Arrays.asList(String.valueOf(page), String.valueOf(maxPages)))));
        int i = 0;
        int from = 1;
        if (page > 1) {
            from = 21 * (page - 1) + 1;
        }
        int to = 21;
        if (size < 21) {
            to = size;
        }
        if (page > 1) {
            to = size >= 21 * page ? 21 * page : size;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        for (int h = from; h <= to; ++h) {
            try {
                if (h > size) break;
                PetType pet = PetType.getGroup(group).get(h - 1);
                if (PermissionUtils.noPermission(player, pet.getPermission(), EnumPermission.PETS.getPermission(), false)) {
                    DiscountManager discountManager = new DiscountManager(pManager, Category.PETS.isPurchasable() && pet.isPurchasable(), pet.getMysteryDust());
                    if (EnumItem.NO_PERMISSION.showCustomItem()) {
                        InventoryUtils.inventory(invPetEntity, pet.getDisplayName(), EnumItem.NO_PERMISSION.getCustomItem(), pet.getLore(), EnumItem.NO_PERMISSION.isShowInLore() ? EnumItem.NO_PERMISSION.getLore() : null, discountManager.getLore(), GInventory.LAY_OUT_21.getLayOut()[i++]);
                        continue;
                    }
                    InventoryUtils.inventory(invPetEntity, pet.getDisplayName(), pet.getMaterial(), pet.getLore(), EnumItem.NO_PERMISSION.isShowInLore() ? EnumItem.NO_PERMISSION.getLore() : null, discountManager.getLore(), GInventory.LAY_OUT_21.getLayOut()[i++]);
                    continue;
                }
                InventoryUtils.inventoryAddGlow(invPetEntity, pet.getDisplayName(), pet.getMaterial(), pet.getLore(), EnumItem.HAS_PERMISSION.isShowInLore() ? EnumItem.HAS_PERMISSION.getLore() : null, GInventory.LAY_OUT_21.getLayOut()[i++], pManager.getSelectedPet() == null ? null : pManager.getSelectedPet().getDisplayName());
                continue;
            }
            catch (Exception Ex) {
                player.sendMessage(MessageType.ERROR.getFormatMessage());
                Ex.printStackTrace();
                return;
            }
        }
        if (EnumItem.RESET_PET.show()) {
            InventoryUtils.inventory(invPetEntity, EnumItem.RESET_PET.getItemStack(), EnumItem.RESET_PET.getSlot());
        }
        if (page == 1) {
            InventoryUtils.inventory(invPetEntity, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot());
        } else {
            InventoryUtils.inventory(invPetEntity, EnumItem.PREVIOUS_PAGE.getItemStack(), "{PAGE}", String.valueOf(page - 1), EnumItem.PREVIOUS_PAGE.getSlot());
        }
        if (page < maxPages) {
            InventoryUtils.inventory(invPetEntity, EnumItem.NEXT_PAGE.getItemStack(), "{PAGE}", String.valueOf(page + 1), EnumItem.NEXT_PAGE.getSlot());
        }
        if (EnumItem.MAIN_MENU_ITEM.show()) {
            InventoryUtils.mainMenuButton(pManager, invPetEntity, EnumItem.MAIN_MENU_ITEM.getSlot());
        }
        InventoryUtils.fillItems(invPetEntity);
        player.openInventory(invPetEntity);
        pManager.setCurrentPetsPage(page);
    }

    @EventHandler
    public void onInvClickPets(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        for (PetType.EnumPetType group : PetType.groups()) {
            String groupName = PetCategoryType.valueOf(group.getName()).getDisplayNameStripColor();
            PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
            if (!ChatUtil.stripColor(event.getView().getTitle()).equals(ChatUtil.stripColor(groupName + StringUtils.addPlaceholders(EnumItem.PAGES.getDisplayName(), Arrays.asList("{CURRENT_PAGE}", "{MAX_PAGES}"), Arrays.asList(String.valueOf(pManager.getCurrentPetsPage()), String.valueOf(GInventory.getMaxPagesAmount(21, PetType.getGroup(group.getName()).size()))))))) continue;
            if (event.getClickedInventory() == null || event.getClickedInventory().getSize() != 54 || event.getClickedInventory().getType() != InventoryType.CHEST) {
                event.setCancelled(true);
                return;
            }
            if (!Category.PETS.isEnabled() || !WorldUtils.isWorldEnabled(player, true)) {
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                player.updateInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot())) {
                pManager.openCategoryPetsMenu();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.RESET_PET.getItemStack(), EnumItem.RESET_PET.getSlot())) {
                pManager.unequipPet();
                player.sendMessage(MessageType.RESET_PET.getFormatMessage());
                if (EnumItem.RESET_PET.isPlaySoundEnabled()) {
                    EnumItem.RESET_PET.getSound().playSound(player, 1.0f, 2.0f);
                }
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.PREVIOUS_PAGE.getDisplayName(), EnumItem.PREVIOUS_PAGE.getSlot())) {
                PetTypesMenu.openPetsEntityMenu(player, group.getName(), pManager.getCurrentPetsPage() - 1);
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.NEXT_PAGE.getDisplayName(), EnumItem.NEXT_PAGE.getSlot())) {
                PetTypesMenu.openPetsEntityMenu(player, group.getName(), pManager.getCurrentPetsPage() + 1);
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.MAIN_MENU_ITEM.getDisplayName(), EnumItem.MAIN_MENU_ITEM.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            for (PetType petEntity : PetType.values()) {
                if (!event.getCurrentItem().getItemMeta().getDisplayName().equals(ChatUtil.format(petEntity.getDisplayName()))) continue;
                if (PermissionUtils.noPermission(player, petEntity.getPermission(), EnumPermission.PETS.getPermission(), false)) {
                    if (Category.PETS.isPurchasable()) {
                        if (!petEntity.isPurchasable()) {
                            player.sendMessage(MessageType.ITEM_UNPURCHASABLE.getFormatMessage());
                            if (EnumItem.ITEM_UNPURCHASABLE.isPlaySoundEnabled()) {
                                EnumItem.ITEM_UNPURCHASABLE.getSound().playSound(player, 1.0f, 0.5f);
                            }
                            player.closeInventory();
                            event.setCancelled(true);
                            return;
                        }
                        ItemCostDiscount discount = pManager.getItemCostDiscount();
                        int discountedPrice = petEntity.getMysteryDust();
                        if (discount != null) {
                            discountedPrice = discount.getPriceAfterDiscount(petEntity.getMysteryDust());
                        }
                        if (pManager.getMysteryDust() >= discountedPrice) {
                            pManager.purchaseData().setData(Category.PETS, petEntity.getName(), petEntity.getDisplayName(), discount, petEntity.getMysteryDust(), petEntity.getPermission());
                            pManager.openItemPurchaseMenu();
                        } else {
                            player.sendMessage(MessageType.NOT_ENOUGH_MYSTERY_DUST_TO_PURCHASE.getFormatMessage());
                            if (EnumItem.NOT_ENOUGH_MYSTERY_DUST.isPlaySoundEnabled()) {
                                EnumItem.NOT_ENOUGH_MYSTERY_DUST.getSound().playSound(player, 1.0f, 0.5f);
                            }
                            player.closeInventory();
                        }
                        event.setCancelled(true);
                        return;
                    }
                    if (!PermissionUtils.noPermission(player, petEntity.getPermission(), EnumPermission.PETS.getPermission(), true)) continue;
                    if (EnumItem.NO_PERMISSION.isPlaySoundEnabled()) {
                        EnumItem.NO_PERMISSION.getSound().playSound(player, 1.0f, 0.5f);
                    }
                    if (EnumItem.NO_PERMISSION.isCloseGUIMenuAfterSelect()) {
                        player.closeInventory();
                    }
                    event.setCancelled(true);
                    return;
                }
                try {
                    if (pManager.getSelectedPet() != null && ChatUtil.format(petEntity.getDisplayName()).equals(pManager.getSelectedPet().getDisplayName())) {
                        pManager.unequipPet();
                        player.sendMessage(MessageType.RESET_PET.getFormatMessage());
                        if (EnumItem.RESET_PET.isPlaySoundEnabled()) {
                            EnumItem.RESET_PET.getSound().playSound(player, 1.0f, 2.0f);
                        }
                        player.closeInventory();
                        event.setCancelled(true);
                        return;
                    }
                    if (!PetManager.checkRequirement(player, petEntity)) {
                        player.closeInventory();
                        event.setCancelled(true);
                        return;
                    }
                    pManager.equipPet(petEntity);
                    player.sendMessage(MessageType.SELECT_PET.getFormatMessage().replace("{PET}", petEntity.getDisplayNameStripColor()));
                    if (EnumItem.HAS_PERMISSION.isPlaySoundEnabled()) {
                        EnumItem.HAS_PERMISSION.getSound().playSound(player, 1.0f, 2.0f);
                    }
                    if (EnumItem.HAS_PERMISSION.isCloseGUIMenuAfterSelect()) {
                        player.closeInventory();
                    } else {
                        PetTypesMenu.openPetsEntityMenu(player, group.getName(), pManager.getCurrentPetsPage());
                    }
                    event.setCancelled(true);
                    return;
                }
                catch (Exception Ex) {
                    player.sendMessage(MessageType.ERROR.getFormatMessage());
                    Ex.printStackTrace();
                }
            }
            event.setCancelled(true);
            return;
        }
    }
}

