/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.api.GadgetsMenuAPI;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitType;
import com.yapzhenyie.GadgetsMenu.menu.menus.SuitEquipmentMenu;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.GInventory;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class SuitsMenu
implements Listener {
    public static void openSuitsMenu(Player player) {
        int size = SuitType.enabled().size();
        Inventory invSuits = Bukkit.createInventory(null, (int)54, (String)Category.SUITS.getGUIName());
        int i = 0;
        int from = 1;
        int to = 27;
        if (size < 27) {
            to = size;
        }
        for (int h = from; h <= to; ++h) {
            try {
                if (h > size) break;
                SuitType suits = SuitType.enabled().get(h - 1);
                if (!PermissionUtils.containsPermission(player, suits.getPermissions())) {
                    if (EnumItem.NO_PERMISSION.showCustomItem()) {
                        InventoryUtils.inventoryCategory(player, invSuits, suits.getDisplayName(), EnumItem.NO_PERMISSION.getCustomItem(), suits.getLore(), null, GInventory.LAY_OUT_27.getLayOut()[i++], SuitsMenu.hasPermission(player, suits), 4);
                        continue;
                    }
                    InventoryUtils.inventoryCategory(player, invSuits, suits.getDisplayName(), suits.getMaterial(), suits.getLore(), null, GInventory.LAY_OUT_27.getLayOut()[i++], SuitsMenu.hasPermission(player, suits), 4);
                    continue;
                }
                InventoryUtils.inventoryCategoryAddGlow(player, invSuits, suits.getDisplayName(), suits.getMaterial(), suits.getLore(), null, GInventory.LAY_OUT_27.getLayOut()[i++], null, SuitsMenu.hasPermission(player, suits), 4);
                continue;
            }
            catch (Exception Ex) {
                player.sendMessage(MessageType.ERROR.getFormatMessage());
                Ex.printStackTrace();
            }
        }
        if (EnumItem.RESET_SUIT.show()) {
            InventoryUtils.inventory(invSuits, EnumItem.RESET_SUIT.getItemStack(), EnumItem.RESET_SUIT.getSlot());
        }
        if (EnumItem.GO_BACK.show()) {
            InventoryUtils.inventory(invSuits, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot());
        }
        if (EnumItem.MAIN_MENU_ITEM.show()) {
            InventoryUtils.mainMenuButton(GadgetsMenu.getPlayerManager(player), invSuits, EnumItem.MAIN_MENU_ITEM.getSlot());
        }
        InventoryUtils.fillItems(invSuits);
        player.openInventory(invSuits);
    }

    @EventHandler
    public void onInvClickSuits(InventoryClickEvent e) {
        Player player = (Player)e.getWhoClicked();
        if (e.getView().getTitle().startsWith(Category.SUITS.getGUIName())) {
            if (e.getClickedInventory() == null || e.getClickedInventory().getSize() != 54 || e.getClickedInventory().getType() != InventoryType.CHEST) {
                e.setCancelled(true);
                return;
            }
            if (!Category.SUITS.isEnabled() || !WorldUtils.isWorldEnabled(player, true)) {
                e.setCancelled(true);
                player.closeInventory();
                return;
            }
            if (e.getCurrentItem() == null || e.getCurrentItem().getItemMeta() == null || e.getCurrentItem().getItemMeta().getDisplayName() == null) {
                e.setCancelled(true);
                return;
            }
            if (e.getClick() == ClickType.SHIFT_LEFT || e.getClick() == ClickType.SHIFT_RIGHT || e.getClick() == ClickType.NUMBER_KEY || e.getClick() == ClickType.UNKNOWN) {
                e.setCancelled(true);
                player.updateInventory();
                return;
            }
            if (ItemUtils.getCurrentItem(e, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                e.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(e, EnumItem.RESET_SUIT.getItemStack(), EnumItem.RESET_SUIT.getSlot())) {
                GadgetsMenu.getPlayerManager(player).unequipSuit();
                player.sendMessage(MessageType.RESET_SUIT.getFormatMessage());
                if (EnumItem.RESET_SUIT.isPlaySoundEnabled()) {
                    EnumItem.RESET_SUIT.getSound().playSound(player, 1.0f, 2.0f);
                }
                player.closeInventory();
                e.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(e, EnumItem.MAIN_MENU_ITEM.getDisplayName(), EnumItem.MAIN_MENU_ITEM.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                e.setCancelled(true);
                return;
            }
            for (SuitType suit : SuitType.values()) {
                if (!e.getCurrentItem().getItemMeta().getDisplayName().equals(ChatUtil.format(suit.getDisplayName()))) continue;
                try {
                    SuitEquipmentMenu.openSuitEquipmentMenu(player, suit.getName());
                    e.setCancelled(true);
                }
                catch (Exception Ex) {
                    Ex.printStackTrace();
                    player.sendMessage(MessageType.ERROR.getFormatMessage());
                }
            }
            e.setCancelled(true);
            return;
        }
    }

    private static int hasPermission(Player player, SuitType category) {
        if (!category.isEnabled()) {
            return 0;
        }
        if (player.hasPermission(EnumPermission.SUITS.getPermission())) {
            return category.getPermissions().size();
        }
        int size = 0;
        for (String perm : category.getPermissions()) {
            if (!player.hasPermission(perm)) continue;
            ++size;
        }
        return size;
    }
}

