/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus.mysteryboxes;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.api.event.mysteryboxes.OpenMysteryBoxEvent;
import com.yapzhenyie.GadgetsMenu.mysteryboxes.MysteryBoxes;
import com.yapzhenyie.GadgetsMenu.mysteryboxes.MysteryBoxesLoot;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.GCommandHandler;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Quality;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Rarity;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVault;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVaultManager;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.AnimationType;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public class ConfirmOpenMultipleBoxesMenu
implements Listener {
    public static void openConfirmOpenMultipleBoxesMenu(Player player) {
        Inventory invConfirmOpenMultipleBoxes = Bukkit.createInventory(null, (int)27, (String)GadgetsMenu.getGadgetsMenuData().getConfirmOpenMultipleBoxesGUIName());
        InventoryUtils.inventory(invConfirmOpenMultipleBoxes, EnumItem.CONFIRM_OPEN_MULTIPLE_BOXES.getItemStack(), EnumItem.CONFIRM_OPEN_MULTIPLE_BOXES.getSlot());
        InventoryUtils.inventory(invConfirmOpenMultipleBoxes, EnumItem.CANCEL_OPEN_MULTIPLE_BOXES.getItemStack(), EnumItem.CANCEL_OPEN_MULTIPLE_BOXES.getSlot());
        InventoryUtils.fillItems(invConfirmOpenMultipleBoxes);
        player.openInventory(invConfirmOpenMultipleBoxes);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInvClickConfirmOpenMultipleBoxesMenu(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().equals(ChatUtil.format(GadgetsMenu.getGadgetsMenuData().getConfirmOpenMultipleBoxesGUIName()))) {
            if (event.getClickedInventory() == null || event.getClickedInventory().getSize() != 27 || event.getClickedInventory().getType() != InventoryType.CHEST) {
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                event.setCancelled(true);
                player.updateInventory();
                return;
            }
            if (!GadgetsMenu.getGadgetsMenuData().isMysteryBoxesEnabled() || !WorldUtils.isWorldEnabled(player, true)) {
                SoundEffect.ENTITY_ENDERMAN_TELEPORT.playSound(player, 1.0f, 0.5f);
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.CONFIRM_OPEN_MULTIPLE_BOXES.getDisplayName(), EnumItem.CONFIRM_OPEN_MULTIPLE_BOXES.getSlot())) {
                PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
                if (pManager == null) {
                    player.sendMessage(MessageType.ERROR.getFormatMessage());
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                MysteryVault selectedMysteryVault = pManager.getSelectedMysteryVault();
                if (pManager.isOpeningMysteryBox()) {
                    player.sendMessage(MessageType.CAN_ONLY_OPEN_ONE_MYSTERY_BOX.getFormatMessage());
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                if (selectedMysteryVault == null || pManager.getOpenMultipleBoxesType() == null) {
                    player.sendMessage(MessageType.ERROR.getFormatMessage());
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                OpenMysteryBoxEvent openBoxEvent = new OpenMysteryBoxEvent(player, pManager.getSelectedMysteryBox());
                Bukkit.getServer().getPluginManager().callEvent((Event)openBoxEvent);
                if (openBoxEvent.isCancelled()) {
                    player.sendMessage(MessageType.ERROR.getFormatMessage());
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                for (MysteryVault vault : MysteryVaultManager.activatedVaults()) {
                    if (vault != selectedMysteryVault) continue;
                    player.sendMessage(MessageType.OPEN_MYSTERY_VAULT_AT_A_TIME.getFormatMessage());
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                if (!pManager.isRandomMysteryVaultAnimationSelected() && PermissionUtils.noPermission(pManager.getPlayer(), pManager.getMysteryVaultAnimation().getPermission(), EnumPermission.ALL_MYSTERY_VAULT_ANIMATIONS.getPermission(), true)) {
                    event.setCancelled(true);
                    return;
                }
                if (!MysteryVaultManager.activatedVaults().contains(selectedMysteryVault)) {
                    MysteryVaultManager.activatedVaults().add(selectedMysteryVault);
                }
                if (!pManager.isRandomMysteryVaultAnimationSelected() && !pManager.getMysteryVaultAnimation().isEnabled()) {
                    pManager.setMysteryVaultAnimation(AnimationType.enabled().get(0));
                }
                pManager.setOpeningMysteryBox(true);
                AnimationType randomAnimation = null;
                if (pManager.isRandomMysteryVaultAnimationSelected()) {
                    randomAnimation = pManager.getRandomMysteryVaultAnimation();
                    if (PermissionUtils.noPermission(pManager.getPlayer(), randomAnimation.getPermission(), EnumPermission.ALL_MYSTERY_VAULT_ANIMATIONS.getPermission(), true)) {
                        if (MysteryVaultManager.activatedVaults().contains(selectedMysteryVault)) {
                            MysteryVaultManager.activatedVaults().remove(selectedMysteryVault);
                        }
                        pManager.setOpeningMysteryBox(false);
                        player.closeInventory();
                        event.setCancelled(true);
                        return;
                    }
                    pManager.setAnimation(randomAnimation.equip(pManager, selectedMysteryVault, Quality.FIVE_STAR, 0L));
                } else {
                    pManager.setAnimation(pManager.getMysteryVaultAnimation().equip(pManager, selectedMysteryVault, Quality.FIVE_STAR, 0L));
                }
                Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), () -> {
                    if (player == null || !player.isOnline() || pManager == null || !pManager.isOpeningMysteryBox()) {
                        return;
                    }
                    ConfirmOpenMultipleBoxesMenu.openBoxes(pManager, selectedMysteryVault, pManager.getOpenMultipleBoxesType());
                }, pManager.isRandomMysteryVaultAnimationSelected() ? randomAnimation.getDurationTime() : pManager.getMysteryVaultAnimation().getDurationTime());
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.CANCEL_OPEN_MULTIPLE_BOXES.getDisplayName(), EnumItem.CANCEL_OPEN_MULTIPLE_BOXES.getSlot())) {
                GadgetsMenu.getPlayerManager(player).openMysteryVaultMenu(1);
                event.setCancelled(true);
                return;
            }
            event.setCancelled(true);
            return;
        }
    }

    private static void openBoxes(PlayerManager pManager, MysteryVault mysteryVault, OpenMultipleBoxesType openType) {
        ArrayList<MysteryBoxesLoot> common = new ArrayList<MysteryBoxesLoot>();
        ArrayList<MysteryBoxesLoot> rare = new ArrayList<MysteryBoxesLoot>();
        ArrayList<MysteryBoxesLoot> epic = new ArrayList<MysteryBoxesLoot>();
        ArrayList<MysteryBoxesLoot> legendary = new ArrayList<MysteryBoxesLoot>();
        int mysteryDust = 0;
        int size = pManager.getMysteryBoxes();
        int openBoxesSize = pManager.getMysteryBoxes();
        int mysteryBoxesOpened = 0;
        if (openType == OpenMultipleBoxesType.OPEN_20_BOXES && pManager.getMysteryBoxes() >= 20) {
            openBoxesSize = 20;
        } else if (openType == OpenMultipleBoxesType.OPEN_50_BOXES && pManager.getMysteryBoxes() >= 50) {
            openBoxesSize = 50;
        } else if (openType == OpenMultipleBoxesType.OPEN_250_BOXES && pManager.getMysteryBoxes() >= 250) {
            openBoxesSize = 250;
        }
        for (int i = 1; i <= openBoxesSize && size - i >= 0; ++i) {
            MysteryBoxes box = pManager.mysteryBoxes().get(size - i);
            if (box.isRequiredPermission() && PermissionUtils.noPermission(pManager.getPlayer(), box.getMysteryBoxType().getPermission(), EnumPermission.OPEN_ALL_MYSTERY_BOXES.getPermission(), false)) {
                ++openBoxesSize;
                continue;
            }
            ++mysteryBoxesOpened;
            MysteryBoxesLoot loot = box.open();
            if (loot.getRarity() == Rarity.COMMON) {
                for (MysteryBoxesLoot l : common) {
                    if (!l.toString().equalsIgnoreCase(loot.toString())) continue;
                    common.remove(l);
                    break;
                }
                common.add(loot);
            } else if (loot.getRarity() == Rarity.RARE) {
                for (MysteryBoxesLoot l : rare) {
                    if (!l.toString().equalsIgnoreCase(loot.toString())) continue;
                    rare.remove(l);
                    break;
                }
                rare.add(loot);
            } else if (loot.getRarity() == Rarity.EPIC) {
                for (MysteryBoxesLoot l : epic) {
                    if (!l.toString().equalsIgnoreCase(loot.toString())) continue;
                    epic.remove(l);
                    break;
                }
                epic.add(loot);
            } else if (loot.getRarity() == Rarity.LEGENDARY) {
                for (MysteryBoxesLoot l : legendary) {
                    if (!l.toString().equalsIgnoreCase(loot.toString())) continue;
                    legendary.remove(l);
                    break;
                }
                legendary.add(loot);
            }
            if (!pManager.getPlayer().hasPermission(loot.getPermission())) {
                GCommandHandler.executeCommand(GadgetsMenu.getGadgetsMenuData().getFoundMysteryBoxLootCommand().replace("{PLAYER}", pManager.getPlayer().getName()).replace("{PERMISSION}", loot.getPermission()));
            } else {
                if (loot.getRarity().isGiveMysteryDustEnabled()) {
                    mysteryDust += loot.getRarity().getRandomMysteryDustInRange();
                }
                if (loot.getRarity().executeCustomCommand()) {
                    GCommandHandler.executeCommand(loot.getRarity().getCustomCommand().replace("{PLAYER}", pManager.getPlayer().getName()));
                }
            }
            if (pManager.getRecentLootsFound() == null) {
                pManager.setRecentLootsFound(loot.getRarity().getDisplayName() + " " + loot.getDisplayName() + ", ");
            } else {
                Object recentLoots = "";
                for (int i2 = 0; i2 <= (pManager.getRecentLootsFound().length >= 5 ? 3 : pManager.getRecentLootsFound().length - 1); ++i2) {
                    if (i2 == 3 && pManager.getRecentLootsFound().length >= 5) {
                        recentLoots = (String)recentLoots + pManager.getRecentLootsFound()[i2];
                        break;
                    }
                    recentLoots = (String)recentLoots + pManager.getRecentLootsFound()[i2] + ", ";
                }
                if (((String)recentLoots).endsWith(", ")) {
                    recentLoots = ChatUtil.format(((String)recentLoots).substring(0, ((String)recentLoots).length() - 2));
                }
                pManager.setRecentLootsFound(loot.getRarity().getDisplayName() + " " + loot.getDisplayName() + ", " + (String)recentLoots);
            }
            pManager.removeMysteryBox(box);
        }
        pManager.addMysteryDust(mysteryDust);
        ArrayList<String> ls = new ArrayList<String>();
        int count = 1;
        String loots = "";
        for (MysteryBoxesLoot l : legendary) {
            if ((loots = loots + l.getRarity().getDisplayName() + " " + l.getDisplayName() + (count == 14 ? "" : "\n")).replace("\n", "").length() > 260) {
                if (loots.endsWith("\n")) {
                    loots = ChatUtil.format(loots.substring(0, loots.length() - 1));
                }
                ls.add(loots);
                count = 1;
                loots = "";
                continue;
            }
            if (count == 14) {
                ls.add(loots);
                count = 1;
                loots = "";
                continue;
            }
            ++count;
        }
        for (MysteryBoxesLoot e : epic) {
            if ((loots = loots + e.getRarity().getDisplayName() + " " + e.getDisplayName() + (count == 14 ? "" : "\n")).replace("\n", "").length() > 260) {
                if (loots.endsWith("\n")) {
                    loots = ChatUtil.format(loots.substring(0, loots.length() - 1));
                }
                ls.add(loots);
                count = 1;
                loots = "";
                continue;
            }
            if (count == 14) {
                ls.add(loots);
                count = 1;
                loots = "";
                continue;
            }
            ++count;
        }
        for (MysteryBoxesLoot r : rare) {
            if ((loots = loots + r.getRarity().getDisplayName() + " " + r.getDisplayName() + (count == 14 ? "" : "\n")).replace("\n", "").length() > 260) {
                if (loots.endsWith("\n")) {
                    loots = ChatUtil.format(loots.substring(0, loots.length() - 1));
                }
                ls.add(loots);
                count = 1;
                loots = "";
                continue;
            }
            if (count == 14) {
                ls.add(loots);
                count = 1;
                loots = "";
                continue;
            }
            ++count;
        }
        for (MysteryBoxesLoot c : common) {
            if ((loots = loots + c.getRarity().getDisplayName() + " " + c.getDisplayName() + (count == 14 ? "" : "\n")).replace("\n", "").length() > 260) {
                if (loots.endsWith("\n")) {
                    loots = ChatUtil.format(loots.substring(0, loots.length() - 1));
                }
                ls.add(loots);
                count = 1;
                loots = "";
                continue;
            }
            if (count == 14) {
                ls.add(loots);
                count = 1;
                loots = "";
                continue;
            }
            ++count;
        }
        if (count != 1) {
            if (loots.endsWith("\n")) {
                loots = ChatUtil.format(loots.substring(0, loots.length() - 1));
            }
            ls.add(loots);
        }
        String firstPage = "";
        for (String s : EnumItem.MULTIPLE_BOXES_LOOT_BOOK.getLore()) {
            firstPage = firstPage + ChatUtil.format(s + "\n").replace("{MYSTERY_DUST}", String.valueOf(mysteryDust)).replace("{MYSTERY_BOXES_OPENED}", String.valueOf(mysteryBoxesOpened));
        }
        GadgetsMenu.getNMSManager().openBook(GadgetsMenu.getNMSManager().createBook("Mystery Boxes", firstPage, ls), pManager.getPlayer());
        if (legendary.size() > 0) {
            if (Rarity.LEGENDARY.isPlaySoundEnabled()) {
                Rarity.LEGENDARY.getSound().playSound(mysteryVault.getLocation());
            }
            mysteryVault.createLootHologram(Rarity.LEGENDARY.getFoundLootHologram().replace("{LOOT}", ((MysteryBoxesLoot)legendary.get(GadgetsMenu.random().nextInt(legendary.size()))).getDisplayNameStripColor()));
            mysteryVault.removeLootHologram(3);
            return;
        }
        if (epic.size() > 0) {
            if (Rarity.EPIC.isPlaySoundEnabled()) {
                Rarity.EPIC.getSound().playSound(mysteryVault.getLocation());
            }
            mysteryVault.createLootHologram(Rarity.EPIC.getFoundLootHologram().replace("{LOOT}", ((MysteryBoxesLoot)epic.get(GadgetsMenu.random().nextInt(epic.size()))).getDisplayNameStripColor()));
            mysteryVault.removeLootHologram(3);
            return;
        }
        if (rare.size() > 0) {
            if (Rarity.RARE.isPlaySoundEnabled()) {
                Rarity.RARE.getSound().playSound(mysteryVault.getLocation());
            }
            mysteryVault.createLootHologram(Rarity.RARE.getFoundLootHologram().replace("{LOOT}", ((MysteryBoxesLoot)rare.get(GadgetsMenu.random().nextInt(rare.size()))).getDisplayNameStripColor()));
            mysteryVault.removeLootHologram(3);
            return;
        }
        if (common.size() > 0) {
            if (Rarity.COMMON.isPlaySoundEnabled()) {
                Rarity.COMMON.getSound().playSound(mysteryVault.getLocation());
            }
            mysteryVault.createLootHologram(Rarity.COMMON.getFoundLootHologram().replace("{LOOT}", ((MysteryBoxesLoot)common.get(GadgetsMenu.random().nextInt(common.size()))).getDisplayNameStripColor()));
            mysteryVault.removeLootHologram(3);
            return;
        }
    }

    public static enum OpenMultipleBoxesType {
        OPEN_20_BOXES(20),
        OPEN_50_BOXES(50),
        OPEN_250_BOXES(250);

        private int openBoxes;

        private OpenMultipleBoxesType(int openBoxes) {
            this.openBoxes = openBoxes;
        }

        public int getOpenBoxes() {
            return this.openBoxes;
        }
    }
}

