/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus.mysteryboxes;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.api.event.mysteryboxes.OpenMysteryBoxEvent;
import com.yapzhenyie.GadgetsMenu.cosmetics.MainMenuType;
import com.yapzhenyie.GadgetsMenu.mysteryboxes.MysteryBoxes;
import com.yapzhenyie.GadgetsMenu.mysteryboxes.MysteryBoxesLoot;
import com.yapzhenyie.GadgetsMenu.mysteryboxes.MysteryBoxesMessages;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.GCommandHandler;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.StringUtils;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemLoreUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.MysteryBoxJSONMessages;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVault;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVaultManager;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.AnimationType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public class ConfirmOpenMysteryBoxMenu
implements Listener {
    public static void openConfirmOpenMysteryBoxMenu(Player player) {
        Inventory invConfirmOpenMysteryBox = Bukkit.createInventory(null, (int)54, (String)ChatUtil.format(GadgetsMenu.getGadgetsMenuData().getConfirmOpenMysteryBoxGUIName()));
        MysteryBoxes mysteryBox = GadgetsMenu.getPlayerManager(player).getSelectedMysteryBox();
        if (mysteryBox == null) {
            throw new IllegalArgumentException("Player must select a mystery box before opening this menu.");
        }
        InventoryUtils.inventory(invConfirmOpenMysteryBox, mysteryBox.getMysteryBoxType().getDisplayName(), mysteryBox.getMysteryBoxType().getMaterial(), mysteryBox.getLore(), 13);
        InventoryUtils.inventory(invConfirmOpenMysteryBox, EnumItem.CONFIRM_OPEN_MYSTERY_BOX.getDisplayName(), EnumItem.CONFIRM_OPEN_MYSTERY_BOX.getMaterial(), EnumItem.CONFIRM_OPEN_MYSTERY_BOX.getLore(), EnumItem.CONFIRM_OPEN_MYSTERY_BOX.getSlot());
        InventoryUtils.inventory(invConfirmOpenMysteryBox, EnumItem.CANCEL_OPEN_MYSTERY_BOX.getDisplayName(), EnumItem.CANCEL_OPEN_MYSTERY_BOX.getMaterial(), EnumItem.CANCEL_OPEN_MYSTERY_BOX.getLore(), EnumItem.CANCEL_OPEN_MYSTERY_BOX.getSlot());
        InventoryUtils.fillItems(invConfirmOpenMysteryBox);
        player.openInventory(invConfirmOpenMysteryBox);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInvClickConfirmOpenMysteryBoxMenu(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().equals(ChatUtil.format(GadgetsMenu.getGadgetsMenuData().getConfirmOpenMysteryBoxGUIName()))) {
            if (event.getClickedInventory() == null || event.getClickedInventory().getSize() != 54 || event.getClickedInventory().getType() != InventoryType.CHEST) {
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                player.updateInventory();
                event.setCancelled(true);
                return;
            }
            if (!GadgetsMenu.getGadgetsMenuData().isMysteryBoxesEnabled() || !WorldUtils.isWorldEnabled(player, true)) {
                SoundEffect.ENTITY_ENDERMAN_TELEPORT.playSound(player, 1.0f, 0.5f);
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.CONFIRM_OPEN_MYSTERY_BOX.getDisplayName(), EnumItem.CONFIRM_OPEN_MYSTERY_BOX.getSlot())) {
                PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
                if (pManager == null) {
                    player.sendMessage(MessageType.ERROR.getFormatMessage());
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                MysteryVault selectedMysteryVault = pManager.getSelectedMysteryVault();
                if (pManager.isOpeningMysteryBox()) {
                    player.sendMessage(MessageType.CAN_ONLY_OPEN_ONE_MYSTERY_BOX.getFormatMessage());
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                if (selectedMysteryVault == null || pManager.getSelectedMysteryBox() == null) {
                    player.sendMessage(MessageType.ERROR.getFormatMessage());
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                OpenMysteryBoxEvent openBoxEvent = new OpenMysteryBoxEvent(player, pManager.getSelectedMysteryBox());
                Bukkit.getServer().getPluginManager().callEvent((Event)openBoxEvent);
                if (openBoxEvent.isCancelled()) {
                    player.sendMessage(MessageType.ERROR.getFormatMessage());
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                for (MysteryVault vault : MysteryVaultManager.activatedVaults()) {
                    if (vault != selectedMysteryVault) continue;
                    player.sendMessage(MessageType.OPEN_MYSTERY_VAULT_AT_A_TIME.getFormatMessage());
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                MysteryBoxes mysteryBox = pManager.getSelectedMysteryBox();
                MysteryBoxesLoot loot = mysteryBox.open();
                if (loot == null || loot.getCategory() == null || loot.getName() == null || loot.getPermission() == null) {
                    player.sendMessage(MessageType.ERROR.getFormatMessage());
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                if (!pManager.isRandomMysteryVaultAnimationSelected() && PermissionUtils.noPermission(pManager.getPlayer(), pManager.getMysteryVaultAnimation().getPermission(), EnumPermission.ALL_MYSTERY_VAULT_ANIMATIONS.getPermission(), true)) {
                    event.setCancelled(true);
                    return;
                }
                if (!MysteryVaultManager.activatedVaults().contains(selectedMysteryVault)) {
                    MysteryVaultManager.activatedVaults().add(selectedMysteryVault);
                }
                if (!pManager.isRandomMysteryVaultAnimationSelected() && !pManager.getMysteryVaultAnimation().isEnabled()) {
                    pManager.setMysteryVaultAnimation(AnimationType.enabled().get(0));
                }
                pManager.setOpeningMysteryBox(true);
                AnimationType randomAnimation = null;
                if (pManager.isRandomMysteryVaultAnimationSelected()) {
                    randomAnimation = pManager.getRandomMysteryVaultAnimation();
                    if (PermissionUtils.noPermission(pManager.getPlayer(), randomAnimation.getPermission(), EnumPermission.ALL_MYSTERY_VAULT_ANIMATIONS.getPermission(), true)) {
                        if (MysteryVaultManager.activatedVaults().contains(selectedMysteryVault)) {
                            MysteryVaultManager.activatedVaults().remove(selectedMysteryVault);
                        }
                        pManager.setOpeningMysteryBox(false);
                        player.closeInventory();
                        event.setCancelled(true);
                        return;
                    }
                    pManager.setAnimation(randomAnimation.equip(pManager, selectedMysteryVault, mysteryBox.getQuality(), 0L));
                } else {
                    pManager.setAnimation(pManager.getMysteryVaultAnimation().equip(pManager, selectedMysteryVault, mysteryBox.getQuality(), 0L));
                }
                if (MysteryBoxesMessages.isOpeningMysteryBoxBoardcastEnabled) {
                    for (Player players : Bukkit.getOnlinePlayers()) {
                        if (!WorldUtils.isWorldEnabled(players.getWorld()) || !players.canSee(player) || players == player) continue;
                        players.sendMessage(ChatUtil.format(MysteryBoxesMessages.openingMysteryBoxBoardcastMessage.replace("{PLAYER}", player.getDisplayName())));
                    }
                }
                Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), () -> {
                    if (player == null || !player.isOnline() || pManager == null || !pManager.isOpeningMysteryBox()) {
                        return;
                    }
                    ConfirmOpenMysteryBoxMenu.sendLootMessage(pManager, player, selectedMysteryVault, loot);
                    pManager.removeMysteryBox(mysteryBox);
                    pManager.setSelectedMysteryBox(null);
                }, pManager.isRandomMysteryVaultAnimationSelected() ? randomAnimation.getDurationTime() : pManager.getMysteryVaultAnimation().getDurationTime());
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.CANCEL_OPEN_MYSTERY_BOX.getDisplayName(), EnumItem.CANCEL_OPEN_MYSTERY_BOX.getSlot())) {
                GadgetsMenu.getPlayerManager(player).openMysteryVaultMenu(1);
                event.setCancelled(true);
                return;
            }
            event.setCancelled(true);
            return;
        }
    }

    private static void sendLootMessage(PlayerManager pManager, Player player, MysteryVault mysteryVault, MysteryBoxesLoot loot) {
        MysteryBoxJSONMessages json;
        String displayName = loot.getDisplayNameStripColor();
        if (loot.getRarity().isSendMessageEnabled()) {
            for (String msg : loot.getRarity().getFoundLootMessages()) {
                if (msg.contains("{LOOT}")) {
                    json = MysteryBoxJSONMessages.valueOf(loot.getRarity());
                    GadgetsMenu.getNMSManager().newJSONMessage(ChatUtil.format(msg.replace("{LOOT}", displayName))).showText(ItemLoreUtils.combineLore(ChatUtil.format(json.getDisplayName().replace("{LOOT}", displayName)), StringUtils.addPlaceholder(json.getLore(), "{CATEGORY}", MainMenuType.valueOf(loot.getCategory().getName()).getDisplayName()))).send(player);
                    continue;
                }
                player.sendMessage(ChatUtil.format(msg));
            }
        }
        if (loot.getRarity().isPlaySoundEnabled()) {
            loot.getRarity().getSound().playSound(mysteryVault.getLocation());
        }
        if (loot.getRarity().isBroadcastMessagesEnabled()) {
            for (Object players : Bukkit.getOnlinePlayers()) {
                if (!WorldUtils.isWorldEnabled(players.getWorld()) || !players.canSee(player) || players == player) continue;
                json = MysteryBoxJSONMessages.valueOf(loot.getRarity());
                GadgetsMenu.getNMSManager().newJSONMessage(ChatUtil.format(loot.getRarity().getBroadcastMessage().replace("{PLAYER}", player.getDisplayName()).replace("{LOOT}", displayName).replace("{MYSTERY_DUST}", String.valueOf(loot.getMysteryDust())))).showText(ItemLoreUtils.combineLore(ChatUtil.format(json.getDisplayName().replace("{LOOT}", displayName)), StringUtils.addPlaceholder(json.getLore(), "{CATEGORY}", MainMenuType.valueOf(loot.getCategory().getName()).getDisplayName()))).send((Player)players);
            }
        }
        mysteryVault.createLootHologram(loot.getRarity().getFoundLootHologram().replace("{LOOT}", displayName));
        mysteryVault.removeLootHologram(3);
        if (!player.hasPermission(loot.getPermission())) {
            GCommandHandler.executeCommand(GadgetsMenu.getGadgetsMenuData().getFoundMysteryBoxLootCommand().replace("{PLAYER}", player.getName()).replace("{PERMISSION}", loot.getPermission()));
            if (GadgetsMenu.getGadgetsMenuData().isAutoEquipOnLootFoundEnabled() || !PermissionUtils.noPermission(player, EnumPermission.AUTO_EQUIP_ON_LOOT_FOUND.getPermission(), false)) {
                loot.equip(player);
            }
        } else {
            int amount = 0;
            if (loot.getRarity().isGiveMysteryDustEnabled()) {
                amount = loot.getRarity().getRandomMysteryDustInRange();
                pManager.addMysteryDust(amount);
            }
            if (loot.getRarity().isSendAlreadyHadLootMessagesEnabled()) {
                for (String msg : loot.getRarity().getAlreadyHadLootMessages()) {
                    player.sendMessage(ChatUtil.format(msg.replace("{MYSTERY_DUST}", String.valueOf(amount)).replace("{LOOT}", displayName)));
                }
            }
            if (loot.getRarity().executeCustomCommand()) {
                GCommandHandler.executeCommand(loot.getRarity().getCustomCommand().replace("{PLAYER}", player.getName()));
            }
        }
        if (pManager.getRecentLootsFound() == null) {
            pManager.setRecentLootsFound(loot.getRarity().getDisplayName() + " " + loot.getDisplayName());
        } else {
            String recentLoots = "";
            for (int i = 0; i <= (pManager.getRecentLootsFound().length >= 5 ? 3 : pManager.getRecentLootsFound().length - 1); ++i) {
                recentLoots = recentLoots + pManager.getRecentLootsFound()[i] + ", ";
            }
            if (recentLoots.endsWith(", ")) {
                recentLoots = ChatUtil.format(recentLoots.substring(0, recentLoots.length() - 2));
            }
            pManager.setRecentLootsFound(loot.getRarity().getDisplayName() + " " + loot.getDisplayName() + ", " + recentLoots);
        }
    }
}

