/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus.mysteryboxes;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.api.event.mysteryboxes.PlayerSendMysteryGiftEvent;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.MysteryBoxType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class ConfirmSendGiftMenu
implements Listener {
    public static void openConfirmSendGiftMenu(Player player) {
        Player selectedPlayer = GadgetsMenu.getPlayerManager(player).getSelectedSendGiftPlayer();
        if (selectedPlayer == null || !selectedPlayer.isOnline()) {
            player.sendMessage(MessageType.ERROR.getFormatMessage());
            return;
        }
        Inventory invConfirmSendGift = Bukkit.createInventory(null, (int)45, (String)GadgetsMenu.getGadgetsMenuData().getConfirmSendGiftGUIName());
        InventoryUtils.inventory(invConfirmSendGift, EnumItem.MYSTERY_GIFT_CONFIRM_SEND_GIFT.getDisplayName(), EnumItem.MYSTERY_GIFT_CONFIRM_SEND_GIFT.getMaterial(), EnumItem.MYSTERY_GIFT_CONFIRM_SEND_GIFT.getLore(), EnumItem.MYSTERY_GIFT_CONFIRM_SEND_GIFT.getSlot());
        InventoryUtils.inventorySkull(invConfirmSendGift, EnumItem.PLAYER_CONFIRM_SEND_GIFT.getDisplayName().replace("{PLAYER}", selectedPlayer.getName()), EnumItem.PLAYER_CONFIRM_SEND_GIFT.getLore(), null, selectedPlayer, EnumItem.PLAYER_CONFIRM_SEND_GIFT.getSlot());
        InventoryUtils.inventory(invConfirmSendGift, EnumItem.CONFIRM_SEND_GIFT.getItemStack(), EnumItem.CONFIRM_SEND_GIFT.getSlot());
        InventoryUtils.inventory(invConfirmSendGift, EnumItem.CANCEL_SEND_GIFT.getItemStack(), EnumItem.CANCEL_SEND_GIFT.getSlot());
        InventoryUtils.fillItems(invConfirmSendGift);
        player.openInventory(invConfirmSendGift);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInvClickSendGiftMenu(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().equals(GadgetsMenu.getGadgetsMenuData().getConfirmSendGiftGUIName())) {
            if (event.getClickedInventory() == null || event.getClickedInventory().getSize() != 45 || event.getClickedInventory().getType() != InventoryType.CHEST) {
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                event.setCancelled(true);
                player.updateInventory();
                return;
            }
            if (!GadgetsMenu.getGadgetsMenuData().isMysteryBoxesEnabled() || !WorldUtils.isWorldEnabled(player, true)) {
                SoundEffect.ENTITY_ENDERMAN_TELEPORT.playSound(player, 1.0f, 0.5f);
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.CONFIRM_SEND_GIFT.getItemStack(), EnumItem.CONFIRM_SEND_GIFT.getSlot())) {
                Player selectedPlayer = GadgetsMenu.getPlayerManager(player).getSelectedSendGiftPlayer();
                if (selectedPlayer == null) {
                    player.sendMessage(MessageType.ERROR.getFormatMessage());
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                if (!selectedPlayer.isOnline()) {
                    player.sendMessage(MessageType.PLAYER_IS_OFFLINE.getFormatMessage());
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
                for (int i = 1; i <= 5; ++i) {
                    int random = GadgetsMenu.random().nextInt(5);
                    MysteryBoxType box = MysteryBoxType.valueOfByName("Gifted Mystery Box #" + ++random);
                    if (box == null) {
                        player.sendMessage(MessageType.ERROR.getFormatMessage());
                        player.closeInventory();
                        event.setCancelled(true);
                        return;
                    }
                    GadgetsMenu.getPlayerManager(selectedPlayer).giveMysteryBoxes(box, null, false, player.getName(), 1);
                }
                GadgetsMenu.getPlayerManager(player).removeGiftPacks(1);
                GadgetsMenu.getPlayerManager(selectedPlayer).addGiftReceived(1);
                GadgetsMenu.getPlayerManager(player).addGiftSent(1);
                PlayerSendMysteryGiftEvent sendGiftEvent = new PlayerSendMysteryGiftEvent(player, selectedPlayer);
                Bukkit.getServer().getPluginManager().callEvent((Event)sendGiftEvent);
                player.sendMessage(MessageType.SEND_A_GIFT_TO_PLAYER.getFormatMessage().replace("{PLAYER}", selectedPlayer.getName()));
                selectedPlayer.sendMessage(MessageType.RECEIVED_GIFT.getFormatMessage().replace("{PLAYER}", player.getName()));
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.CANCEL_SEND_GIFT.getItemStack(), EnumItem.CANCEL_SEND_GIFT.getSlot())) {
                GadgetsMenu.getPlayerManager(player).setSelectedSendGiftPlayer(null);
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            event.setCancelled(true);
            return;
        }
    }
}

