/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus.mysteryvault;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.GInventory;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.AnimationType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class MysteryVaultAnimationsMenu
implements Listener {
    public static void openMysteryVaultAnimationsMenu(Player player) {
        int size = AnimationType.enabled().size();
        Inventory invMysteryVaultAnimations = Bukkit.createInventory(null, (int)54, (String)GadgetsMenu.getGadgetsMenuData().getMysteryVaultAnimationsGUIName());
        int i = 0;
        int from = 1;
        int to = 21;
        if (size < 21) {
            to = size;
        }
        for (int h = from; h <= to; ++h) {
            try {
                if (h > size) break;
                AnimationType animation = AnimationType.enabled().get(h - 1);
                if (PermissionUtils.noPermission(player, animation.getPermission(), EnumPermission.ALL_MYSTERY_VAULT_ANIMATIONS.getPermission(), false)) {
                    if (EnumItem.NO_PERMISSION.showCustomItem()) {
                        InventoryUtils.inventory(invMysteryVaultAnimations, animation.getDisplayName(), EnumItem.NO_PERMISSION.getCustomItem(), animation.getLore(), EnumItem.NO_PERMISSION.isShowInLore() ? EnumItem.NO_PERMISSION.getLore() : null, GInventory.LAY_OUT_21.getLayOut()[i++]);
                        continue;
                    }
                    InventoryUtils.inventory(invMysteryVaultAnimations, animation.getDisplayName(), animation.getMaterial(), animation.getLore(), EnumItem.NO_PERMISSION.isShowInLore() ? EnumItem.NO_PERMISSION.getLore() : null, GInventory.LAY_OUT_21.getLayOut()[i++]);
                    continue;
                }
                AnimationType selectedAnimation = GadgetsMenu.getPlayerManager(player).getMysteryVaultAnimation();
                InventoryUtils.inventoryAddGlow(invMysteryVaultAnimations, animation.getDisplayName(), animation.getMaterial(), animation.getLore(), null, GInventory.LAY_OUT_21.getLayOut()[i++], selectedAnimation == null ? null : selectedAnimation.getDisplayName());
                continue;
            }
            catch (Exception e) {
                player.sendMessage(MessageType.ERROR.getFormatMessage());
                e.printStackTrace();
                return;
            }
        }
        if (EnumItem.GO_BACK.show()) {
            InventoryUtils.inventory(invMysteryVaultAnimations, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot());
        }
        if (EnumItem.RANDOM_MYSTERY_VAULT_ANIMATION_ITEM.show()) {
            InventoryUtils.inventory(invMysteryVaultAnimations, EnumItem.RANDOM_MYSTERY_VAULT_ANIMATION_ITEM.getItemStack(), "{STATUS}", GadgetsMenu.getPlayerManager(player).isRandomMysteryVaultAnimationSelected() ? MessageType.ENABLED.getFormatMessage() : MessageType.DISABLED.getFormatMessage(), EnumItem.RANDOM_MYSTERY_VAULT_ANIMATION_ITEM.getSlot());
        }
        InventoryUtils.fillItems(invMysteryVaultAnimations);
        player.openInventory(invMysteryVaultAnimations);
    }

    @EventHandler
    public void onInvClickMysteryVaultAnimationsMenu(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().equals(GadgetsMenu.getGadgetsMenuData().getMysteryVaultAnimationsGUIName())) {
            if (event.getClickedInventory() == null || event.getClickedInventory().getSize() != 54 || event.getClickedInventory().getType() != InventoryType.CHEST) {
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                event.setCancelled(true);
                player.updateInventory();
                return;
            }
            if (!GadgetsMenu.getGadgetsMenuData().isMysteryBoxesEnabled() || !WorldUtils.isWorldEnabled(player, true)) {
                SoundEffect.ENTITY_ENDERMAN_TELEPORT.playSound(player, 1.0f, 0.5f);
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot())) {
                GadgetsMenu.getPlayerManager(player).openMysteryVaultMenu(1);
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.RANDOM_MYSTERY_VAULT_ANIMATION_ITEM.getDisplayName(), EnumItem.RANDOM_MYSTERY_VAULT_ANIMATION_ITEM.getSlot())) {
                if (PermissionUtils.noPermission(player, EnumPermission.RANDOM_MYSTERY_VAULT_ANIMATIONS.getPermission(), EnumPermission.ALL_MYSTERY_VAULT_ANIMATIONS.getPermission(), true)) {
                    if (EnumItem.NO_PERMISSION.isPlaySoundEnabled()) {
                        EnumItem.NO_PERMISSION.getSound().playSound(player, 1.0f, 0.5f);
                    }
                    if (EnumItem.NO_PERMISSION.isCloseGUIMenuAfterSelect()) {
                        player.closeInventory();
                    }
                    event.setCancelled(true);
                    return;
                }
                PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
                if (pManager.isRandomMysteryVaultAnimationSelected()) {
                    pManager.setMysteryVaultAnimation(AnimationType.NORMAL);
                    player.sendMessage(MessageType.DISABLED_RANDOM_MYSTERY_VAULT_ANIMATION.getFormatMessage());
                } else {
                    pManager.setMysteryVaultAnimation(AnimationType.RANDOM);
                    player.sendMessage(MessageType.ENABLED_RANDOM_MYSTERY_VAULT_ANIMATION.getFormatMessage());
                }
                MysteryVaultAnimationsMenu.openMysteryVaultAnimationsMenu(player);
                event.setCancelled(true);
                return;
            }
            for (AnimationType animation : AnimationType.values()) {
                try {
                    if (!event.getCurrentItem().getItemMeta().getDisplayName().equals(ChatUtil.format(animation.getDisplayName()))) continue;
                    if (PermissionUtils.noPermission(player, animation.getPermission(), EnumPermission.ALL_MYSTERY_VAULT_ANIMATIONS.getPermission(), true)) {
                        if (EnumItem.NO_PERMISSION.isPlaySoundEnabled()) {
                            EnumItem.NO_PERMISSION.getSound().playSound(player, 1.0f, 0.5f);
                        }
                        if (EnumItem.NO_PERMISSION.isCloseGUIMenuAfterSelect()) {
                            player.closeInventory();
                        }
                        event.setCancelled(true);
                        return;
                    }
                    player.sendMessage(MessageType.SELECT_MYSTERY_VAULT_ANIMATION.getFormatMessage().replace("{ANIMATION}", animation.getDisplayNameStripColor()));
                    GadgetsMenu.getPlayerManager(player).setMysteryVaultAnimation(animation);
                    if (EnumItem.HAS_PERMISSION.isPlaySoundEnabled()) {
                        EnumItem.HAS_PERMISSION.getSound().playSound(player, 1.0f, 2.0f);
                    }
                    if (EnumItem.HAS_PERMISSION.isCloseGUIMenuAfterSelect()) {
                        player.closeInventory();
                    } else {
                        MysteryVaultAnimationsMenu.openMysteryVaultAnimationsMenu(player);
                    }
                    event.setCancelled(true);
                    return;
                }
                catch (Exception Ex) {
                    player.sendMessage(MessageType.ERROR.getFormatMessage());
                    Ex.printStackTrace();
                }
            }
            event.setCancelled(true);
            return;
        }
    }
}

