/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.metrics;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.economy.GStorage;
import com.yapzhenyie.GadgetsMenu.metrics.Metrics;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MetricsStarter {
    private Metrics metrics;

    public MetricsStarter(JavaPlugin plugin) {
        this.metrics = new Metrics((Plugin)plugin);
    }

    public void start() {
        this.metrics.addCustomChart(new Metrics.AdvancedPie("enabled_cosmetics", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                if (Category.HATS.isEnabled()) {
                    valueMap.put("Hats", 1);
                }
                if (Category.ANIMATED_HATS.isEnabled()) {
                    valueMap.put("Animated Hats", 1);
                }
                if (Category.PARTICLES.isEnabled()) {
                    valueMap.put("Particles", 1);
                }
                if (Category.SUITS.isEnabled()) {
                    valueMap.put("Suits", 1);
                }
                if (Category.GADGETS.isEnabled()) {
                    valueMap.put("Gadgets", 1);
                }
                if (Category.PETS.isEnabled()) {
                    valueMap.put("Pets", 1);
                }
                if (Category.MORPHS.isEnabled() && (GadgetsMenu.getGadgetsMenuData().isLibsDisguiseEnabled() || GadgetsMenu.getGadgetsMenuData().isIDisguiseEnabled())) {
                    valueMap.put("Morphs", 1);
                }
                if (Category.BANNERS.isEnabled()) {
                    valueMap.put("Banners", 1);
                }
                if (Category.EMOTES.isEnabled()) {
                    valueMap.put("Emotes", 1);
                }
                if (Category.CLOAKS.isEnabled()) {
                    valueMap.put("Cloaks", 1);
                }
                return valueMap;
            }
        }));
        this.metrics.addCustomChart(new Metrics.AdvancedPie("storages", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                GStorage gStorage = GadgetsMenu.getGadgetsMenuData().getMysteryDustStorage();
                if (gStorage != null) {
                    valueMap.put(gStorage.getName(), 1);
                }
                return valueMap;
            }
        }));
        this.metrics.addCustomChart(new Metrics.AdvancedPie("plugin_series", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                String version = GadgetsMenu.getInstance().getDescription().getVersion();
                if (version.startsWith("4")) {
                    valueMap.put("v4", 1);
                } else {
                    valueMap.put("Unknown", 1);
                }
                return valueMap;
            }
        }));
        this.metrics.addCustomChart(new Metrics.AdvancedPie("update_checking", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                if (GadgetsMenu.getGadgetsMenuData().isAutoUpdateEnabled() && GadgetsMenu.getGadgetsMenuData().isCheckUpdateEnabled()) {
                    valueMap.put("Check and Download", 1);
                    return valueMap;
                }
                if (GadgetsMenu.getGadgetsMenuData().isAutoUpdateEnabled()) {
                    valueMap.put("Auto Download", 1);
                    return valueMap;
                }
                if (GadgetsMenu.getGadgetsMenuData().isCheckUpdateEnabled()) {
                    valueMap.put("Check Update", 1);
                    return valueMap;
                }
                valueMap.put("Disabled", 1);
                return valueMap;
            }
        }));
        this.metrics.addCustomChart(new Metrics.AdvancedPie("disabled_gadgets", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                if (Category.GADGETS.isEnabled()) {
                    for (GadgetType gadget : GadgetType.values()) {
                        if (gadget.isEnabled()) continue;
                        valueMap.put(gadget.getName(), 1);
                    }
                    if (GadgetType.values().size() == GadgetType.enabled().size()) {
                        valueMap.put("All Gadgets Enabled", 1);
                    }
                } else {
                    valueMap.put("Gadgets Disabled", 1);
                }
                return valueMap;
            }
        }));
    }
}

