/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.mysteryboxes;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.mysteryboxes.MysteryBoxesLoot;
import com.yapzhenyie.GadgetsMenu.mysteryboxes.MysteryBoxesMessages;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.MysteryBoxType;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.ExpiryDateCounter;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Quality;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Rarity;
import java.util.ArrayList;
import java.util.List;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class MysteryBoxes {
    private MysteryBoxType mysteryBoxType;
    private Quality quality;
    private boolean expirable;
    private Long expiryDate;
    private boolean requirePerm;
    private String details;
    private String decodedLoots;
    private String encodedString;
    private String decodedString;
    private ArrayList<MysteryBoxesLoot> loots = new ArrayList();
    private ArrayList<MysteryBoxesLoot> commonLoots = new ArrayList();
    private ArrayList<MysteryBoxesLoot> rareLoots = new ArrayList();
    private ArrayList<MysteryBoxesLoot> epicLoots = new ArrayList();
    private ArrayList<MysteryBoxesLoot> legendaryLoots = new ArrayList();

    public MysteryBoxes(String encodedData) {
        this.encodedString = encodedData;
        this.decodedString = Base64Coder.decodeString((String)encodedData);
        this.mysteryBoxType = MysteryBoxType.valueOfByName(this.decodedString.split("\\ %% ")[0]);
        this.quality = this.mysteryBoxType.getQuality();
        this.expiryDate = this.decodedString.split("\\ %% ")[1].equals("null") ? null : Long.valueOf(this.decodedString.split("\\ %% ")[1]);
        this.expirable = this.expiryDate != null;
        this.requirePerm = Boolean.valueOf(this.decodedString.split("\\ %% ")[2]);
        this.details = this.decodedString.split("\\ %% ")[3].equals("null") ? null : this.decodedString.split("\\ %% ")[3];
        this.decodedLoots = this.expiryDate == null ? this.decodedString.replace(this.mysteryBoxType.getName() + " %% " + null + " %% " + Boolean.valueOf(this.requirePerm).toString() + " %% " + this.details + " %% ", "") : this.decodedString.replace(this.mysteryBoxType.getName() + " %% " + this.expiryDate.toString() + " %% " + Boolean.valueOf(this.requirePerm).toString() + " %% " + this.details + " %% ", "");
        for (int i = 0; i < 7; ++i) {
            int[] rarity = new int[]{0, 3, 6, 9, 12, 15, 18};
            int[] type = new int[]{1, 4, 7, 10, 13, 16, 19};
            int[] name = new int[]{2, 5, 8, 11, 14, 17, 20};
            this.loots.add(new MysteryBoxesLoot(Rarity.getName(this.decodedLoots.split("\\ %% ")[rarity[i]]), Category.valueOfByName(this.decodedLoots.split("\\ %% ")[type[i]]), this.decodedLoots.split("\\ %% ")[name[i]].toString()));
        }
        for (MysteryBoxesLoot loot : this.loots) {
            if (loot.getRarity() == Rarity.COMMON) {
                if (this.commonLoots.contains(loot)) continue;
                this.commonLoots.add(loot);
                continue;
            }
            if (loot.getRarity() == Rarity.RARE) {
                if (this.rareLoots.contains(loot)) continue;
                this.rareLoots.add(loot);
                continue;
            }
            if (loot.getRarity() == Rarity.EPIC) {
                if (this.epicLoots.contains(loot)) continue;
                this.epicLoots.add(loot);
                continue;
            }
            if (loot.getRarity() != Rarity.LEGENDARY || this.legendaryLoots.contains(loot)) continue;
            this.legendaryLoots.add(loot);
        }
    }

    public MysteryBoxes(MysteryBoxType mysteryBoxType, boolean expirable, Long expiryDate, boolean requirePerms, String details, String decodedLoots) {
        this.mysteryBoxType = mysteryBoxType;
        this.quality = this.mysteryBoxType.getQuality();
        this.expirable = expirable;
        this.expiryDate = expiryDate;
        this.requirePerm = requirePerms;
        this.details = details;
        this.decodedLoots = decodedLoots;
        this.decodedString = this.mysteryBoxType.getName() + " %% " + this.getExpiryDate() + " %% " + this.requirePerm + " %% " + this.details + " %% " + this.decodedLoots;
        this.encodedString = Base64Coder.encodeString((String)(this.mysteryBoxType.getName() + " %% " + this.getExpiryDate() + " %% " + this.requirePerm + " %% " + this.details + " %% " + this.decodedLoots));
        for (int i = 0; i < 7; ++i) {
            int[] rarity = new int[]{0, 3, 6, 9, 12, 15, 18};
            int[] type = new int[]{1, 4, 7, 10, 13, 16, 19};
            int[] name = new int[]{2, 5, 8, 11, 14, 17, 20};
            this.loots.add(new MysteryBoxesLoot(Rarity.getName(this.decodedLoots.split("\\ %% ")[rarity[i]]), Category.valueOfByName(this.decodedLoots.split("\\ %% ")[type[i]]), this.decodedLoots.split("\\ %% ")[name[i]].toString()));
        }
        for (MysteryBoxesLoot loot : this.loots) {
            if (loot.getRarity() == Rarity.COMMON) {
                if (this.commonLoots.contains(loot)) continue;
                this.commonLoots.add(loot);
                continue;
            }
            if (loot.getRarity() == Rarity.RARE) {
                if (this.rareLoots.contains(loot)) continue;
                this.rareLoots.add(loot);
                continue;
            }
            if (loot.getRarity() == Rarity.EPIC) {
                if (this.epicLoots.contains(loot)) continue;
                this.epicLoots.add(loot);
                continue;
            }
            if (loot.getRarity() != Rarity.LEGENDARY || this.legendaryLoots.contains(loot)) continue;
            this.legendaryLoots.add(loot);
        }
    }

    public MysteryBoxType getMysteryBoxType() {
        return this.mysteryBoxType;
    }

    public Quality getQuality() {
        return this.quality;
    }

    public Long getExpiryDate() {
        return this.expiryDate;
    }

    public String getExpiryDateDistance() {
        return this.expiryDate == null ? null : new ExpiryDateCounter((this.expiryDate - System.currentTimeMillis()) / 1000L).getFormat();
    }

    public boolean isExpired() {
        return this.expiryDate - System.currentTimeMillis() < 1L;
    }

    public boolean isExpirable() {
        return this.expirable;
    }

    public boolean isRequiredPermission() {
        return this.requirePerm;
    }

    public String getDetails() {
        return this.details;
    }

    public String getDecodedLoots() {
        return this.decodedLoots;
    }

    public ArrayList<MysteryBoxesLoot> getLoots() {
        return this.loots;
    }

    public ArrayList<MysteryBoxesLoot> getCommonLoots() {
        return this.commonLoots;
    }

    public ArrayList<MysteryBoxesLoot> getRareLoots() {
        return this.rareLoots;
    }

    public ArrayList<MysteryBoxesLoot> getEpicLoots() {
        return this.epicLoots;
    }

    public ArrayList<MysteryBoxesLoot> getLegendaryLoots() {
        return this.legendaryLoots;
    }

    public List<String> getLore() {
        ArrayList<String> itemLore;
        block7: {
            block8: {
                block6: {
                    itemLore = new ArrayList<String>();
                    if (!this.mysteryBoxType.isNormalMysteryBox()) break block6;
                    for (String lore : this.mysteryBoxType.getLore()) {
                        if (InventoryUtils.PLACEHOLDER_PATTERN.matcher(lore).find()) {
                            itemLore.add(ChatUtil.format(lore.replace("{ITEM_ONE}", this.getDisplayName(this, 1)).replace("{ITEM_TWO}", this.getDisplayName(this, 2)).replace("{ITEM_THREE}", this.getDisplayName(this, 3)).replace("{ITEM_FOUR}", this.getDisplayName(this, 4)).replace("{ITEM_FIVE}", this.getDisplayName(this, 5)).replace("{ITEM_SIX}", this.getDisplayName(this, 6)).replace("{ITEM_SEVEN}", this.getDisplayName(this, 7)).replace("{EXPIRY_DATE}", this.isExpirable() ? MysteryBoxesMessages.expiryDateFormat.replace("{EXPIRY_DATE}", this.getExpiryDateDistance()) : MysteryBoxesMessages.neverExpiryFormat)));
                            continue;
                        }
                        itemLore.add(ChatUtil.format(lore));
                    }
                    break block7;
                }
                if (!this.mysteryBoxType.isGiftedMysteryBox()) break block8;
                for (String lore : this.mysteryBoxType.getLore()) {
                    if (InventoryUtils.PLACEHOLDER_PATTERN.matcher(lore).find()) {
                        itemLore.add(ChatUtil.format(lore.replace("{ITEM_ONE}", this.getDisplayName(this, 1)).replace("{ITEM_TWO}", this.getDisplayName(this, 2)).replace("{ITEM_THREE}", this.getDisplayName(this, 3)).replace("{ITEM_FOUR}", this.getDisplayName(this, 4)).replace("{ITEM_FIVE}", this.getDisplayName(this, 5)).replace("{ITEM_SIX}", this.getDisplayName(this, 6)).replace("{ITEM_SEVEN}", this.getDisplayName(this, 7)).replace("{SENDER}", this.getDetails())));
                        continue;
                    }
                    itemLore.add(ChatUtil.format(lore));
                }
                break block7;
            }
            if (!this.mysteryBoxType.isCraftedMysteryBox()) break block7;
            for (String lore : this.mysteryBoxType.getLore()) {
                if (InventoryUtils.PLACEHOLDER_PATTERN.matcher(lore).find()) {
                    itemLore.add(ChatUtil.format(lore.replace("{ITEM_ONE}", this.getDisplayName(this, 1)).replace("{ITEM_TWO}", this.getDisplayName(this, 2)).replace("{ITEM_THREE}", this.getDisplayName(this, 3)).replace("{ITEM_FOUR}", this.getDisplayName(this, 4)).replace("{ITEM_FIVE}", this.getDisplayName(this, 5)).replace("{ITEM_SIX}", this.getDisplayName(this, 6)).replace("{ITEM_SEVEN}", this.getDisplayName(this, 7)).replace("{DATE}", this.getDetails())));
                    continue;
                }
                itemLore.add(ChatUtil.format(lore));
            }
        }
        return itemLore;
    }

    private String getDisplayName(MysteryBoxes mysteryBox, int numItem) {
        return mysteryBox.getLoots().get(numItem - 1).getDisplayNameStripColor();
    }

    public MysteryBoxesLoot open() {
        Rarity rarity = this.giveLoots();
        if (this.getCommonLoots().size() == 0) {
            rarity = this.giveLoots2();
        }
        if (rarity == Rarity.COMMON) {
            if (this.getCommonLoots().size() == 0) {
                return this.getLoots().get(GadgetsMenu.random().nextInt(this.getLoots().size()));
            }
            return this.getCommonLoots().get(GadgetsMenu.random().nextInt(this.getCommonLoots().size()));
        }
        if (rarity == Rarity.RARE) {
            if (this.getRareLoots().size() == 0) {
                return this.getLoots().get(GadgetsMenu.random().nextInt(this.getLoots().size()));
            }
            return this.getRareLoots().get(GadgetsMenu.random().nextInt(this.getRareLoots().size()));
        }
        if (rarity == Rarity.EPIC) {
            if (this.getEpicLoots().size() == 0) {
                return this.getLoots().get(GadgetsMenu.random().nextInt(this.getLoots().size()));
            }
            return this.getEpicLoots().get(GadgetsMenu.random().nextInt(this.getEpicLoots().size()));
        }
        if (rarity == Rarity.LEGENDARY) {
            if (this.getLegendaryLoots().size() == 0) {
                return this.getLoots().get(GadgetsMenu.random().nextInt(this.getLoots().size()));
            }
            return this.getLegendaryLoots().get(GadgetsMenu.random().nextInt(this.getLegendaryLoots().size()));
        }
        return this.getLoots().get(GadgetsMenu.random().nextInt(this.getLoots().size()));
    }

    private Rarity giveLoots() {
        int commonChance = Rarity.COMMON.getChance(this.quality);
        int rareChance = Rarity.RARE.getChance(this.quality);
        int epicChance = Rarity.EPIC.getChance(this.quality);
        int legendaryChance = Rarity.LEGENDARY.getChance(this.quality);
        int random = GadgetsMenu.random().nextInt(commonChance + rareChance + epicChance + legendaryChance);
        if (random < commonChance) {
            return Rarity.COMMON;
        }
        if (random >= commonChance && random < commonChance + rareChance) {
            return Rarity.RARE;
        }
        if (random >= commonChance + rareChance && random < commonChance + rareChance + epicChance) {
            return Rarity.EPIC;
        }
        if (random >= commonChance + rareChance + epicChance && random <= commonChance + rareChance + epicChance + legendaryChance) {
            return Rarity.LEGENDARY;
        }
        return null;
    }

    private Rarity giveLoots2() {
        int rareChance = Rarity.RARE.getChance(this.quality);
        int epicChance = Rarity.EPIC.getChance(this.quality);
        int legendaryChance = Rarity.LEGENDARY.getChance(this.quality);
        int random = GadgetsMenu.random().nextInt(rareChance + epicChance + legendaryChance);
        if (random < rareChance) {
            return Rarity.RARE;
        }
        if (random >= rareChance && random < rareChance + epicChance) {
            return Rarity.EPIC;
        }
        if (random >= rareChance + epicChance && random <= rareChance + epicChance + legendaryChance) {
            return Rarity.LEGENDARY;
        }
        return null;
    }

    public String toString() {
        return this.decodedString;
    }

    public String toEncodedString() {
        return this.encodedString;
    }
}

