/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.nms;

import com.google.gson.stream.JsonWriter;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.IJSONMessage;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;

public class JSONMessage
implements IJSONMessage {
    private List<MessagePart> messageParts = new ArrayList<MessagePart>();

    public JSONMessage(String firstPartText) {
        this.messageParts.add(new MessagePart(firstPartText));
    }

    @Override
    public JSONMessage openFile(String path) {
        this.onClick("open_file", path);
        return this;
    }

    @Override
    public JSONMessage openLink(String url) {
        this.onClick("open_url", url);
        return this;
    }

    @Override
    public JSONMessage suggestCommand(String command) {
        this.onClick("suggest_command", command);
        return this;
    }

    @Override
    public JSONMessage runCommand(String command) {
        this.onClick("run_command", command);
        return this;
    }

    @Override
    public JSONMessage showText(String text) {
        this.onHover("show_text", text);
        return this;
    }

    @Override
    public JSONMessage showText(List<String> text) {
        this.onHover("show_text", String.join((CharSequence)"\n", text));
        return this;
    }

    @Override
    public JSONMessage then(Object obj) {
        this.messageParts.add(new MessagePart(obj.toString()));
        return this;
    }

    @Override
    public String toJSONString() {
        StringWriter stringWriter = new StringWriter();
        JsonWriter json = new JsonWriter((Writer)stringWriter);
        try {
            if (this.messageParts.size() == 1) {
                this.latest().writeJson(json);
            } else {
                json.beginObject().name("text").value("").name("extra").beginArray();
                for (MessagePart part : this.messageParts) {
                    part.writeJson(json);
                }
                json.endArray().endObject();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Invalid message");
        }
        return stringWriter.toString();
    }

    @Override
    public void send(Player player) {
        Object packet = null;
        try {
            packet = VersionManager.is1_16OrAbove() ? ReflectionUtils.getConstructor(ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("PacketPlayOutChat", "network.protocol.game"), ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("IChatBaseComponent", "network.chat"), ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("ChatMessageType", "network.chat"), UUID.class).newInstance(ReflectionUtils.invokeMethod(null, ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("IChatBaseComponent$ChatSerializer", "network.chat"), "a", this.toJSONString()), ReflectionUtils.invokeMethod(null, ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("ChatMessageType", "network.chat"), "valueOf", "CHAT"), UUID.randomUUID()) : ReflectionUtils.getConstructor(ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("PacketPlayOutChat", new String[0]), ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("IChatBaseComponent", new String[0])).newInstance(ReflectionUtils.invokeMethod(null, ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("IChatBaseComponent$ChatSerializer", new String[0]), "a", this.toJSONString()));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        ReflectionUtils.sendPacket(player, packet);
    }

    private void onClick(String name, String data) {
        MessagePart latest = this.latest();
        latest.clickActionName = name;
        latest.clickActionData = data;
    }

    private void onHover(String name, String data) {
        MessagePart latest = this.latest();
        latest.hoverActionName = name;
        latest.hoverActionData = data;
    }

    private MessagePart latest() {
        return this.messageParts.get(this.messageParts.size() - 1);
    }

    private static class MessagePart {
        public String clickActionName = null;
        public String clickActionData = null;
        public String hoverActionName = null;
        public String hoverActionData = null;
        public final String text;

        public MessagePart(String text) {
            this.text = text;
        }

        public JsonWriter writeJson(JsonWriter json) throws IOException {
            json.beginObject().name("text").value(this.text);
            if (this.clickActionName != null && this.clickActionData != null) {
                json.name("clickEvent").beginObject().name("action").value(this.clickActionName).name("value").value(this.clickActionData).endObject();
            }
            if (this.hoverActionName != null && this.hoverActionData != null) {
                json.name("hoverEvent").beginObject().name("action").value(this.hoverActionName).name("value").value(this.hoverActionData).endObject();
            }
            return json.endObject();
        }
    }
}

