/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.nms;

import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class Potion {
    public PotionType type;
    private boolean strong;
    private boolean extended;
    private boolean linger;
    private boolean splash;

    public Potion(PotionType potionType) {
        this(potionType, false, false, false, false);
    }

    public Potion(PotionType type, boolean strong) {
        this(type);
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        if (type != PotionType.WATER) {
            throw new IllegalArgumentException("Water bottles cannot be strong!");
        }
        this.strong = strong;
    }

    public Potion(PotionType type, boolean strong, boolean extended, boolean linger, boolean splash) {
        this.type = type;
        this.strong = strong;
        this.extended = extended;
        this.linger = linger;
        this.splash = splash;
    }

    public Potion splash() {
        this.setSplash(true);
        return this;
    }

    public Potion extend() {
        this.setHasExtendedDuration(true);
        return this;
    }

    public Potion linger() {
        this.setLinger(true);
        return this;
    }

    public Potion strong() {
        this.setStrong(true);
        return this;
    }

    public PotionType getType() {
        return this.type;
    }

    public void setType(PotionType type) {
        this.type = type;
    }

    public boolean isStrong() {
        return this.strong;
    }

    public void setStrong(boolean strong) {
        this.strong = strong;
    }

    public boolean isExtendedDuration() {
        return this.extended;
    }

    public void setHasExtendedDuration(boolean extended) {
        this.extended = extended;
    }

    public boolean isLinger() {
        return this.linger;
    }

    public void setLinger(boolean linger) {
        this.linger = linger;
    }

    public boolean isSplash() {
        return this.splash;
    }

    public void setSplash(boolean splash) {
        this.splash = splash;
    }

    public ItemStack toItemStack(ItemStack itemStack) {
        ItemStack item = new ItemStack(itemStack);
        item.getItemMeta().addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        try {
            Object craftItemStack = ReflectionUtils.invokeMethod(null, ReflectionUtils.PackageType.CRAFTBUKKIT_INVENTORY.getClass("CraftItemStack", new String[0]), "asNMSCopy", item);
            Object tag = VersionManager.is1_18OrAbove() ? ReflectionUtils.invokeMethod(craftItemStack, craftItemStack.getClass(), "s", new Object[0]) : ReflectionUtils.invokeMethod(craftItemStack, craftItemStack.getClass(), "getTag", new Object[0]);
            if (tag == null) {
                tag = ReflectionUtils.getConstructor(ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("NBTTagCompound", "nbt"), new Class[0]).newInstance(new Object[0]);
            }
            String value = "";
            if (this.type.equals((Object)PotionType.FIRE_RESISTANCE)) {
                value = this.extended ? "long_fire_resistance" : "fire_resistance";
            } else if (this.type.equals((Object)PotionType.INSTANT_DAMAGE)) {
                value = this.strong ? "strong_harming" : "harming";
            } else if (this.type.equals((Object)PotionType.INSTANT_HEAL)) {
                value = this.strong ? "strong_healing" : "healing";
            } else if (this.type.equals((Object)PotionType.INVISIBILITY)) {
                value = this.extended ? "long_invisibility" : "invisibility";
            } else if (this.type.equals((Object)PotionType.JUMP)) {
                value = this.extended ? "long_leaping" : (this.strong ? "strong_leaping" : "leaping");
            } else if (this.type.equals((Object)PotionType.LUCK)) {
                value = "luck";
            } else if (this.type.equals((Object)PotionType.NIGHT_VISION)) {
                value = this.extended ? "long_night_vision" : "night_vision";
            } else if (this.type.equals((Object)PotionType.POISON)) {
                value = this.extended ? "long_poison" : (this.strong ? "strong_poison" : "poison");
            } else if (this.type.equals((Object)PotionType.REGEN)) {
                value = this.extended ? "long_regeneration" : (this.strong ? "strong_regeneration" : "regeneration");
            } else if (this.type.equals((Object)PotionType.SLOWNESS)) {
                value = this.extended ? "long_slowness" : "slowness";
            } else if (this.type.equals((Object)PotionType.SPEED)) {
                value = this.extended ? "long_swiftness" : (this.strong ? "strong_swiftness" : "swiftness");
            } else if (this.type.equals((Object)PotionType.STRENGTH)) {
                value = this.extended ? "long_strength" : (this.strong ? "strong_strength" : "strength");
            } else if (this.type.equals((Object)PotionType.WATER_BREATHING)) {
                value = this.extended ? "long_water_breathing" : "water_breathing";
            } else if (this.type.equals((Object)PotionType.WATER)) {
                value = "water";
            } else if (this.type.equals((Object)PotionType.WEAKNESS)) {
                value = this.extended ? "long_weakness" : "weakness";
            } else if (this.type.equals((Object)PotionType.EMPTY)) {
                value = "empty";
            } else if (this.type.equals((Object)PotionType.MUNDANE)) {
                value = "mundane";
            } else if (this.type.equals((Object)PotionType.THICK)) {
                value = "thick";
            } else if (this.type.equals((Object)PotionType.AWKWARD)) {
                value = "awkward";
            } else {
                return null;
            }
            if (VersionManager.is1_18OrAbove()) {
                ReflectionUtils.invokeMethod(tag, "a", "Potion", "minecraft:" + value);
                ReflectionUtils.invokeMethod(craftItemStack, "c", tag);
            } else {
                ReflectionUtils.invokeMethod(tag, "setString", "Potion", "minecraft:" + value);
                ReflectionUtils.invokeMethod(craftItemStack, "setTag", tag);
            }
            return (ItemStack)ReflectionUtils.invokeMethod(null, ReflectionUtils.PackageType.CRAFTBUKKIT_INVENTORY.getClass("CraftItemStack", new String[0]), "asBukkitCopy", craftItemStack);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return item;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Potion) {
            Potion potionObj = (Potion)object;
            if (potionObj.type.equals((Object)this.type) && potionObj.extended == this.extended && potionObj.linger == this.linger && potionObj.splash == this.splash) {
                return true;
            }
        }
        return false;
    }

    public static enum PotionType {
        FIRE_RESISTANCE,
        INSTANT_DAMAGE,
        INSTANT_HEAL,
        INVISIBILITY,
        JUMP,
        LUCK,
        NIGHT_VISION,
        POISON,
        REGEN,
        SLOWNESS,
        SPEED,
        STRENGTH,
        WATER,
        WATER_BREATHING,
        WEAKNESS,
        EMPTY,
        MUNDANE,
        THICK,
        AWKWARD;

    }
}

