/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.nms.v1_12_R1;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.holograms.CraftHologram;
import com.yapzhenyie.GadgetsMenu.log.LoggerManager;
import com.yapzhenyie.GadgetsMenu.nms.NMSManager;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.ArmorStandSlot;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.PetUtils;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.entity.NMSArmorStand;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.entity.NMSEntityBase;
import com.yapzhenyie.GadgetsMenu.nms.v1_12_R1.armorstand.ArmorStandFollower;
import com.yapzhenyie.GadgetsMenu.nms.v1_12_R1.armorstand.EntityNMSArmorStand;
import com.yapzhenyie.GadgetsMenu.nms.v1_12_R1.pathfinders.PathFinderGoalPanic;
import com.yapzhenyie.GadgetsMenu.nms.v1_12_R1.pets.Pathfinder;
import com.yapzhenyie.GadgetsMenu.nms.v1_12_R1.pets.PetUtilsImpl;
import com.yapzhenyie.GadgetsMenu.nms.v1_12_R1.pets.PlayerFollower;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import net.minecraft.server.v1_12_R1.EntityCreature;
import net.minecraft.server.v1_12_R1.EntityInsentient;
import net.minecraft.server.v1_12_R1.EnumItemSlot;
import net.minecraft.server.v1_12_R1.MathHelper;
import net.minecraft.server.v1_12_R1.PathfinderGoal;
import net.minecraft.server.v1_12_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class NMSManagerImpl
implements NMSManager {
    @Override
    public void removePathfinders(Entity entity) {
        Pathfinder.removePathfinders(entity);
    }

    @Override
    public void followPlayer(Player player, Entity entity, double speed) {
        PlayerFollower.followPlayer(player, entity, speed);
    }

    @Override
    public void makeEntityPanic(Entity entity) {
        EntityInsentient insentient = (EntityInsentient)((CraftEntity)entity).getHandle();
        insentient.goalSelector.a(3, (PathfinderGoal)new PathFinderGoalPanic((EntityCreature)insentient, 0.4));
    }

    @Override
    public PetUtils pet(Entity entity) {
        return new PetUtilsImpl(entity);
    }

    @Override
    public NMSArmorStand spawnNMSArmorStand(World world, double x, double y, double z, String displayName) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        CraftHologram craftHologram = new CraftHologram(new Location(world, x, y, z));
        EntityNMSArmorStand invisibleArmorStand = new EntityNMSArmorStand((net.minecraft.server.v1_12_R1.World)nmsWorld, craftHologram);
        invisibleArmorStand.setLocationNMS(x, y, z);
        if (displayName != null && !displayName.isEmpty()) {
            invisibleArmorStand.setCustomNameNMS(ChatUtil.format(displayName));
        }
        craftHologram.setNMSNameable(invisibleArmorStand);
        invisibleArmorStand.getBukkitEntity().setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        if (!this.addEntityToWorld(nmsWorld, (net.minecraft.server.v1_12_R1.Entity)invisibleArmorStand)) {
            LoggerManager.printLog(LoggerManager.LogLevel.WARNING, "Could not spawn mystery vault hologram!");
        }
        return invisibleArmorStand;
    }

    @Override
    public NMSArmorStand spawnNMSArmorStandFollower(World world, double x, double y, double z, Player follower, double additionY, String displayName, ArmorStandSlot itemSlot, ItemStack itemStack) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        ArmorStandFollower armorStandFollower = new ArmorStandFollower((net.minecraft.server.v1_12_R1.World)nmsWorld, follower);
        armorStandFollower.setLocationNMS(x, y, z);
        armorStandFollower.setAdditionY(additionY);
        if (itemSlot != null && itemStack != null) {
            armorStandFollower.setSlotNMS((EnumItemSlot)itemSlot.to1_9AndAboveFormat(), CraftItemStack.asNMSCopy((ItemStack)itemStack));
        }
        if (displayName != null && !displayName.isEmpty()) {
            armorStandFollower.setCustomNameNMS(ChatUtil.format(displayName));
        }
        armorStandFollower.getBukkitEntity().setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        if (!this.addEntityToWorld(nmsWorld, (net.minecraft.server.v1_12_R1.Entity)armorStandFollower)) {
            LoggerManager.printLog(LoggerManager.LogLevel.WARNING, "Could not spawn GadgetsMenu hologram!");
        }
        return armorStandFollower;
    }

    @Override
    public boolean isNMSEntityBase(Entity bukkitEntity) {
        return ((CraftEntity)bukkitEntity).getHandle() instanceof NMSEntityBase;
    }

    @Override
    public NMSEntityBase getNMSEntityBase(Entity bukkitEntity) {
        net.minecraft.server.v1_12_R1.Entity nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
        if (nmsEntity instanceof NMSEntityBase) {
            return (NMSEntityBase)nmsEntity;
        }
        return null;
    }

    public void registerEntity() {
        ArmorStandFollower.registerEntity();
    }

    private boolean addEntityToWorld(WorldServer nmsWorld, net.minecraft.server.v1_12_R1.Entity nmsEntity) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalArgumentException("Async entity add");
        }
        int chunkX = MathHelper.floor((double)(nmsEntity.locX / 16.0));
        int chunkZ = MathHelper.floor((double)(nmsEntity.locZ / 16.0));
        if (!nmsWorld.getChunkProviderServer().isLoaded(chunkX, chunkZ)) {
            nmsEntity.dead = true;
            return false;
        }
        nmsWorld.getChunkAt(chunkX, chunkZ).a(nmsEntity);
        nmsWorld.entityList.add(nmsEntity);
        try {
            ReflectionUtils.invokeMethod((Object)nmsWorld, net.minecraft.server.v1_12_R1.World.class, "b", nmsEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

