/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.player;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.updater.UpdaterManager;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class GPlayer {
    private Map<UUID, PlayerManager> playerCache = new ConcurrentHashMap<UUID, PlayerManager>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerManager getPlayerManager(Player player) {
        GPlayer gPlayer = this;
        synchronized (gPlayer) {
            try {
                PlayerManager p = this.playerCache.get(player.getUniqueId());
                if (p == null) {
                    return this.create(player);
                }
                return p;
            }
            catch (NullPointerException e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerManager create(Player player) {
        GPlayer gPlayer = this;
        synchronized (gPlayer) {
            PlayerManager customPlayer = new PlayerManager(player.getUniqueId());
            this.playerCache.put(player.getUniqueId(), customPlayer);
            return customPlayer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Player player) {
        GPlayer gPlayer = this;
        synchronized (gPlayer) {
            if (this.playerCache.containsKey(player.getUniqueId())) {
                PlayerManager pManager = this.getPlayerManager(player);
                if (pManager == null) {
                    return false;
                }
                pManager.stopAnimation();
                if (GadgetsMenu.getGadgetsMenuData().isMysteryBoxesRewardEnabled()) {
                    pManager.stopMysteryBoxReward();
                }
                pManager.savePlayerStats(true);
                this.playerCache.remove(player.getUniqueId());
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PlayerManager> getGPlayers() {
        GPlayer gPlayer = this;
        synchronized (gPlayer) {
            return this.playerCache.values();
        }
    }

    public void initPlayer(Player player) {
        if (!player.isOnline()) {
            return;
        }
        this.create(player);
        PlayerManager pManager = this.getPlayerManager(player);
        if (GadgetsMenu.getDatabaseManager().getConnection() != null) {
            GadgetsMenu.getDatabaseManager().getDatabaseUtils().initPlayerStats(pManager);
        }
        pManager.initCacheData();
        if (GadgetsMenu.getGadgetsMenuData().isGiveMenuSelectorOnJoin() && player.hasPermission(EnumPermission.MENU_SELECTOR.getPermission()) && WorldUtils.isWorldEnabled(player.getWorld())) {
            pManager.giveMenuSelector();
        }
        if (GadgetsMenu.getGadgetsMenuData().isMysteryBoxesEnabled() && GadgetsMenu.getGadgetsMenuData().isMysteryBoxesRewardEnabled()) {
            pManager.startMysteryBoxReward();
        }
        if (GadgetsMenu.getGadgetsMenuData().syncCosmeticsOnJoin()) {
            pManager.loadSelectedCosmetics();
        }
        if (GadgetsMenu.getGadgetsMenuData().isCheckUpdateEnabled() && GadgetsMenu.getUpdaterChecker() != null && GadgetsMenu.getUpdaterChecker().isOutdated() && (player.isOp() || player.hasPermission(EnumPermission.COMMAND_CHECK_UPDATE.getPermission()))) {
            if (UpdaterManager.isDownloadedUpdate()) {
                player.sendMessage(MessageType.UPDATE_DOWNLOADED.getFormatMessage());
            } else {
                player.sendMessage(GadgetsMenu.getGadgetsMenuData().getPrefix() + UpdaterManager.getMessage());
            }
        }
    }

    public void initPlayers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.isOnline()) {
                return;
            }
            PlayerManager pManager = this.getPlayerManager(player);
            if (GadgetsMenu.getDatabaseManager().getConnection() != null) {
                GadgetsMenu.getDatabaseManager().getDatabaseUtils().initPlayerStats(pManager);
            }
            pManager.initCacheData();
            if (GadgetsMenu.getGadgetsMenuData().isGiveMenuSelectorOnJoin() && player.hasPermission(EnumPermission.MENU_SELECTOR.getPermission()) && WorldUtils.isWorldEnabled(player.getWorld())) {
                pManager.giveMenuSelector();
            }
            if (GadgetsMenu.getGadgetsMenuData().isMysteryBoxesEnabled() && GadgetsMenu.getGadgetsMenuData().isMysteryBoxesRewardEnabled()) {
                pManager.startMysteryBoxReward();
            }
            if (GadgetsMenu.getGadgetsMenuData().syncCosmeticsOnJoin()) {
                pManager.loadSelectedCosmetics();
            }
            if (!GadgetsMenu.getGadgetsMenuData().isCheckUpdateEnabled() || GadgetsMenu.getUpdaterChecker() == null || !GadgetsMenu.getUpdaterChecker().isOutdated() || !player.isOp() && !player.hasPermission(EnumPermission.COMMAND_CHECK_UPDATE.getPermission())) continue;
            player.sendMessage(GadgetsMenu.getGadgetsMenuData().getPrefix() + UpdaterManager.getMessage());
        }
    }

    public void dispose() {
        Collection<PlayerManager> set = this.playerCache.values();
        for (PlayerManager pManager : set) {
            if (pManager.getPlayer() == null || !pManager.getPlayer().isOnline()) continue;
            pManager.stopAnimation();
            pManager.savePlayerStats(false);
            pManager.syncSelectedCosmetics(false);
            pManager.unequipActiveCosmetics();
            pManager.removeMenuSelector();
            if (!GadgetsMenu.getGadgetsMenuData().isMysteryBoxesRewardEnabled()) continue;
            pManager.stopMysteryBoxReward();
        }
        this.playerCache.clear();
        this.playerCache = null;
    }

    public void clearActiveCosmetics() {
        Collection<PlayerManager> set = this.playerCache.values();
        for (PlayerManager pManager : set) {
            if (pManager.getPlayer() == null || !pManager.getPlayer().isOnline()) continue;
            pManager.unequipActiveCosmetics();
        }
    }

    public void unequipHat() {
        Collection<PlayerManager> set = this.playerCache.values();
        for (PlayerManager pManager : set) {
            if (pManager.getPlayer() == null || !pManager.getPlayer().isOnline()) continue;
            pManager.unequipHat();
        }
    }

    public void unequipParticle() {
        Collection<PlayerManager> set = this.playerCache.values();
        for (PlayerManager pManager : set) {
            if (pManager.getPlayer() == null || !pManager.getPlayer().isOnline()) continue;
            pManager.unequipParticle();
        }
    }

    public void unequipSuit() {
        Collection<PlayerManager> set = this.playerCache.values();
        for (PlayerManager pManager : set) {
            if (pManager.getPlayer() == null || !pManager.getPlayer().isOnline()) continue;
            pManager.unequipSuit();
        }
    }

    public void unequipGadget() {
        Collection<PlayerManager> set = this.playerCache.values();
        for (PlayerManager pManager : set) {
            if (pManager.getPlayer() == null || !pManager.getPlayer().isOnline()) continue;
            pManager.unequipGadget();
        }
    }

    public void unequipPet() {
        Collection<PlayerManager> set = this.playerCache.values();
        for (PlayerManager pManager : set) {
            if (pManager.getPlayer() == null || !pManager.getPlayer().isOnline()) continue;
            pManager.unequipPet();
        }
    }

    public void unequipMorph() {
        Collection<PlayerManager> set = this.playerCache.values();
        for (PlayerManager pManager : set) {
            if (pManager.getPlayer() == null || !pManager.getPlayer().isOnline()) continue;
            pManager.unequipMorph();
        }
    }

    public void unequipBanner() {
        Collection<PlayerManager> set = this.playerCache.values();
        for (PlayerManager pManager : set) {
            if (pManager.getPlayer() == null || !pManager.getPlayer().isOnline()) continue;
            pManager.unequipBanner();
        }
    }

    public void unequipEmote() {
        Collection<PlayerManager> set = this.playerCache.values();
        for (PlayerManager pManager : set) {
            if (pManager.getPlayer() == null || !pManager.getPlayer().isOnline()) continue;
            pManager.unequipEmote();
        }
    }

    public void unequipCloak() {
        Collection<PlayerManager> set = this.playerCache.values();
        for (PlayerManager pManager : set) {
            if (pManager.getPlayer() == null || !pManager.getPlayer().isOnline()) continue;
            pManager.unequipCloak();
        }
    }
}

