/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.updater;

import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdaterChecker {
    private String currentVersion;
    private String newVersion;
    private boolean outdated;
    private UpdateResult result;

    public UpdaterChecker(JavaPlugin plugin) {
        block5: {
            this.outdated = false;
            this.result = UpdateResult.NO_UPDATE;
            String resourceId = "10885";
            this.currentVersion = plugin.getDescription().getVersion();
            this.currentVersion = this.convertVersionStr(this.currentVersion);
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL("https://api.spigotmc.org/legacy/update.php?resource=" + resourceId).openConnection();
                String version = new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine();
                this.newVersion = this.convertVersionStr(version);
                try {
                    if (VersionManager.isVersionGreater(this.newVersion, this.currentVersion)) {
                        this.result = UpdateResult.UPDATE_AVAILABLE;
                        this.outdated = true;
                        break block5;
                    }
                    this.result = UpdateResult.NO_UPDATE;
                }
                catch (NumberFormatException e) {
                    this.result = UpdateResult.FAIL_SPIGOT;
                }
            }
            catch (Exception e) {
                this.result = UpdateResult.FAIL_SPIGOT;
            }
        }
    }

    public synchronized UpdateResult getResult() {
        return this.result;
    }

    public synchronized boolean isOutdated() {
        return this.outdated;
    }

    public synchronized String getCurrentVersion() {
        return this.currentVersion;
    }

    public synchronized String getNewVersion() {
        return this.newVersion;
    }

    private String convertVersionStr(String versionStr) {
        int index = versionStr.length();
        if (versionStr.contains(" ")) {
            index = versionStr.indexOf(" ");
        }
        return versionStr.substring(0, index).replaceAll("[A-Za-z]", "");
    }

    public static enum UpdateResult {
        FAIL_SPIGOT("&cFailed to check for an update on spigot."),
        NO_UPDATE("&9No update was found, you are running the latest version."),
        UPDATE_AVAILABLE("&rYou have an old version of the plugin. You are using &e{CURRENT_VERSION}&r, available version &e{NEW_VERSION}&r."),
        WRONG_VERSION_FORMAT("&cFailed to check for an update due to wrong version formatting.");

        private String message;

        private UpdateResult(String message) {
            this.message = message;
        }

        public String getMessage() {
            return ChatUtil.format(this.message);
        }

        public String getConsoleMessage() {
            return ChatUtil.stripColor(this.message);
        }
    }
}

