/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils;

import java.awt.Color;

public class GColor {
    private int red = 0;
    private int green = 0;
    private int blue = 0;
    private String hex = "";
    private org.bukkit.Color color;

    public GColor(int red, int green, int blue) {
        if (red < 0) {
            throw new IllegalArgumentException("The red is lower than 0");
        }
        if (red > 255) {
            throw new IllegalArgumentException("The red is higher than 255");
        }
        this.red = red;
        if (green < 0) {
            throw new IllegalArgumentException("The green is lower than 0");
        }
        if (green > 255) {
            throw new IllegalArgumentException("The green is higher than 255");
        }
        this.green = green;
        if (blue < 0) {
            throw new IllegalArgumentException("The blue is lower than 0");
        }
        if (blue > 255) {
            throw new IllegalArgumentException("The blue is higher than 255");
        }
        this.blue = blue;
        this.color = org.bukkit.Color.fromRGB((int)this.red, (int)this.green, (int)this.blue);
    }

    public GColor(String hex) {
        this.hex = hex;
        if (!this.hex.startsWith("#")) {
            this.hex = "#" + this.hex;
        }
        Color color = new Color(Integer.valueOf(this.hex.substring(1, 3), 16), Integer.valueOf(this.hex.substring(3, 5), 16), Integer.valueOf(this.hex.substring(5, 7), 16));
        this.red = color.getRed();
        this.green = color.getGreen();
        this.blue = color.getBlue();
        this.color = org.bukkit.Color.fromRGB((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public org.bukkit.Color getColor() {
        return this.color;
    }

    public static String getHexFromColor(org.bukkit.Color color) {
        return ("#" + GColor.toHexString(color.getRed()) + GColor.toHexString(color.getGreen()) + GColor.toHexString(color.getBlue())).toUpperCase();
    }

    private static String toHexString(int decimal) {
        String newString = Integer.toHexString(decimal);
        if (newString.equals("0")) {
            return "00";
        }
        if (newString.length() == 1) {
            return "0" + newString;
        }
        return newString;
    }
}

