/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class PlayerUtils {
    public static List<Player> getNearbyPlayers(Location location, double range) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (Entity entity : location.getWorld().getEntities()) {
            if (!(entity instanceof Player) || !(entity.getLocation().distance(location) <= range)) continue;
            players.add((Player)entity);
        }
        return players;
    }

    public static Player getNearestPlayer(Player player, List<Player> players) {
        Player nearest = null;
        for (Player player2 : players) {
            if (nearest != null && !(player2.getLocation().distance(player.getLocation()) < nearest.getLocation().distance(player.getLocation())) || player2 == player) continue;
            nearest = player2;
        }
        return nearest;
    }

    public static boolean isPlayerLookingAtEntity(Player player, LivingEntity livingEntity) {
        Location eyeLocation = player.getEyeLocation();
        Vector toEntity = livingEntity.getEyeLocation().toVector().subtract(eyeLocation.toVector());
        double dot = toEntity.normalize().dot(eyeLocation.getDirection());
        return dot > 0.99;
    }

    public static Entity getEntityPlayerLookingAt(Player player, int radius) {
        if (player == null) {
            return null;
        }
        Entity target = null;
        double threshold = 1.0;
        for (Entity nearby : player.getNearbyEntities((double)radius, (double)radius, (double)radius)) {
            Vector vector = nearby.getLocation().toVector().subtract(player.getLocation().toVector());
            if (!(player.getLocation().getDirection().normalize().crossProduct(vector).lengthSquared() < threshold) || !(vector.normalize().dot(player.getLocation().getDirection().normalize()) >= 0.0) || target != null && !(target.getLocation().distanceSquared(player.getLocation()) > nearby.getLocation().distanceSquared(player.getLocation()))) continue;
            target = nearby;
        }
        return target;
    }

    public static List<Entity> getEntitiesPlayerLookingAt(Player player, int radius) {
        ArrayList<Entity> entitys = new ArrayList<Entity>();
        for (Entity e : player.getNearbyEntities((double)radius, (double)radius, (double)radius)) {
            if (!(e instanceof LivingEntity) || !PlayerUtils.isPlayerLookingAtEntity(player, (LivingEntity)e)) continue;
            entitys.add(e);
        }
        return entitys;
    }

    public static List<Player> getPlayers(World world) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (Entity entity : world.getEntities()) {
            if (!(entity instanceof Player)) continue;
            players.add((Player)entity);
        }
        return players;
    }
}

