/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils;

import com.yapzhenyie.GadgetsMenu.utils.ServerVersion;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public class VersionManager {
    public VersionManager() {
        if (VersionManager.getBukkitVersion() != null) {
            ServerVersion.setServerVersion(ServerVersion.valueOf(VersionManager.getBukkitVersion()));
        } else {
            ServerVersion.setServerVersion(ServerVersion.valueOfSpigotRelease(VersionManager.getMinecraftVersion()));
        }
    }

    public static boolean isPaperServer() {
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Bukkit.getName().equals("Paper");
        }
    }

    public static boolean isSupportDropped(ServerVersion nmsVersion) {
        switch (nmsVersion) {
            case v1_8_R1: 
            case v1_8_R2: 
            case v1_9_R1: 
            case v1_13_R1: {
                return true;
            }
        }
        return false;
    }

    public static boolean is1_8OrAbove() {
        return VersionManager.is1_8Version() || VersionManager.is1_9OrAbove();
    }

    public static boolean is1_9OrAbove() {
        return VersionManager.is1_9Version() || VersionManager.is1_10OrAbove();
    }

    public static boolean is1_10OrAbove() {
        return VersionManager.is1_10Version() || VersionManager.is1_11OrAbove();
    }

    public static boolean is1_11OrAbove() {
        return VersionManager.is1_11Version() || VersionManager.is1_12OrAbove();
    }

    public static boolean is1_12OrAbove() {
        return VersionManager.is1_12Version() || VersionManager.is1_13OrAbove();
    }

    public static boolean is1_13OrAbove() {
        return VersionManager.is1_13Version() || VersionManager.is1_14OrAbove();
    }

    public static boolean is1_14OrAbove() {
        return VersionManager.is1_14Version() || VersionManager.is1_15OrAbove();
    }

    public static boolean is1_15OrAbove() {
        return VersionManager.is1_15Version() || VersionManager.is1_16OrAbove();
    }

    public static boolean is1_16OrAbove() {
        return VersionManager.is1_16Version() || VersionManager.is1_17OrAbove();
    }

    public static boolean is1_17OrAbove() {
        return VersionManager.is1_17Version() || VersionManager.is1_18OrAbove();
    }

    public static boolean is1_18OrAbove() {
        return VersionManager.is1_18Version();
    }

    public static boolean is1_8Version() {
        return VersionManager.is1_8_R1Version() || VersionManager.is1_8_R2Version() || VersionManager.is1_8_R3Version();
    }

    public static boolean is1_9Version() {
        return VersionManager.is1_9_R1Version() || VersionManager.is1_9_R2Version();
    }

    public static boolean is1_10Version() {
        return VersionManager.is1_10_R1Version();
    }

    public static boolean is1_11Version() {
        return VersionManager.is1_11_R1Version();
    }

    public static boolean is1_12Version() {
        return VersionManager.is1_12_R1Version();
    }

    public static boolean is1_13Version() {
        return VersionManager.is1_13_R1Version() || VersionManager.is1_13_R2Version();
    }

    public static boolean is1_14Version() {
        return VersionManager.is1_14_R1Version();
    }

    public static boolean is1_15Version() {
        return VersionManager.is1_15_R1Version();
    }

    public static boolean is1_16Version() {
        return VersionManager.is1_16_R1Version() || VersionManager.is1_16_R2Version() || VersionManager.is1_16_R3Version();
    }

    public static boolean is1_17Version() {
        return VersionManager.is1_17_R1Version();
    }

    public static boolean is1_18Version() {
        return VersionManager.is1_18_R1Version();
    }

    public static boolean is1_8_R1Version() {
        return ServerVersion.getServerVersion() == ServerVersion.v1_8_R1;
    }

    public static boolean is1_8_R2Version() {
        return ServerVersion.getServerVersion() == ServerVersion.v1_8_R2;
    }

    public static boolean is1_8_R3Version() {
        return ServerVersion.getServerVersion() == ServerVersion.v1_8_R3;
    }

    public static boolean is1_9_R1Version() {
        return ServerVersion.getServerVersion() == ServerVersion.v1_9_R1;
    }

    public static boolean is1_9_R2Version() {
        return ServerVersion.getServerVersion() == ServerVersion.v1_9_R2;
    }

    public static boolean is1_10_R1Version() {
        return ServerVersion.getServerVersion() == ServerVersion.v1_10_R1;
    }

    public static boolean is1_11_R1Version() {
        return ServerVersion.getServerVersion() == ServerVersion.v1_11_R1;
    }

    public static boolean is1_12_R1Version() {
        return ServerVersion.getServerVersion() == ServerVersion.v1_12_R1;
    }

    public static boolean is1_13_R1Version() {
        return ServerVersion.getServerVersion() == ServerVersion.v1_13_R1;
    }

    public static boolean is1_13_R2Version() {
        return ServerVersion.getServerVersion() == ServerVersion.v1_13_R2;
    }

    public static boolean is1_14_R1Version() {
        return ServerVersion.getServerVersion() == ServerVersion.v1_14_R1;
    }

    public static boolean is1_15_R1Version() {
        return ServerVersion.getServerVersion() == ServerVersion.v1_15_R1;
    }

    public static boolean is1_16_R1Version() {
        return ServerVersion.getServerVersion() == ServerVersion.v1_16_R1;
    }

    public static boolean is1_16_R2Version() {
        return ServerVersion.getServerVersion() == ServerVersion.v1_16_R2;
    }

    public static boolean is1_16_R3Version() {
        return ServerVersion.getServerVersion() == ServerVersion.v1_16_R3;
    }

    public static boolean is1_17_R1Version() {
        return ServerVersion.getServerVersion() == ServerVersion.v1_17_R1;
    }

    public static boolean is1_18_R1Version() {
        return ServerVersion.getServerVersion() == ServerVersion.v1_18_R1;
    }

    public static String getBukkitVersion() {
        Matcher matcher = Pattern.compile("v\\d+_\\d+_R\\d+").matcher(Bukkit.getServer().getClass().getPackage().getName());
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public static String getMinecraftVersion() {
        Matcher matcher = Pattern.compile("(\\(MC: )([\\d\\.]+)(\\))").matcher(Bukkit.getVersion());
        if (matcher.find()) {
            return matcher.group(2);
        }
        return null;
    }

    private static int compare(String reference, String comparison) throws NumberFormatException {
        int i;
        String[] referenceSplit = reference.split("\\.");
        String[] comparisonSplit = comparison.split("\\.");
        int longest = Math.max(referenceSplit.length, comparisonSplit.length);
        int[] referenceNumbersArray = new int[longest];
        int[] comparisonNumbersArray = new int[longest];
        for (i = 0; i < referenceSplit.length; ++i) {
            referenceNumbersArray[i] = Integer.parseInt(referenceSplit[i]);
        }
        for (i = 0; i < comparisonSplit.length; ++i) {
            comparisonNumbersArray[i] = Integer.parseInt(comparisonSplit[i]);
        }
        for (i = 0; i < longest; ++i) {
            int diff = referenceNumbersArray[i] - comparisonNumbersArray[i];
            if (diff > 0) {
                return 1;
            }
            if (diff >= 0) continue;
            return -1;
        }
        return 0;
    }

    private static int compare(String reference, String comparison, int splitNumbers) throws NumberFormatException {
        int i;
        String[] referenceSplit = reference.split("\\.");
        String[] comparisonSplit = comparison.split("\\.");
        int longest = Math.max(referenceSplit.length, comparisonSplit.length);
        int[] referenceNumbersArray = new int[longest];
        int[] comparisonNumbersArray = new int[longest];
        for (i = 0; i < splitNumbers; ++i) {
            referenceNumbersArray[i] = Integer.parseInt(referenceSplit[i]);
        }
        for (i = 0; i < splitNumbers; ++i) {
            comparisonNumbersArray[i] = Integer.parseInt(comparisonSplit[i]);
        }
        for (i = 0; i < longest; ++i) {
            int diff = referenceNumbersArray[i] - comparisonNumbersArray[i];
            if (diff > 0) {
                return 1;
            }
            if (diff >= 0) continue;
            return -1;
        }
        return 0;
    }

    public static boolean isVersionGreater(String reference, String thanWhat) {
        return VersionManager.compare(reference, thanWhat) > 0;
    }

    public static boolean isVersionGreaterEqual(String reference, String thanWhat) {
        return VersionManager.compare(reference, thanWhat) >= 0;
    }

    public static boolean isVersionLessEqual(String reference, String thanWhat) {
        return VersionManager.compare(reference, thanWhat) <= 0;
    }

    public static boolean isVersionBetweenEqual(String reference, String lowest, String highest) {
        return VersionManager.isVersionGreaterEqual(reference, lowest) && VersionManager.isVersionLessEqual(reference, highest);
    }

    public static boolean isSupported(String reference, String lowest, String highest) {
        return VersionManager.compare(reference, lowest, 2) >= 0 && VersionManager.compare(reference, highest, 2) <= 0;
    }

    public static boolean isClassExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

