/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils.cosmetics.pets;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.pets.GEntity;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.pets.GEntityType;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.pets.types.GOcelotType;
import org.bukkit.DyeColor;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieVillager;

public class EntityPet {
    public static boolean canBreed(EntityType entityType) {
        String[] types;
        for (String ent : types = new String[]{"Chicken", "Cow", "Donkey", "Horse", "Llama", "Mule", "Mushroom_Cow", "Ocelot", "Cat", "Pig", "Polar_Bear", "Rabbit", "Sheep", "Villager", "Wolf", "Zombie_Horse"}) {
            try {
                if (entityType != EntityType.valueOf((String)ent.toUpperCase())) continue;
                return true;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isAgeable(EntityType entityType) {
        String[] types;
        for (String ent : types = new String[]{"Chicken", "Cow", "Donkey", "Horse", "Husk", "Llama", "Mule", "Mushroom_Cow", "Ocelot", "Cat", "Pig", "Pig_Zombie", "ZOMBIFIED_PIGLIN", "Polar_Bear", "Rabbit", "Sheep", "Villager", "Wolf", "Zombie", "Zombie_Horse", "Zombie_Villager", "Skeleton_Horse"}) {
            try {
                if (entityType != EntityType.valueOf((String)ent.toUpperCase())) continue;
                return true;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isTameable(EntityType entityType) {
        String[] types;
        for (String ent : types = new String[]{"Donkey", "Horse", "Llama", "Mule", "Ocelot", "Cat", "Parrot", "Wolf", "Zombie_Horse"}) {
            try {
                if (entityType != EntityType.valueOf((String)ent.toUpperCase())) continue;
                return true;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return false;
    }

    public static void setAge(Entity entity, EntityType entityType, boolean baby) {
        if (EntityPet.isAgeable(entityType)) {
            GadgetsMenu.getNMSManager().pet(entity).setBaby(baby);
        }
    }

    public static boolean isSizeAble(EntityType entityType) {
        return entityType == EntityType.SLIME || entityType == EntityType.MAGMA_CUBE;
    }

    public static boolean isCreeper(EntityType entityType) {
        return entityType == EntityType.CREEPER;
    }

    public static boolean isHorse(EntityType entityType) {
        return entityType == EntityType.HORSE;
    }

    public static boolean isOcelot(GEntity type) {
        return type == GEntity.OCELOT || type == GEntity.CAT;
    }

    public static boolean isRabbit(EntityType entityType) {
        return entityType == EntityType.RABBIT;
    }

    public static boolean isSheep(EntityType entityType) {
        return entityType == EntityType.SHEEP;
    }

    public static boolean isSkeleton(EntityType entityType) {
        return entityType == EntityType.SKELETON;
    }

    public static boolean isVillager(EntityType entityType) {
        return entityType == EntityType.VILLAGER;
    }

    public static boolean isZombie(EntityType entityType) {
        if (entityType == EntityType.ZOMBIE) {
            return true;
        }
        try {
            if (entityType == EntityType.ZOMBIE_VILLAGER) {
                return true;
            }
        }
        catch (NoSuchFieldError e) {
            return false;
        }
        return false;
    }

    public static boolean isLlama(EntityType entityType) {
        try {
            if (entityType == EntityType.LLAMA) {
                return true;
            }
        }
        catch (NoSuchFieldError e) {
            return false;
        }
        return false;
    }

    public static DyeColor getColor(Entity entity, DyeColor dyeColor) {
        return ((Sheep)entity).getColor();
    }

    public static void setCreeperPowered(Entity entity, boolean arg0) {
        ((Creeper)entity).setPowered(arg0);
    }

    public static void setHorseColor(Entity entity, Horse.Color color) {
        ((Horse)entity).setColor(color);
        if (color != Horse.Color.WHITE) {
            ((Horse)entity).setStyle(Horse.Style.WHITEFIELD);
        }
    }

    public static void setLlamaColor(Entity entity, Llama.Color color) {
        ((Llama)entity).setColor(color);
        ((Llama)entity).setCarryingChest(false);
    }

    public static void setSheepColor(Entity entity, DyeColor dyeColor) {
        ((Sheep)entity).setColor(dyeColor);
    }

    public static void setWolfColor(Entity entity, DyeColor dyeColor) {
        ((Wolf)entity).setCollarColor(dyeColor);
    }

    public static void setHorseVariant(Entity entity, Horse.Variant variant) {
        if (!VersionManager.is1_11OrAbove()) {
            ((Horse)entity).setVariant(variant);
        }
    }

    public static void setOcelotType(Entity entity, GEntityType entityType, GOcelotType type) {
        if (VersionManager.is1_14OrAbove()) {
            if (entityType != GEntityType.WILD_OCELOT && entityType != GEntityType.BABY_WILD_OCELOT) {
                ((Cat)entity).setCatType(type.getType());
            }
        } else {
            ((Ocelot)entity).setCatType(type.getDepracatedType());
        }
    }

    public static void setRabbitType(Entity entity, Rabbit.Type type) {
        ((Rabbit)entity).setRabbitType(type);
    }

    public static void setSkeletonType(Entity entity, Skeleton.SkeletonType skeletonType) {
        if (!VersionManager.is1_11OrAbove()) {
            ((Skeleton)entity).setSkeletonType(skeletonType);
        }
    }

    public static void setVillagerProfession(Entity entity, Villager.Profession profession) {
        ((Villager)entity).setProfession(profession);
    }

    public static void setZombieProfession(Entity entity, Villager.Profession profession) {
        if (VersionManager.is1_11OrAbove()) {
            ((ZombieVillager)entity).setVillagerProfession(profession);
        } else if (VersionManager.is1_9OrAbove()) {
            ((Zombie)entity).setVillagerProfession(profession);
        } else {
            ((Zombie)entity).setVillager(true);
        }
    }

    public static boolean getPetNotWorking(EntityType entityType) {
        String[] test2;
        for (String ent : test2 = new String[]{"Ghast", "Enderman", "Magma_Cube", "Ender_Dragon", "Wither", "Guardian", "Bat", "Squid"}) {
            if (entityType != EntityType.valueOf((String)ent.toUpperCase())) continue;
            return true;
        }
        return false;
    }
}

