/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils.items;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.EnumPotion;
import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import com.yapzhenyie.GadgetsMenu.utils.GlowUtil;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class InventoryUtils {
    public static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("[{]([^{}]+)[}]");

    public static void fillItems(Inventory inventory) {
        if (GadgetsMenu.getGadgetsMenuData().isFillEmptySlotWithItemEnabled()) {
            for (int i = 0; i < inventory.getSize(); ++i) {
                if (inventory.getItem(i) != null && inventory.getItem(i).getType() != Material.AIR) continue;
                inventory.setItem(i, GadgetsMenu.getGadgetsMenuData().getFillEmptySlotItemStack());
            }
        }
    }

    public static int findAvailableSlot(int slot, int inventorySize) {
        if (slot > inventorySize) {
            while (slot > inventorySize) {
                slot -= 9;
            }
            return slot;
        }
        return slot;
    }

    public static int findSlotAboveItem(int itemSlot, int inventorySize) {
        if (itemSlot - 9 > inventorySize || itemSlot - 9 < 0) {
            if (itemSlot > inventorySize || itemSlot + 9 > inventorySize) {
                return 0;
            }
            return itemSlot + 9;
        }
        return itemSlot - 9;
    }

    public static int findSlotBelowItem(int itemSlot, int inventorySize) {
        if (itemSlot > inventorySize || itemSlot + 9 > inventorySize) {
            if (itemSlot - 9 > inventorySize || itemSlot - 9 < 0) {
                return 0;
            }
            return itemSlot - 9;
        }
        return itemSlot + 9;
    }

    public static ItemStack inventory(Inventory inventory, ItemStack itemStack, int slot) {
        inventory.setItem(slot, itemStack);
        return itemStack;
    }

    public static ItemStack inventory(Inventory inventory, ItemStack itemStack, String placeHolder, String replacement, int slot) {
        ItemStack item = itemStack.clone();
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta.getLore() != null) {
            ArrayList<String> itemLore = new ArrayList<String>();
            for (String s1 : itemMeta.getLore()) {
                itemLore.add(ChatUtil.format(s1.replace(placeHolder, replacement)));
            }
            itemMeta.setLore(itemLore);
        }
        item.setItemMeta(itemMeta);
        inventory.setItem(slot, item);
        return item;
    }

    public static ItemStack inventory(Inventory inventory, ItemStack itemStack, List<String> placeHolders, List<String> replacements, int slot) {
        ItemStack item = itemStack.clone();
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta.getLore() != null) {
            ArrayList<String> itemLore = new ArrayList<String>();
            for (String s1 : itemMeta.getLore()) {
                if (placeHolders.size() == replacements.size()) {
                    String lore = s1;
                    for (int i = 0; i < placeHolders.size(); ++i) {
                        lore = ChatUtil.format(lore.replace(placeHolders.get(i), replacements.get(i)));
                    }
                    itemLore.add(lore);
                    continue;
                }
                itemLore.add(ChatUtil.format(s1));
            }
            itemMeta.setLore(itemLore);
        }
        InventoryUtils.addItemFlags(itemMeta);
        item.setItemMeta(itemMeta);
        inventory.setItem(slot, item);
        return item;
    }

    public static ItemStack inventory(Inventory inventory, ItemStack itemStack, String lore, String placeHolder, String replacement, int slot) {
        ItemStack item = itemStack.clone();
        ItemMeta itemMeta = item.getItemMeta();
        if (lore != null) {
            List itemLore = itemMeta.getLore();
            itemLore.add(ChatUtil.format(lore.replace(placeHolder, replacement)));
            itemMeta.setLore(itemLore);
        }
        InventoryUtils.addItemFlags(itemMeta);
        item.setItemMeta(itemMeta);
        inventory.setItem(slot, item);
        return item;
    }

    public static ItemStack inventory(Inventory inventory, String displayName, GMaterial material, List<String> lore, int slot) {
        return InventoryUtils.inventory(inventory, displayName, material, 1, lore, slot);
    }

    public static ItemStack inventory(Inventory inventory, String displayName, GMaterial material, int amount, List<String> lore, int slot) {
        return InventoryUtils.inventory(inventory, displayName, material, amount, lore, null, null, slot);
    }

    public static ItemStack inventory(Inventory inventory, String displayName, GMaterial material, List<String> lore, List<String> additionalLore, int slot) {
        return InventoryUtils.inventory(inventory, displayName, material, 1, lore, additionalLore, null, slot);
    }

    public static ItemStack inventory(Inventory inventory, String displayName, GMaterial material, int amount, List<String> lore, List<String> additionalLore, int slot) {
        return InventoryUtils.inventory(inventory, displayName, material, amount, lore, additionalLore, null, slot);
    }

    public static ItemStack inventory(Inventory inventory, String displayName, GMaterial material, List<String> lore, List<String> additionalLore, List<String> additionalLore2, int slot) {
        return InventoryUtils.inventory(inventory, displayName, material, 1, lore, additionalLore, additionalLore2, slot);
    }

    public static ItemStack inventory(Inventory inventory, String displayName, GMaterial material, int amount, List<String> lore, List<String> additionalLore, List<String> additionalLore2, int slot) {
        if (material.isSkullHead()) {
            ItemStack head = new ItemStack(EnumMaterial.PLAYER_HEAD.getType(), amount, (short)EnumMaterial.PLAYER_HEAD.getData());
            SkullMeta skullMeta = (SkullMeta)head.getItemMeta();
            skullMeta.setDisplayName(ChatUtil.format(displayName));
            ArrayList<String> itemLore = new ArrayList<String>();
            if (lore != null) {
                for (String s1 : lore) {
                    itemLore.add(ChatUtil.format(s1));
                }
            }
            if (additionalLore != null) {
                for (String s2 : additionalLore) {
                    itemLore.add(ChatUtil.format(s2));
                }
            }
            if (additionalLore2 != null) {
                for (String s3 : additionalLore2) {
                    itemLore.add(ChatUtil.format(s3));
                }
            }
            if (lore != null || additionalLore != null || additionalLore2 != null) {
                skullMeta.setLore(itemLore);
            }
            return InventoryUtils.skullData(inventory, head, skullMeta, material.getTexture(), slot);
        }
        if (material.isBanner()) {
            ItemStack item = new ItemStack(material.getBannerPatterns().getBaseColor().getColoredBanner().getType(), 1);
            BannerMeta itemMeta = (BannerMeta)item.getItemMeta();
            itemMeta.setDisplayName(ChatUtil.format(displayName));
            if (material.getBannerPatterns().getBaseColor() != null) {
                itemMeta.setBaseColor(material.getBannerPatterns().getBaseColor().getColor());
            }
            if (material.getBannerPatterns().getPatterns() != null) {
                itemMeta.setPatterns(material.getBannerPatterns().getPatterns());
            }
            ArrayList<String> itemLore = new ArrayList<String>();
            if (lore != null) {
                for (String s1 : lore) {
                    itemLore.add(ChatUtil.format(s1));
                }
            }
            if (additionalLore != null) {
                for (String s2 : additionalLore) {
                    itemLore.add(ChatUtil.format(s2));
                }
            }
            if (additionalLore2 != null) {
                for (String s3 : additionalLore2) {
                    itemLore.add(ChatUtil.format(s3));
                }
            }
            if (lore != null || additionalLore != null || additionalLore2 != null) {
                itemMeta.setLore(itemLore);
            }
            InventoryUtils.addItemFlags((ItemMeta)itemMeta);
            item.setItemMeta((ItemMeta)itemMeta);
            inventory.setItem(slot, item);
            return item;
        }
        EnumMaterial enumMaterial = material.getEnumMaterial();
        ItemStack item = new ItemStack(enumMaterial.getType(), amount, (short)material.getData());
        ItemMeta itemMeta = item.getItemMeta();
        if (material.isColorableMaterial()) {
            itemMeta = (LeatherArmorMeta)item.getItemMeta();
            ((LeatherArmorMeta)itemMeta).setColor(material.getColor());
        }
        itemMeta.setDisplayName(ChatUtil.format(displayName));
        ArrayList<String> itemLore = new ArrayList<String>();
        if (lore != null) {
            for (String s1 : lore) {
                itemLore.add(ChatUtil.format(s1));
            }
        }
        if (additionalLore != null) {
            for (String s2 : additionalLore) {
                itemLore.add(ChatUtil.format(s2));
            }
        }
        if (additionalLore2 != null) {
            for (String s3 : additionalLore2) {
                itemLore.add(ChatUtil.format(s3));
            }
        }
        if (lore != null || additionalLore != null || additionalLore2 != null) {
            itemMeta.setLore(itemLore);
        }
        return InventoryUtils.itemData(inventory, enumMaterial, material.getData(), item, itemMeta, slot);
    }

    public static ItemStack inventoryCategory(Player player, Inventory inventory, String displayName, GMaterial material, List<String> lore, List<String> permissionLore, int slot, int unlockedItems, int size) {
        if (material.isSkullHead()) {
            ItemStack head = new ItemStack(EnumMaterial.PLAYER_HEAD.getType(), 1, (short)EnumMaterial.PLAYER_HEAD.getData());
            SkullMeta skullMeta = (SkullMeta)head.getItemMeta();
            skullMeta.setDisplayName(ChatUtil.format(displayName));
            ArrayList<String> itemLore = new ArrayList<String>();
            if (lore != null) {
                for (String s1 : lore) {
                    itemLore.add(ChatUtil.format(s1));
                }
            }
            if (permissionLore != null) {
                for (String s2 : permissionLore) {
                    itemLore.add(ChatUtil.format(s2));
                }
            }
            if (lore != null || permissionLore != null) {
                skullMeta.setLore(itemLore);
            }
            if (EnumItem.UNLOCKED.isShowInLore()) {
                for (String unlockedLore : EnumItem.UNLOCKED.getLore()) {
                    if (PLACEHOLDER_PATTERN.matcher(unlockedLore).find()) {
                        itemLore.add(ChatUtil.format(unlockedLore.replace("{HASPERMISSION}", String.valueOf(unlockedItems)).replace("{SIZE}", String.valueOf(size)).replace("{PERCENTAGE}", String.valueOf(unlockedItems * 100 / size))));
                        continue;
                    }
                    itemLore.add(ChatUtil.format(unlockedLore));
                }
                skullMeta.setLore(itemLore);
            }
            return InventoryUtils.skullData(inventory, head, skullMeta, material.getTexture(), slot);
        }
        if (material.isBanner()) {
            ItemStack item = new ItemStack(material.getBannerPatterns().getBaseColor().getColoredBanner().getType(), 1);
            BannerMeta itemMeta = (BannerMeta)item.getItemMeta();
            itemMeta.setDisplayName(ChatUtil.format(displayName));
            if (material.getBannerPatterns().getBaseColor() != null) {
                itemMeta.setBaseColor(material.getBannerPatterns().getBaseColor().getColor());
            }
            if (material.getBannerPatterns().getPatterns() != null) {
                itemMeta.setPatterns(material.getBannerPatterns().getPatterns());
            }
            ArrayList<String> itemLore = new ArrayList<String>();
            if (lore != null) {
                for (String s1 : lore) {
                    itemLore.add(ChatUtil.format(s1));
                }
            }
            if (permissionLore != null) {
                for (String s2 : permissionLore) {
                    itemLore.add(ChatUtil.format(s2));
                }
            }
            if (lore != null || permissionLore != null) {
                itemMeta.setLore(itemLore);
            }
            if (EnumItem.UNLOCKED.isShowInLore()) {
                for (String unlockedLore : EnumItem.UNLOCKED.getLore()) {
                    if (PLACEHOLDER_PATTERN.matcher(unlockedLore).find()) {
                        itemLore.add(ChatUtil.format(unlockedLore.replace("{HASPERMISSION}", String.valueOf(unlockedItems)).replace("{SIZE}", String.valueOf(size)).replace("{PERCENTAGE}", String.valueOf(unlockedItems * 100 / size))));
                        continue;
                    }
                    itemLore.add(ChatUtil.format(unlockedLore));
                }
                itemMeta.setLore(itemLore);
            }
            InventoryUtils.addItemFlags((ItemMeta)itemMeta);
            item.setItemMeta((ItemMeta)itemMeta);
            inventory.setItem(slot, item);
            return item;
        }
        EnumMaterial enumMaterial = material.getEnumMaterial();
        ItemStack item = new ItemStack(enumMaterial.getType(), 1, (short)material.getData());
        ItemMeta itemMeta = item.getItemMeta();
        if (material.isColorableMaterial()) {
            itemMeta = (LeatherArmorMeta)item.getItemMeta();
            ((LeatherArmorMeta)itemMeta).setColor(material.getColor());
        }
        itemMeta.setDisplayName(ChatUtil.format(displayName));
        ArrayList<String> itemLore = new ArrayList<String>();
        if (lore != null) {
            for (String s1 : lore) {
                itemLore.add(ChatUtil.format(s1));
            }
        }
        if (permissionLore != null) {
            for (String s2 : permissionLore) {
                itemLore.add(ChatUtil.format(s2));
            }
        }
        if (lore != null || permissionLore != null) {
            itemMeta.setLore(itemLore);
        }
        if (EnumItem.UNLOCKED.isShowInLore()) {
            for (String unlockedLore : EnumItem.UNLOCKED.getLore()) {
                if (PLACEHOLDER_PATTERN.matcher(unlockedLore).find()) {
                    itemLore.add(ChatUtil.format(unlockedLore.replace("{HASPERMISSION}", String.valueOf(unlockedItems)).replace("{SIZE}", String.valueOf(size)).replace("{PERCENTAGE}", String.valueOf(unlockedItems * 100 / size))));
                    continue;
                }
                itemLore.add(ChatUtil.format(unlockedLore));
            }
            itemMeta.setLore(itemLore);
        }
        return InventoryUtils.itemData(inventory, enumMaterial, material.getData(), item, itemMeta, slot);
    }

    public static ItemStack inventoryAddGlow(Inventory inventory, String displayName, GMaterial material, List<String> lore, List<String> additionalLore, int slot, String equippedCosmeticName) {
        if (material.isSkullHead()) {
            String url = material.getTexture();
            if (!url.startsWith("http://textures.minecraft.net/texture/")) {
                url = "http://textures.minecraft.net/texture/" + url;
            }
            ItemStack head = new ItemStack(EnumMaterial.PLAYER_HEAD.getType(), 1, (short)EnumMaterial.PLAYER_HEAD.getData());
            SkullMeta skullMeta = (SkullMeta)head.getItemMeta();
            skullMeta.setDisplayName(ChatUtil.format(displayName));
            ArrayList<String> itemLore = new ArrayList<String>();
            if (lore != null) {
                for (String s1 : lore) {
                    itemLore.add(ChatUtil.format(s1));
                }
            }
            if (additionalLore != null) {
                for (String s2 : additionalLore) {
                    itemLore.add(ChatUtil.format(s2));
                }
            }
            if (lore != null || additionalLore != null) {
                skullMeta.setLore(itemLore);
            }
            return InventoryUtils.skullData(inventory, head, skullMeta, url, itemLore, displayName, equippedCosmeticName, slot);
        }
        if (material.isBanner()) {
            ItemStack item = new ItemStack(material.getBannerPatterns().getBaseColor().getColoredBanner().getType(), 1);
            BannerMeta itemMeta = (BannerMeta)item.getItemMeta();
            itemMeta.setDisplayName(ChatUtil.format(displayName));
            if (material.getBannerPatterns().getBaseColor() != null) {
                itemMeta.setBaseColor(material.getBannerPatterns().getBaseColor().getColor());
            }
            if (material.getBannerPatterns().getPatterns() != null) {
                itemMeta.setPatterns(material.getBannerPatterns().getPatterns());
            }
            ArrayList<String> itemLore = new ArrayList<String>();
            if (lore != null) {
                for (String s1 : lore) {
                    itemLore.add(ChatUtil.format(s1));
                }
            }
            if (additionalLore != null) {
                for (String s2 : additionalLore) {
                    itemLore.add(ChatUtil.format(s2));
                }
            }
            if (lore != null || additionalLore != null) {
                itemMeta.setLore(itemLore);
            }
            InventoryUtils.addItemFlags((ItemMeta)itemMeta);
            item.setItemMeta((ItemMeta)itemMeta);
            item = InventoryUtils.addEquipStatus(item, (ItemMeta)itemMeta, itemLore, displayName, equippedCosmeticName);
            inventory.setItem(slot, item);
            return item;
        }
        EnumMaterial enumMaterial = material.getEnumMaterial();
        ItemStack item = new ItemStack(enumMaterial.getType(), 1, (short)material.getData());
        ItemMeta itemMeta = item.getItemMeta();
        if (material.isColorableMaterial()) {
            itemMeta = (LeatherArmorMeta)item.getItemMeta();
            ((LeatherArmorMeta)itemMeta).setColor(material.getColor());
        }
        itemMeta.setDisplayName(ChatUtil.format(displayName));
        ArrayList<String> itemLore = new ArrayList<String>();
        if (lore != null) {
            for (String s1 : lore) {
                itemLore.add(ChatUtil.format(s1));
            }
        }
        if (additionalLore != null) {
            for (String s2 : additionalLore) {
                itemLore.add(ChatUtil.format(s2));
            }
        }
        if (lore != null || additionalLore != null) {
            itemMeta.setLore(itemLore);
        }
        return InventoryUtils.itemData(inventory, enumMaterial, material.getData(), item, itemMeta, itemLore, displayName, equippedCosmeticName, slot);
    }

    public static ItemStack inventoryCategoryAddGlow(Player player, Inventory inventory, String displayName, GMaterial material, List<String> lore, List<String> additionalLore, int slot, String equippedCategoryName, int unlockedItems, int size) {
        if (material.isSkullHead()) {
            ItemStack head = new ItemStack(EnumMaterial.PLAYER_HEAD.getType(), 1, (short)EnumMaterial.PLAYER_HEAD.getData());
            SkullMeta skullMeta = (SkullMeta)head.getItemMeta();
            skullMeta.setDisplayName(ChatUtil.format(displayName));
            ArrayList<String> itemLore = new ArrayList<String>();
            if (lore != null) {
                for (String s1 : lore) {
                    itemLore.add(ChatUtil.format(s1));
                }
            }
            if (additionalLore != null) {
                for (String s2 : additionalLore) {
                    itemLore.add(ChatUtil.format(s2));
                }
            }
            if (lore != null || additionalLore != null) {
                skullMeta.setLore(itemLore);
            }
            if (EnumItem.UNLOCKED.isShowInLore()) {
                for (String unlockedLore : EnumItem.UNLOCKED.getLore()) {
                    if (PLACEHOLDER_PATTERN.matcher(unlockedLore).find()) {
                        itemLore.add(ChatUtil.format(unlockedLore.replace("{HASPERMISSION}", String.valueOf(unlockedItems)).replace("{SIZE}", String.valueOf(size)).replace("{PERCENTAGE}", String.valueOf(unlockedItems * 100 / size))));
                        continue;
                    }
                    itemLore.add(ChatUtil.format(unlockedLore));
                }
                skullMeta.setLore(itemLore);
                head.setItemMeta((ItemMeta)skullMeta);
            }
            return InventoryUtils.skullData(inventory, head, skullMeta, material.getTexture(), slot);
        }
        if (material.isBanner()) {
            ItemStack item = new ItemStack(material.getBannerPatterns().getBaseColor().getColoredBanner().getType(), 1);
            BannerMeta itemMeta = (BannerMeta)item.getItemMeta();
            itemMeta.setDisplayName(ChatUtil.format(displayName));
            if (material.getBannerPatterns().getBaseColor() != null) {
                itemMeta.setBaseColor(material.getBannerPatterns().getBaseColor().getColor());
            }
            if (material.getBannerPatterns().getPatterns() != null) {
                itemMeta.setPatterns(material.getBannerPatterns().getPatterns());
            }
            ArrayList<String> itemLore = new ArrayList<String>();
            if (lore != null) {
                for (String s1 : lore) {
                    itemLore.add(ChatUtil.format(s1));
                }
            }
            if (additionalLore != null) {
                for (String s2 : additionalLore) {
                    itemLore.add(ChatUtil.format(s2));
                }
            }
            if (lore != null || additionalLore != null) {
                itemMeta.setLore(itemLore);
            }
            if (EnumItem.UNLOCKED.isShowInLore()) {
                for (String unlockedLore : EnumItem.UNLOCKED.getLore()) {
                    if (PLACEHOLDER_PATTERN.matcher(unlockedLore).find()) {
                        itemLore.add(ChatUtil.format(unlockedLore.replace("{HASPERMISSION}", String.valueOf(unlockedItems)).replace("{SIZE}", String.valueOf(size)).replace("{PERCENTAGE}", String.valueOf(unlockedItems * 100 / size))));
                        continue;
                    }
                    itemLore.add(ChatUtil.format(unlockedLore));
                }
                itemMeta.setLore(itemLore);
                item.setItemMeta((ItemMeta)itemMeta);
            }
            InventoryUtils.addItemFlags((ItemMeta)itemMeta);
            item.setItemMeta((ItemMeta)itemMeta);
            if (equippedCategoryName != null && equippedCategoryName.equals(ChatUtil.format(displayName))) {
                item = GlowUtil.addGlow(item);
            }
            inventory.setItem(slot, item);
            return item;
        }
        EnumMaterial enumMaterial = material.getEnumMaterial();
        ItemStack item = new ItemStack(enumMaterial.getType(), 1, (short)material.getData());
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(ChatUtil.format(displayName));
        ArrayList<String> itemLore = new ArrayList<String>();
        if (lore != null) {
            for (String s1 : lore) {
                itemLore.add(ChatUtil.format(s1));
            }
        }
        if (additionalLore != null) {
            for (String s2 : additionalLore) {
                itemLore.add(ChatUtil.format(s2));
            }
        }
        if (lore != null || additionalLore != null) {
            itemMeta.setLore(itemLore);
        }
        if (EnumItem.UNLOCKED.isShowInLore()) {
            for (String unlockedLore : EnumItem.UNLOCKED.getLore()) {
                if (PLACEHOLDER_PATTERN.matcher(unlockedLore).find()) {
                    itemLore.add(ChatUtil.format(unlockedLore.replace("{HASPERMISSION}", String.valueOf(unlockedItems)).replace("{SIZE}", String.valueOf(size)).replace("{PERCENTAGE}", String.valueOf(unlockedItems * 100 / size))));
                    continue;
                }
                itemLore.add(ChatUtil.format(unlockedLore));
            }
            itemMeta.setLore(itemLore);
            item.setItemMeta(itemMeta);
        }
        if (VersionManager.is1_9OrAbove() && EnumPotion.isPotion(enumMaterial)) {
            item.setDurability((short)0);
        }
        InventoryUtils.addItemFlags(itemMeta);
        item.setItemMeta(itemMeta);
        if (equippedCategoryName != null && equippedCategoryName.equals(ChatUtil.format(displayName))) {
            item = GlowUtil.addGlow(item);
        }
        if (VersionManager.is1_9OrAbove()) {
            if (!VersionManager.is1_13OrAbove() && material.getEnumMaterial().isSpawnEgg()) {
                item = GadgetsMenu.getNMSManager().spawnEgg(item, EntityType.fromId((int)material.getData()).getName());
            }
            if (EnumPotion.isPotion(enumMaterial)) {
                item = GadgetsMenu.getNMSManager().getPotionFromId(item, material);
            }
        }
        inventory.setItem(slot, item);
        return item;
    }

    public static ItemStack inventorySkull(Inventory inventory, String displayName, List<String> lore, List<String> additionalLore, Player owner, int slot) {
        ItemStack head = new ItemStack(EnumMaterial.PLAYER_HEAD.getType(), 1, (short)EnumMaterial.PLAYER_HEAD.getData());
        SkullMeta skullMeta = (SkullMeta)head.getItemMeta();
        skullMeta.setDisplayName(ChatUtil.format(displayName));
        skullMeta.setOwner(owner.getName());
        ArrayList<String> itemLore = new ArrayList<String>();
        if (lore != null) {
            for (String s1 : lore) {
                itemLore.add(ChatUtil.format(s1));
            }
        }
        if (additionalLore != null) {
            for (String s2 : additionalLore) {
                itemLore.add(ChatUtil.format(s2));
            }
        }
        if (lore != null || additionalLore != null) {
            skullMeta.setLore(itemLore);
        }
        InventoryUtils.addItemFlags((ItemMeta)skullMeta);
        head.setItemMeta((ItemMeta)skullMeta);
        inventory.setItem(slot, head);
        return head;
    }

    public static ItemStack mainMenuButton(PlayerManager pManager, Inventory inventory, int slot) {
        Validate.notNull((Object)pManager);
        Validate.notNull((Object)inventory);
        EnumItem menuItem = EnumItem.MAIN_MENU_ITEM;
        if (menuItem.getMaterial().isSkullHead()) {
            ItemStack head = new ItemStack(EnumMaterial.PLAYER_HEAD.getType(), 1, (short)EnumMaterial.PLAYER_HEAD.getData());
            SkullMeta skullMeta = (SkullMeta)head.getItemMeta();
            skullMeta.setDisplayName(ChatUtil.format(menuItem.getDisplayName()));
            if (menuItem.getLore() != null) {
                ArrayList<String> itemLore = new ArrayList<String>();
                for (String s1 : menuItem.getLore()) {
                    itemLore.add(ChatUtil.format(s1.replace("{MYSTERY_DUST}", String.valueOf(pManager.getMysteryDust())).replace("{MYSTERY_BOXES}", String.valueOf(pManager.getMysteryBoxes()))));
                }
                skullMeta.setLore(itemLore);
            }
            return InventoryUtils.skullData(inventory, head, skullMeta, menuItem.getMaterial().getTexture(), slot);
        }
        ItemStack item = new ItemStack(menuItem.getMaterial().getEnumMaterial().getType(), 1, (short)menuItem.getMaterial().getData());
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(ChatUtil.format(menuItem.getDisplayName()));
        if (menuItem.getLore() != null) {
            ArrayList<String> itemLore = new ArrayList<String>();
            for (String s1 : menuItem.getLore()) {
                itemLore.add(ChatUtil.format(s1.replace("{MYSTERY_DUST}", String.valueOf(pManager.getMysteryDust())).replace("{MYSTERY_BOXES}", String.valueOf(pManager.getMysteryBoxes()))));
            }
            itemMeta.setLore(itemLore);
        }
        return InventoryUtils.itemData(inventory, menuItem.getMaterial().getEnumMaterial(), menuItem.getMaterial().getData(), item, itemMeta, slot);
    }

    public static ItemStack itemData(Inventory inventory, EnumMaterial material, int data, ItemStack item, ItemMeta itemMeta, int slot) {
        if (VersionManager.is1_9OrAbove() && EnumPotion.isPotion(material)) {
            item.setDurability((short)0);
        }
        InventoryUtils.addItemFlags(itemMeta);
        item.setItemMeta(itemMeta);
        if (VersionManager.is1_9OrAbove()) {
            if (!VersionManager.is1_13OrAbove() && material.isSpawnEgg()) {
                item = GadgetsMenu.getNMSManager().spawnEgg(item, EntityType.fromId((int)data).getName());
            }
            if (EnumPotion.isPotion(material)) {
                item = GadgetsMenu.getNMSManager().getPotionFromId(item, material, data);
            }
        }
        inventory.setItem(slot, item);
        return item;
    }

    public static ItemStack itemData(Inventory inventory, EnumMaterial material, int data, ItemStack item, ItemMeta itemMeta, ArrayList<String> itemLore, String displayName, String equippedCosmeticName, int slot) {
        if (VersionManager.is1_9OrAbove() && EnumPotion.isPotion(material)) {
            item.setDurability((short)0);
        }
        InventoryUtils.addItemFlags(itemMeta);
        item.setItemMeta(itemMeta);
        item = InventoryUtils.addEquipStatus(item, itemMeta, itemLore, displayName, equippedCosmeticName);
        if (VersionManager.is1_9OrAbove()) {
            if (!VersionManager.is1_13OrAbove() && material.isSpawnEgg()) {
                item = GadgetsMenu.getNMSManager().spawnEgg(item, EntityType.fromId((int)data).getName());
            }
            if (EnumPotion.isPotion(material)) {
                item = GadgetsMenu.getNMSManager().getPotionFromId(item, material, data);
            }
        }
        inventory.setItem(slot, item);
        return item;
    }

    public static ItemStack skullData(Inventory inventory, ItemStack head, SkullMeta skullMeta, String url, int slot) {
        if (!url.startsWith("http://textures.minecraft.net/texture/")) {
            url = "http://textures.minecraft.net/texture/" + url;
        }
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        byte[] encodedData = Base64.getEncoder().encode(String.format("{textures:{SKIN:{url:\"%s\"}}}", url).getBytes());
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", new String(encodedData)));
        try {
            ReflectionUtils.setValue(skullMeta, true, "profile", profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        InventoryUtils.addItemFlags((ItemMeta)skullMeta);
        head.setItemMeta((ItemMeta)skullMeta);
        inventory.setItem(slot, head);
        return head;
    }

    public static ItemStack skullData(Inventory inventory, ItemStack head, SkullMeta skullMeta, String url, ArrayList<String> itemLore, String displayName, String equippedCosmeticName, int slot) {
        head = InventoryUtils.addEquipStatus(head, (ItemMeta)skullMeta, itemLore, displayName, equippedCosmeticName);
        return InventoryUtils.skullData(inventory, head, skullMeta, url, slot);
    }

    public static ItemStack addEquipStatus(ItemStack item, ItemMeta itemMeta, ArrayList<String> itemLore, String displayName, String equippedCosmeticName) {
        if (equippedCosmeticName != null && equippedCosmeticName.equals(ChatUtil.format(displayName))) {
            if (EnumItem.ALREADY_SELECTED.isShowInLore()) {
                for (String s3 : EnumItem.ALREADY_SELECTED.getLore()) {
                    itemLore.add(ChatUtil.format(s3));
                }
                itemMeta.setLore(itemLore);
                item.setItemMeta(itemMeta);
            }
            if (!(itemMeta instanceof SkullMeta)) {
                item = GlowUtil.addGlow(item);
            }
        } else if (EnumItem.CLICK_TO_SELECT.isShowInLore()) {
            for (String s3 : EnumItem.CLICK_TO_SELECT.getLore()) {
                itemLore.add(ChatUtil.format(s3));
            }
            itemMeta.setLore(itemLore);
            item.setItemMeta(itemMeta);
        }
        return item;
    }

    public static void addItemFlags(ItemMeta itemMeta) {
        itemMeta.addItemFlags(ItemFlag.values());
    }
}

