/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils;

import com.yapzhenyie.GadgetsMenu.utils.MessageType;

public class ExpiryDateCounter {
    private long distance;
    private int days;
    private int hours;
    private int minutes;
    private int seconds;
    private String secondMsg = MessageType.SECOND.getFormatMessage().toLowerCase();
    private String secondsMsg = MessageType.SECONDS.getFormatMessage().toLowerCase();
    private String minuteMsg = MessageType.MINUTE.getFormatMessage().toLowerCase();
    private String minutesMsg = MessageType.MINUTES.getFormatMessage().toLowerCase();
    private String hourMsg = MessageType.HOUR.getFormatMessage().toLowerCase();
    private String hoursMsg = MessageType.HOURS.getFormatMessage().toLowerCase();
    private String dayMsg = MessageType.DAY.getFormatMessage().toLowerCase();
    private String daysMsg = MessageType.DAYS.getFormatMessage().toLowerCase();

    public ExpiryDateCounter(long distance) {
        this.distance = distance;
        this.days = 0;
        this.hours = 0;
        this.minutes = 0;
        this.seconds = 0;
    }

    public String getFormat() {
        if (this.distance <= 0L) {
            return "0 " + this.secondMsg;
        }
        if (this.distance >= 86400L) {
            this.days = (int)((long)this.days + this.distance / 86400L);
            this.distance -= (long)(this.days * 86400);
        }
        if (this.distance >= 3600L) {
            this.hours = (int)((long)this.hours + this.distance / 3600L);
            this.distance -= (long)(this.hours * 3600);
        }
        if (this.distance >= 60L) {
            this.minutes = (int)((long)this.minutes + this.distance / 60L);
            this.distance -= (long)(this.minutes * 60);
        }
        if (this.distance < 60L) {
            this.seconds = (int)((long)this.seconds + this.distance);
            this.distance -= (long)this.seconds;
            if (this.distance > 0L) {
                this.getFormat();
            }
        }
        String format = "0 " + this.secondMsg;
        if (this.days > 0) {
            format = this.days == 1 ? this.days + " " + this.dayMsg : this.days + " " + this.daysMsg;
            if (this.hours > 0) {
                format = this.hours == 1 ? format + ", " + this.hours + " " + this.hourMsg : format + ", " + this.hours + " " + this.hoursMsg;
            }
        } else if (this.days == 0 && this.hours > 0) {
            format = this.hours == 1 ? this.hours + " " + this.hourMsg : this.hours + " " + this.hoursMsg;
            if (this.minutes > 0) {
                format = this.minutes == 1 ? format + ", " + this.minutes + " " + this.minuteMsg : format + ", " + this.minutes + " " + this.minutesMsg;
            }
        } else if (this.days == 0 && this.hours == 0 && this.minutes > 0) {
            format = this.minutes == 1 ? this.minutes + " " + this.minuteMsg : this.minutes + " " + this.minutesMsg;
            if (this.seconds > 0) {
                format = this.seconds == 1 ? format + ", " + this.seconds + " " + this.secondMsg : format + ", " + this.seconds + " " + this.secondsMsg;
            }
        } else {
            format = this.days == 0 && this.hours == 0 && this.minutes == 0 && this.seconds > 0 ? (this.seconds == 1 ? this.seconds + " " + this.secondMsg : this.seconds + " " + this.secondsMsg) : "0 " + this.secondMsg;
        }
        return format;
    }

    public int getSeconds() {
        if (this.distance < 0L) {
            return 0;
        }
        if (this.distance >= 60L) {
            this.seconds = (int)((long)this.seconds + this.distance);
            this.distance -= (long)this.seconds;
            if (this.seconds > 0) {
                this.getSeconds();
            }
        }
        return this.seconds;
    }

    public int getMinutes() {
        if (this.distance < 0L) {
            return 0;
        }
        if (this.distance >= 60L) {
            this.minutes = (int)((long)this.minutes + this.distance / 60L);
            this.distance -= (long)(this.minutes * 60);
            if (this.distance >= 60L) {
                this.getMinutes();
            }
        }
        return this.minutes;
    }

    public int getHours() {
        if (this.distance < 0L) {
            return 0;
        }
        if (this.distance >= 3600L) {
            this.hours = (int)((long)this.hours + this.distance / 3600L);
            this.distance -= (long)(this.hours * 3600);
            if (this.distance >= 3600L) {
                this.getHours();
            }
        }
        return this.hours;
    }

    public int getDays() {
        if (this.distance < 0L) {
            return 0;
        }
        if (this.distance >= 86400L) {
            this.days = (int)((long)this.days + this.distance / 86400L);
            this.distance -= (long)(this.days * 86400);
            if (this.distance >= 86400L) {
                this.getDays();
            }
        }
        return this.days;
    }
}

