/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Quality;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVault;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVaultManager;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.AnimationType;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.GMiniBlock;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.types.Animation;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class NoneAnimation
extends Animation {
    private ArmorStand armorStand;

    public NoneAnimation(PlayerManager pManager, MysteryVault mysteryVault, Quality quality, long delay) {
        super(pManager, mysteryVault, AnimationType.NONE, quality, delay);
    }

    @Override
    public void onStart() {
        Location location = this.getMysteryVault().getLocation();
        BlockFace blockFace = this.getMysteryVault().getBlockFace();
        location = new Location(location.getWorld(), location.getX() + 0.5, location.getY() + GMiniBlock.additionY, location.getZ() + 0.5, GMiniBlock.getYawByBlockFace(blockFace), 0.0f);
        ArmorStand miniBlock = (ArmorStand)this.getPlayer().getWorld().spawnEntity(location.clone(), EntityType.ARMOR_STAND);
        miniBlock.setVisible(false);
        miniBlock.setGravity(false);
        miniBlock.setSmall(true);
        try {
            miniBlock.setMarker(false);
            miniBlock.setCollidable(false);
            miniBlock.setSilent(true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        miniBlock.setHelmet(this.getAnimation().getMiniBlock().getItemStack());
        miniBlock.setBasePlate(false);
        miniBlock.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        this.armorStand = miniBlock;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onUpdateParticleEffect() {
        if (this.steps == 0) {
            SoundEffect.ENTITY_GENERIC_EXPLODE.playSound(this.armorStand.getLocation().clone());
        } else if (this.steps == 5) {
            ParticleEffect.LAVA.display(this.armorStand.getLocation().clone().add(0.0, 0.8, 0.0), 0.0f, 45);
            ParticleEffect.FLAME.display(this.armorStand.getLocation().clone().add(0.0, 0.8, 0.0), 0.45f, 40);
        } else if (this.steps == 10) {
            ParticleEffect.CLOUD.display(this.armorStand.getLocation().clone().add(0.0, 0.8, 0.0), 0.7f, 0.7f, 0.7f);
            SoundEffect.ENTITY_EXPERIENCE_ORB_PICKUP.playSound(this.armorStand.getLocation());
        } else if (this.steps > 10 && this.steps < 30) {
            ParticleEffect.CLOUD.display(this.armorStand.getLocation().clone().add(0.0, 0.8, 0.0), 0.7f, 0.7f, 0.7f);
        } else if (this.steps >= 30) {
            this.onClear();
            this.isContinue = false;
        }
    }

    @Override
    public void onUpdateSound() {
    }

    @Override
    public void onClear() {
        if (this.armorStand != null && this.armorStand.isValid()) {
            this.armorStand.remove();
            this.armorStand = null;
        }
        if (MysteryVaultManager.activatedVaults().contains(this.getMysteryVault())) {
            MysteryVaultManager.activatedVaults().remove(this.getMysteryVault());
        }
        this.getPlayerManager().setOpeningMysteryBox(false);
    }
}

