/*
 * Decompiled with CFR 0.152.
 */
package depend.xxmicloxx.NoteBlockAPI.songplayer;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import depend.xxmicloxx.NoteBlockAPI.NoteBlockAPI;
import depend.xxmicloxx.NoteBlockAPI.event.SongDestroyingEvent;
import depend.xxmicloxx.NoteBlockAPI.event.SongEndEvent;
import depend.xxmicloxx.NoteBlockAPI.event.SongStoppedEvent;
import depend.xxmicloxx.NoteBlockAPI.model.Fade;
import depend.xxmicloxx.NoteBlockAPI.model.FadeType;
import depend.xxmicloxx.NoteBlockAPI.model.Song;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public abstract class SongPlayer {
    protected Song song;
    protected boolean playing = false;
    protected short tick = (short)-1;
    protected ArrayList<UUID> playerList = new ArrayList();
    protected boolean autoDestroy = false;
    protected boolean destroyed = false;
    protected byte volume = (byte)100;
    protected Fade fadeIn;
    protected Fade fadeOut;
    protected FadeType fadeType = FadeType.LINEAR;
    private final Lock lock = new ReentrantLock();

    public SongPlayer(Song song) {
        this.song = song;
        this.fadeIn = new Fade(FadeType.NONE, 60);
        this.fadeIn.setFadeStart((byte)0);
        this.fadeIn.setFadeTarget(this.volume);
        this.fadeOut = new Fade(FadeType.NONE, 60);
        this.fadeOut.setFadeStart(this.volume);
        this.fadeOut.setFadeTarget((byte)0);
        this.start();
    }

    protected void start() {
        Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
            while (!this.destroyed) {
                float delayMillis;
                long startTime = System.currentTimeMillis();
                this.lock.lock();
                try {
                    if (this.destroyed || GadgetsMenu.getInstance() == null || !GadgetsMenu.getInstance().isEnabled()) break;
                    if (this.playing) {
                        byte fade;
                        if (this.tick < this.fadeIn.getFadeDuration()) {
                            byte fade2 = this.fadeIn.calculateFade();
                            if (fade2 != -1) {
                                this.volume = fade2;
                            }
                        } else if (this.tick >= this.song.getLength() - this.fadeOut.getFadeDuration() && (fade = this.fadeOut.calculateFade()) != -1) {
                            this.volume = fade;
                        }
                        this.tick = (short)(this.tick + 1);
                        if (this.tick > this.song.getLength()) {
                            this.tick = (short)-1;
                            this.fadeIn.setFadeDone(0);
                            this.fadeOut.setFadeDone(0);
                            this.volume = this.fadeIn.getFadeTarget();
                            this.playing = false;
                            if (GadgetsMenu.getInstance() == null || !GadgetsMenu.getInstance().isEnabled()) {
                                return;
                            }
                            SongEndEvent event = new SongEndEvent(this);
                            Bukkit.getServer().getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> Bukkit.getPluginManager().callEvent((Event)event));
                            if (this.autoDestroy) {
                                this.destroy();
                                return;
                            }
                        } else {
                            if (GadgetsMenu.getInstance() == null || !GadgetsMenu.getInstance().isEnabled()) break;
                            Bukkit.getServer().getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                                for (UUID uuid : this.playerList) {
                                    Player player = Bukkit.getPlayer((UUID)uuid);
                                    if (player == null) continue;
                                    this.playTick(player, this.tick);
                                }
                            });
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.lock.unlock();
                }
                if (this.destroyed) break;
                long duration = System.currentTimeMillis() - startTime;
                if (!((float)duration < (delayMillis = this.song.getDelay() * 50.0f))) continue;
                try {
                    Thread.sleep((long)(delayMillis - (float)duration));
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }

    public abstract void playTick(Player var1, int var2);

    public boolean getAutoDestroy() {
        this.lock.lock();
        try {
            boolean bl = this.autoDestroy;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setAutoDestroy(boolean autoDestroy) {
        this.lock.lock();
        try {
            this.autoDestroy = autoDestroy;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void destroy() {
        if (GadgetsMenu.getInstance() == null || !GadgetsMenu.getInstance().isEnabled()) {
            return;
        }
        this.lock.lock();
        try {
            SongDestroyingEvent event = new SongDestroyingEvent(this);
            Bukkit.getServer().getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> Bukkit.getPluginManager().callEvent((Event)event));
            if (event.isCancelled()) {
                return;
            }
            this.destroyed = true;
            this.playing = false;
            this.setTick((short)-1);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean playing) {
        this.playing = playing;
        if (!playing) {
            if (GadgetsMenu.getInstance() == null || !GadgetsMenu.getInstance().isEnabled()) {
                return;
            }
            SongStoppedEvent event = new SongStoppedEvent(this);
            Bukkit.getServer().getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> Bukkit.getPluginManager().callEvent((Event)event));
        }
    }

    public short getTick() {
        return this.tick;
    }

    public void setTick(short tick) {
        this.tick = tick;
    }

    public byte getVolume() {
        return this.volume;
    }

    public void setVolume(byte volume) {
        this.volume = volume;
    }

    public Fade getFadeIn() {
        return this.fadeIn;
    }

    public Fade getFadeOut() {
        return this.fadeOut;
    }

    public Song getSong() {
        return this.song;
    }

    public List<UUID> getPlayerList() {
        return Collections.unmodifiableList(this.playerList);
    }

    public void addPlayer(Player player) {
        this.addPlayer(player.getUniqueId());
    }

    public void addPlayer(UUID uuid) {
        this.lock.lock();
        try {
            if (!this.playerList.contains(uuid)) {
                this.playerList.add(uuid);
                ArrayList<SongPlayer> songs = NoteBlockAPI.getSongPlayers(uuid);
                if (songs == null) {
                    songs = new ArrayList();
                }
                songs.add(this);
                NoteBlockAPI.setSongPlayers(uuid, songs);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removePlayer(Player player) {
        this.removePlayer(player.getUniqueId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(UUID uuid) {
        this.lock.lock();
        try {
            this.playerList.remove(uuid);
            if (NoteBlockAPI.getSongPlayers(uuid) == null) {
                return;
            }
            ArrayList<SongPlayer> songs = new ArrayList<SongPlayer>(NoteBlockAPI.getSongPlayers(uuid));
            songs.remove(this);
            NoteBlockAPI.setSongPlayers(uuid, songs);
            if (this.playerList.isEmpty() && this.autoDestroy) {
                SongEndEvent event = new SongEndEvent(this);
                Bukkit.getServer().getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> Bukkit.getPluginManager().callEvent((Event)event));
                this.destroy();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

