/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.commands.impl.cloud;

import java.util.List;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.commands.PlaceholderCommand;
import me.clip.placeholderapi.util.Msg;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class CommandECloudToggle
extends PlaceholderCommand {
    public CommandECloudToggle() {
        super("toggle", "enable", "disable");
    }

    @Override
    public void evaluate(@NotNull PlaceholderAPIPlugin plugin, @NotNull CommandSender sender, @NotNull String alias, @NotNull @Unmodifiable List<String> params) {
        boolean desiredState;
        boolean currentState = plugin.getPlaceholderAPIConfig().isCloudEnabled();
        switch (alias.toLowerCase()) {
            case "enable": {
                desiredState = true;
                break;
            }
            case "disable": {
                desiredState = false;
                break;
            }
            default: {
                boolean bl = desiredState = !currentState;
            }
        }
        if (desiredState == currentState) {
            Msg.msg(sender, "&7The eCloud Manager is already " + (desiredState ? "enabled" : "disabled"));
            return;
        }
        plugin.getPlaceholderAPIConfig().setCloudEnabled(desiredState);
        if (desiredState) {
            plugin.getCloudExpansionManager().load();
        } else {
            plugin.getCloudExpansionManager().kill();
        }
        Msg.msg(sender, "&aThe eCloud Manager has been " + (desiredState ? "enabled" : "disabled"));
    }
}

