/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.replacer;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.replacer.Replacer;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegexReplacer
implements Replacer {
    @NotNull
    private final Pattern pattern;

    public RegexReplacer(@NotNull Replacer.Closure closure) {
        this.pattern = Pattern.compile(String.format("\\%s((?<identifier>[a-zA-Z0-9]+)_)(?<parameters>[^%s%s]+)\\%s", Character.valueOf(closure.head), Character.valueOf(closure.head), Character.valueOf(closure.tail), Character.valueOf(closure.tail)));
    }

    @Override
    @NotNull
    public String apply(@NotNull String text, @Nullable OfflinePlayer player, @NotNull Function<String, @Nullable PlaceholderExpansion> lookup) {
        Matcher matcher = this.pattern.matcher(text);
        if (!matcher.find()) {
            return text;
        }
        StringBuffer builder = new StringBuffer();
        do {
            String identifier = matcher.group("identifier");
            String parameters = matcher.group("parameters");
            PlaceholderExpansion expansion = lookup.apply(identifier);
            if (expansion == null) continue;
            String requested = expansion.onRequest(player, parameters);
            matcher.appendReplacement(builder, requested != null ? requested : matcher.group(0));
        } while (matcher.find());
        return ChatColor.translateAlternateColorCodes((char)'&', (String)matcher.appendTail(builder).toString());
    }
}

