/*
 * Decompiled with CFR 0.152.
 */
package ruben_artz.spigot.utils;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import ruben_artz.spigot.main.GMain;
import ruben_artz.spigot.metrics.Metrics;

public class GUtils {
    private static final GMain plugin = (GMain)GMain.getPlugin(GMain.class);
    private static final Pattern HEX_PATTERN_ONE = Pattern.compile("#([A-Fa-f0-9]{6})");
    private static final Pattern HEX_PATTERN_TWO = Pattern.compile("\\{#[a-fA-F0-9]{6}}");

    public static String addColors(String message) {
        if (GUtils.isVersion_1_16_To_1_19()) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)GUtils.setHexColors(message));
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static String setPlaceholders(Player p, String text) {
        if (GUtils.isPluginEnabled("PlaceholderAPI")) {
            return PlaceholderAPI.setPlaceholders((Player)p, (String)text);
        }
        return text;
    }

    private static String getHex(String message) {
        Matcher matcher = HEX_PATTERN_ONE.matcher(message);
        StringBuffer buffer = new StringBuffer(message.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(buffer, "\u00a7x\u00a7" + group.charAt(0) + '\u00a7' + group.charAt(1) + '\u00a7' + group.charAt(2) + '\u00a7' + group.charAt(3) + '\u00a7' + group.charAt(4) + '\u00a7' + group.charAt(5));
        }
        return matcher.appendTail(buffer).toString();
    }

    private static String setHexColors(String msg) {
        Matcher match = HEX_PATTERN_TWO.matcher(msg);
        while (match.find()) {
            String hex = msg.substring(match.start(), match.end());
            msg = StringUtils.replace((String)msg, (String)hex, (String)("" + net.md_5.bungee.api.ChatColor.of((String)hex.replace("{", "").replace("}", ""))));
            match = HEX_PATTERN_TWO.matcher(msg);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)GUtils.getHex(msg));
    }

    public static boolean isPluginEnabled(String args) {
        return Bukkit.getPluginManager().getPlugin(args) != null && Objects.requireNonNull(Bukkit.getPluginManager().getPlugin(args)).isEnabled();
    }

    public static void sendMessage(Player everyone, Player winner, String message) {
        everyone.sendMessage(GUtils.addColors(GUtils.setPlaceholders(winner, message)));
    }

    public static void addGolden(Player player) {
        GUtils.plugin.write.add(player.getUniqueId());
    }

    public static void setMetrics() {
        Metrics metrics = new Metrics(plugin, 12442);
        metrics.addCustomChart(new Metrics.SingleLineChart("players", () -> Bukkit.getOnlinePlayers().size()));
    }

    public static boolean isVersion_1_16_To_1_19() {
        return Bukkit.getVersion().contains("1.16") || Bukkit.getVersion().contains("1.17") || Bukkit.getVersion().contains("1.18") || Bukkit.getVersion().contains("1.19");
    }
}

